// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesClassificationCategoryResponse Defines the structure of the response for classification categories.
//
// swagger:model data_engine_governance_policies_classification_category_response
type DataEngineGovernancePoliciesClassificationCategoryResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// data engine governance policies classification category response inline records
	DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords []*DataEngineGovernancePoliciesClassificationCategory `json:"records,omitempty"`

	// The number of classification category records returned in the response.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of classification categories available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine governance policies classification category response
func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) validateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine governance policies classification category response based on the context it is used
func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) contextValidateDataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords); i++ {

		if m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationCategoryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationCategoryResponse) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationCategoryResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
