// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesClassificationClassifier Defines the structure of a classifier.
//
// swagger:model data_engine_governance_policies_classification_classifier
type DataEngineGovernancePoliciesClassificationClassifier struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the classifier was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates if the classifier is custom or predefined.
	// Example: false
	Custom *bool `json:"custom,omitempty"`

	// Description of the classifier.
	// Example: classifier for data subjects(i.e., person names)
	Description *string `json:"description,omitempty"`

	// Name of the classifier.
	// Example: data subjects classifier
	Name *string `json:"name,omitempty"`

	// State of the classifier. Possible values are:
	// * <i>enabled</i>: Classifier is enabled.
	// * <i>disabled</i>: Classifier is disabled.
	// * <i>simulate</i>: Classifier is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// Tag associated with the classifier.
	// Example: CLS_ENTD00000
	Tag *string `json:"tag,omitempty"`

	// Specifies the type of classifier. Possible values are:
	// * <i>data</i>: Classifier for data entities.
	// * <i>document</i>: Classifier for document entities.
	//
	// Example: data
	// Enum: ["data","document"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the classifier was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the classifier.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies classification classifier
func (m *DataEngineGovernancePoliciesClassificationClassifier) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassificationClassifierTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationClassifierTypeStatePropEnum = append(dataEngineGovernancePoliciesClassificationClassifierTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_classifier
	// DataEngineGovernancePoliciesClassificationClassifier
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesClassificationClassifierStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_classifier
	// DataEngineGovernancePoliciesClassificationClassifier
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesClassificationClassifierStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_classifier
	// DataEngineGovernancePoliciesClassificationClassifier
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesClassificationClassifierStateSimulate string = "simulate"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassificationClassifier) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationClassifierTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassificationClassifierTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","document"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationClassifierTypeTypePropEnum = append(dataEngineGovernancePoliciesClassificationClassifierTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_classifier
	// DataEngineGovernancePoliciesClassificationClassifier
	// type
	// Type
	// data
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierTypeData captures enum value "data"
	DataEngineGovernancePoliciesClassificationClassifierTypeData string = "data"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_classifier
	// DataEngineGovernancePoliciesClassificationClassifier
	// type
	// Type
	// document
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationClassifierTypeDocument captures enum value "document"
	DataEngineGovernancePoliciesClassificationClassifierTypeDocument string = "document"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassificationClassifier) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationClassifierTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies classification classifier based on the context it is used
func (m *DataEngineGovernancePoliciesClassificationClassifier) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifier) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationClassifier) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationClassifier) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationClassifier
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
