// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesClassificationClassifierResponse Defines the structure of the response for classifiers.
//
// swagger:model data_engine_governance_policies_classification_classifier_response
type DataEngineGovernancePoliciesClassificationClassifierResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// data engine governance policies classification classifier response inline records
	DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords []*DataEngineGovernancePoliciesClassificationClassifier `json:"records,omitempty"`

	// The number of records returned in the response.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of classifiers available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine governance policies classification classifier response
func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) validateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine governance policies classification classifier response based on the context it is used
func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) contextValidateDataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords); i++ {

		if m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationClassifierResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationClassifierResponse) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationClassifierResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
