// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesClassifier Defines the structure of a classifier.
//
// swagger:model data_engine_governance_policies_classifier
type DataEngineGovernancePoliciesClassifier struct {

	// The timestamp indicating when the classifier was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates if the classifier is custom or predefined.
	// Example: false
	Custom *bool `json:"custom,omitempty"`

	// Description of the classifier.
	// Example: classifier for data subjects(i.e., person names)
	Description *string `json:"description,omitempty"`

	// Name of the classifier.
	// Example: data subjects classifier
	Name *string `json:"name,omitempty"`

	// State of the classifier. Possible values are:
	// * <i>enabled</i>: Classifier is enabled.
	// * <i>disabled</i>: Classifier is disabled.
	// * <i>simulate</i>: Classifier is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// Tag associated with the classifier.
	// Example: CLS_ENTD00000
	Tag *string `json:"tag,omitempty"`

	// Specifies the type of classifier. Possible values are:
	// * <i>data</i>: Classifier for data entities.
	// * <i>document</i>: Classifier for document entities.
	//
	// Example: data
	// Enum: ["data","document"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the classifier was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the classifier.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies classifier
func (m *DataEngineGovernancePoliciesClassifier) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassifierTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassifierTypeStatePropEnum = append(dataEngineGovernancePoliciesClassifierTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classifier
	// DataEngineGovernancePoliciesClassifier
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassifierStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesClassifierStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classifier
	// DataEngineGovernancePoliciesClassifier
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassifierStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesClassifierStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classifier
	// DataEngineGovernancePoliciesClassifier
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassifierStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesClassifierStateSimulate string = "simulate"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassifier) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassifierTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassifierTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","document"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassifierTypeTypePropEnum = append(dataEngineGovernancePoliciesClassifierTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classifier
	// DataEngineGovernancePoliciesClassifier
	// type
	// Type
	// data
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassifierTypeData captures enum value "data"
	DataEngineGovernancePoliciesClassifierTypeData string = "data"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classifier
	// DataEngineGovernancePoliciesClassifier
	// type
	// Type
	// document
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassifierTypeDocument captures enum value "document"
	DataEngineGovernancePoliciesClassifierTypeDocument string = "document"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassifier) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassifierTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies classifier based on the context it is used
func (m *DataEngineGovernancePoliciesClassifier) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassifier) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassifier) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassifier) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassifier
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
