// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesGuardrail Defines the structure of a guardrail.
//
// swagger:model data_engine_governance_policies_guardrail
type DataEngineGovernancePoliciesGuardrail struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the guardrail was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// List of actions associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineActions []*DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem `json:"actions,omitempty"`

	// List of conditions associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineConditions []*DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem `json:"conditions,omitempty"`

	// List of classifier or category tags which has issues.
	DataEngineGovernancePoliciesGuardrailInlineIssueTags []*DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem `json:"issue_tags,omitempty"`

	// List of workspaces associated with the guardrail.
	DataEngineGovernancePoliciesGuardrailInlineWorkspaces []*DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem `json:"workspaces,omitempty"`

	// Description of the guardrail.
	// Example: exclude credit card number from data
	Description *string `json:"description,omitempty"`

	// Indicates if the guardrail has any issues.
	// Example: false
	// Read Only: true
	HasIssue *bool `json:"has_issue,omitempty"`

	// The number of files impacted by the guardrail.
	// Example: 100
	// Read Only: true
	ImpactedFilesCount *int64 `json:"impacted_files_count,omitempty"`

	// Name of the guardrail.
	// Example: exclude credit card number
	Name *string `json:"name,omitempty"`

	// State of the guardrail. Possible values are:
	// * <i>enabled</i>: Guardrail is enabled.
	// * <i>disabled</i>: Guardrail is disabled.
	// * <i>simulate</i>: Guardrail is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// The timestamp indicating when the guardrail was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// UUID of the guardrail.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies guardrail
func (m *DataEngineGovernancePoliciesGuardrail) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesGuardrailInlineActions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesGuardrailInlineConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesGuardrailInlineIssueTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateDataEngineGovernancePoliciesGuardrailInlineActions(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineActions) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineActions); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineActions[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesGuardrailInlineActions[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineActions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateDataEngineGovernancePoliciesGuardrailInlineConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineConditions) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineConditions); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineConditions[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesGuardrailInlineConditions[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineConditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateDataEngineGovernancePoliciesGuardrailInlineIssueTags(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineIssueTags) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineIssueTags); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("issue_tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var dataEngineGovernancePoliciesGuardrailTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailTypeStatePropEnum = append(dataEngineGovernancePoliciesGuardrailTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail
	// DataEngineGovernancePoliciesGuardrail
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesGuardrailStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail
	// DataEngineGovernancePoliciesGuardrail
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesGuardrailStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail
	// DataEngineGovernancePoliciesGuardrail
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesGuardrailStateSimulate string = "simulate"
)

// prop value enum
func (m *DataEngineGovernancePoliciesGuardrail) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail based on the context it is used
func (m *DataEngineGovernancePoliciesGuardrail) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesGuardrailInlineActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesGuardrailInlineConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesGuardrailInlineIssueTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasIssue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImpactedFilesCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateDataEngineGovernancePoliciesGuardrailInlineActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineActions); i++ {

		if m.DataEngineGovernancePoliciesGuardrailInlineActions[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineActions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateDataEngineGovernancePoliciesGuardrailInlineConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineConditions); i++ {

		if m.DataEngineGovernancePoliciesGuardrailInlineConditions[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineConditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateDataEngineGovernancePoliciesGuardrailInlineIssueTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineIssueTags); i++ {

		if m.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineIssueTags[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("issue_tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateDataEngineGovernancePoliciesGuardrailInlineWorkspaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces); i++ {

		if m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i] != nil {
			if err := m.DataEngineGovernancePoliciesGuardrailInlineWorkspaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateHasIssue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "has_issue", "body", m.HasIssue); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateImpactedFilesCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "impacted_files_count", "body", m.ImpactedFilesCount); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrail) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrail) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrail) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrail
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem data engine governance policies guardrail inline actions inline array item
//
// swagger:model data_engine_governance_policies_guardrail_inline_actions_inline_array_item
type DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem struct {

	// specifies type of action. Possible values are:
	// * <i>exclude</i>: Exclude data.
	// * <i>exclude_pre_existing</i>: Exclude pre-existing data.
	// * <i>anonymize</i>: Anonymize data.
	//
	// Example: exclude
	// Enum: ["exclude","exclude_pre_existing","anonymize"]
	ActionType *string `json:"action_type,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline actions inline array item
func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActionType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["exclude","exclude_pre_existing","anonymize"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// exclude
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExclude captures enum value "exclude"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExclude string = "exclude"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// exclude_pre_existing
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExcludePreExisting captures enum value "exclude_pre_existing"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeExcludePreExisting string = "exclude_pre_existing"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_actions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	// action_type
	// ActionType
	// anonymize
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeAnonymize captures enum value "anonymize"
	DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemActionTypeAnonymize string = "anonymize"
)

// prop value enum
func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) validateActionTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItemTypeActionTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) validateActionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ActionType) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionTypeEnum("action_type", "body", *m.ActionType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance policies guardrail inline actions inline array item based on context it is used
func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineActionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem data engine governance policies guardrail inline conditions inline array item
//
// swagger:model data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
type DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem struct {

	// List of classifier or category tags associated with the condition.
	Items []*string `json:"items"`

	// specifies operator for condition. Possible values are:
	// * <i>all</i>: All conditions must be met.
	// * <i>any</i>: Any one of the conditions must be met.
	//
	// Example: all
	// Enum: ["all","any"]
	Operator *string `json:"operator,omitempty"`

	// specifies type of condition. Possible values are:
	// * <i>data_classifier_category</i>: Condition based on data classifier category.
	// * <i>document_classifier_category</i>: Condition based on document classifier category.
	// * <i>data_classifier</i>: Condition based on data classifier.
	// * <i>document_classifier</i>: Condition based on document classifier.
	//
	// Example: data_classifier_category
	// Enum: ["data_classifier_category","document_classifier_category","data_classifier","document_classifier"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline conditions inline array item
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOperator(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","any"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum = append(dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// operator
	// Operator
	// all
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAll captures enum value "all"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAll string = "all"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// operator
	// Operator
	// any
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAny captures enum value "any"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemOperatorAny string = "any"
)

// prop value enum
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateOperatorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeOperatorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateOperator(formats strfmt.Registry) error {
	if swag.IsZero(m.Operator) { // not required
		return nil
	}

	// value enum
	if err := m.validateOperatorEnum("operator", "body", *m.Operator); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_classifier_category","document_classifier_category","data_classifier","document_classifier"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// data_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifierCategory captures enum value "data_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifierCategory string = "data_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// document_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifierCategory captures enum value "document_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifierCategory string = "document_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// data_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifier captures enum value "data_classifier"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDataClassifier string = "data_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_conditions_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	// type
	// Type
	// document_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifier captures enum value "document_classifier"
	DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeDocumentClassifier string = "document_classifier"
)

// prop value enum
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance policies guardrail inline conditions inline array item based on context it is used
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineConditionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem data engine governance policies guardrail inline issue tags inline array item
//
// swagger:model data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
type DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem struct {

	// Type of the tag. Possible values are:
	// * <i>data_classifier</i>: Data classifier tag.
	// * <i>document_classifier</i>: Document classifier tag.
	// * <i>data_classifier_category</i>: Data classifier category tag.
	// * <i>document_classifier_category</i>: Document classifier category tag.
	//
	// Example: data_classifier
	// Read Only: true
	// Enum: ["data_classifier","document_classifier","data_classifier_category","document_classifier_category"]
	ClassificationType *string `json:"classification_type,omitempty"`

	// Tag of the classifier or category.
	// Example: CLS_ENTD00000
	// Read Only: true
	Tag *string `json:"tag,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline issue tags inline array item
func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClassificationType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_classifier","document_classifier","data_classifier_category","document_classifier_category"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum = append(dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// data_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifier captures enum value "data_classifier"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifier string = "data_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// document_classifier
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifier captures enum value "document_classifier"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifier string = "document_classifier"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// data_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifierCategory captures enum value "data_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDataClassifierCategory string = "data_classifier_category"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_guardrail_inline_issue_tags_inline_array_item
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	// classification_type
	// ClassificationType
	// document_classifier_category
	// END DEBUGGING
	// DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifierCategory captures enum value "document_classifier_category"
	DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemClassificationTypeDocumentClassifierCategory string = "document_classifier_category"
)

// prop value enum
func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) validateClassificationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItemTypeClassificationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) validateClassificationType(formats strfmt.Registry) error {
	if swag.IsZero(m.ClassificationType) { // not required
		return nil
	}

	// value enum
	if err := m.validateClassificationTypeEnum("classification_type", "body", *m.ClassificationType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail inline issue tags inline array item based on the context it is used
func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClassificationType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTag(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) contextValidateClassificationType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "classification_type", "body", m.ClassificationType); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) contextValidateTag(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tag", "body", m.Tag); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineIssueTagsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem data engine governance policies guardrail inline workspaces inline array item
//
// swagger:model data_engine_governance_policies_guardrail_inline_workspaces_inline_array_item
type DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem struct {

	// Name of the workspace.
	// Example: workspace1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// UUID of the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies guardrail inline workspaces inline array item
func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies guardrail inline workspaces inline array item based on the context it is used
func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesGuardrailInlineWorkspacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
