// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineJob Data engine job related information.
//
// swagger:model data_engine_job
type DataEngineJob struct {

	// links
	Links *DataEngineJobInlineLinks `json:"_links,omitempty"`

	// The creation time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The list of direct children of the job.
	DataEngineJobInlineSubJobs []*DataEngineSubJob `json:"sub_jobs,omitempty"`

	// Job tags in string format.
	DataEngineJobInlineTags []*string `json:"tags,omitempty"`

	// The description of the job.
	// Example: Workspace Create Job
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The end time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// error
	Error *DcnCommonError `json:"error,omitempty"`

	// The name of the job.
	// Example: workspace create
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// parent job
	ParentJob *DataEngineJobInlineParentJob `json:"parent_job,omitempty"`

	// The percentage of the job that is completed.
	// Example: 5
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// resource
	Resource *DataEngineJobInlineResource `json:"resource,omitempty"`

	// The start time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// The state of the data engine job:
	// * <i>queued</i> - The job is queued for execution.
	// * <i>running</i> - The job is currently in execution.
	// * <i>success</i> - The job has been completed successfully.
	// * <i>failure</i> - The job has failed.
	//
	// Example: success
	// Read Only: true
	// Enum: ["queued","running","success","failure"]
	State *string `json:"state,omitempty"`

	// The timeout period of the job in minutes.
	// Example: 30
	// Read Only: true
	Timeout *int64 `json:"timeout,omitempty"`

	// The type of the job.
	// Example: workspace_create
	// Read Only: true
	// Enum: ["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]
	Type *string `json:"type,omitempty"`

	// The update time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The unique identifier of the job.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine job
func (m *DataEngineJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineJobInlineSubJobs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJob) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) validateDataEngineJobInlineSubJobs(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineJobInlineSubJobs) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineJobInlineSubJobs); i++ {
		if swag.IsZero(m.DataEngineJobInlineSubJobs[i]) { // not required
			continue
		}

		if m.DataEngineJobInlineSubJobs[i] != nil {
			if err := m.DataEngineJobInlineSubJobs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sub_jobs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineJob) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) validateParentJob(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentJob) { // not required
		return nil
	}

	if m.ParentJob != nil {
		if err := m.ParentJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) validatePercentComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentComplete) { // not required
		return nil
	}

	if err := validate.MinimumInt("percent_complete", "body", *m.PercentComplete, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("percent_complete", "body", *m.PercentComplete, 100, false); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEngineJobTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["queued","running","success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineJobTypeStatePropEnum = append(dataEngineJobTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// state
	// State
	// queued
	// END DEBUGGING
	// DataEngineJobStateQueued captures enum value "queued"
	DataEngineJobStateQueued string = "queued"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// state
	// State
	// running
	// END DEBUGGING
	// DataEngineJobStateRunning captures enum value "running"
	DataEngineJobStateRunning string = "running"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// state
	// State
	// success
	// END DEBUGGING
	// DataEngineJobStateSuccess captures enum value "success"
	DataEngineJobStateSuccess string = "success"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// state
	// State
	// failure
	// END DEBUGGING
	// DataEngineJobStateFailure captures enum value "failure"
	DataEngineJobStateFailure string = "failure"
)

// prop value enum
func (m *DataEngineJob) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineJobTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineJobTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineJobTypeTypePropEnum = append(dataEngineJobTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_create
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceCreate captures enum value "workspace_create"
	DataEngineJobTypeWorkspaceCreate string = "workspace_create"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_update
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceUpdate captures enum value "workspace_update"
	DataEngineJobTypeWorkspaceUpdate string = "workspace_update"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_delete
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceDelete captures enum value "workspace_delete"
	DataEngineJobTypeWorkspaceDelete string = "workspace_delete"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_refresh
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceRefresh captures enum value "workspace_refresh"
	DataEngineJobTypeWorkspaceRefresh string = "workspace_refresh"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_restore
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceRestore captures enum value "workspace_restore"
	DataEngineJobTypeWorkspaceRestore string = "workspace_restore"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_content_processing
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceContentProcessing captures enum value "workspace_content_processing"
	DataEngineJobTypeWorkspaceContentProcessing string = "workspace_content_processing"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// workspace_versioning
	// END DEBUGGING
	// DataEngineJobTypeWorkspaceVersioning captures enum value "workspace_versioning"
	DataEngineJobTypeWorkspaceVersioning string = "workspace_versioning"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_create
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionCreate captures enum value "data_collection_create"
	DataEngineJobTypeDataCollectionCreate string = "data_collection_create"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_update
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionUpdate captures enum value "data_collection_update"
	DataEngineJobTypeDataCollectionUpdate string = "data_collection_update"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_delete
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionDelete captures enum value "data_collection_delete"
	DataEngineJobTypeDataCollectionDelete string = "data_collection_delete"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_refresh
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionRefresh captures enum value "data_collection_refresh"
	DataEngineJobTypeDataCollectionRefresh string = "data_collection_refresh"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_restore
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionRestore captures enum value "data_collection_restore"
	DataEngineJobTypeDataCollectionRestore string = "data_collection_restore"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_content_processing
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionContentProcessing captures enum value "data_collection_content_processing"
	DataEngineJobTypeDataCollectionContentProcessing string = "data_collection_content_processing"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_collection_versioning
	// END DEBUGGING
	// DataEngineJobTypeDataCollectionVersioning captures enum value "data_collection_versioning"
	DataEngineJobTypeDataCollectionVersioning string = "data_collection_versioning"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_source_create
	// END DEBUGGING
	// DataEngineJobTypeDataSourceCreate captures enum value "data_source_create"
	DataEngineJobTypeDataSourceCreate string = "data_source_create"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_source_update
	// END DEBUGGING
	// DataEngineJobTypeDataSourceUpdate captures enum value "data_source_update"
	DataEngineJobTypeDataSourceUpdate string = "data_source_update"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_source_delete
	// END DEBUGGING
	// DataEngineJobTypeDataSourceDelete captures enum value "data_source_delete"
	DataEngineJobTypeDataSourceDelete string = "data_source_delete"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// data_source_refresh
	// END DEBUGGING
	// DataEngineJobTypeDataSourceRefresh captures enum value "data_source_refresh"
	DataEngineJobTypeDataSourceRefresh string = "data_source_refresh"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// policy_enforcement
	// END DEBUGGING
	// DataEngineJobTypePolicyEnforcement captures enum value "policy_enforcement"
	DataEngineJobTypePolicyEnforcement string = "policy_enforcement"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// cleanup
	// END DEBUGGING
	// DataEngineJobTypeCleanup captures enum value "cleanup"
	DataEngineJobTypeCleanup string = "cleanup"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// entity_preview
	// END DEBUGGING
	// DataEngineJobTypeEntityPreview captures enum value "entity_preview"
	DataEngineJobTypeEntityPreview string = "entity_preview"

	// BEGIN DEBUGGING
	// data_engine_job
	// DataEngineJob
	// type
	// Type
	// entity_cache_cleanup
	// END DEBUGGING
	// DataEngineJobTypeEntityCacheCleanup captures enum value "entity_cache_cleanup"
	DataEngineJobTypeEntityCacheCleanup string = "entity_cache_cleanup"
)

// prop value enum
func (m *DataEngineJob) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineJobTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineJob) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine job based on the context it is used
func (m *DataEngineJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineJobInlineSubJobs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineJobInlineTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJob) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateDataEngineJobInlineSubJobs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineJobInlineSubJobs); i++ {

		if m.DataEngineJobInlineSubJobs[i] != nil {
			if err := m.DataEngineJobInlineSubJobs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sub_jobs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineJob) contextValidateDataEngineJobInlineTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineJobInlineTags); i++ {

		if err := validate.ReadOnly(ctx, "tags"+"."+strconv.Itoa(i), "body", m.DataEngineJobInlineTags[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DataEngineJob) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateParentJob(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentJob != nil {
		if err := m.ParentJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {
		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineJob) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timeout", "body", m.Timeout); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineJob) UnmarshalBinary(b []byte) error {
	var res DataEngineJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineJobInlineLinks data engine job inline links
//
// swagger:model data_engine_job_inline__links
type DataEngineJobInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this data engine job inline links
func (m *DataEngineJobInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJobInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine job inline links based on the context it is used
func (m *DataEngineJobInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJobInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineJobInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineJobInlineLinks) UnmarshalBinary(b []byte) error {
	var res DataEngineJobInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineJobInlineParentJob The parent job reference of the job.
//
// swagger:model data_engine_job_inline_parent_job
type DataEngineJobInlineParentJob struct {

	// The unique identifier of the parent job.
	// Example: 123e4567-e89b-12d3-a456-426614173000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine job inline parent job
func (m *DataEngineJobInlineParentJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJobInlineParentJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("parent_job"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine job inline parent job based on the context it is used
func (m *DataEngineJobInlineParentJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJobInlineParentJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "parent_job"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineJobInlineParentJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineJobInlineParentJob) UnmarshalBinary(b []byte) error {
	var res DataEngineJobInlineParentJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineJobInlineResource The data engine resource for which the job has been created.
//
// swagger:model data_engine_job_inline_resource
type DataEngineJobInlineResource struct {

	// The name of the data engine resource.
	// Example: workspace_1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The type of the data engine resource.
	// Example: workspace
	// Read Only: true
	// Enum: ["workspace","data_source","data_collection","policy","entity"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the data engine resource.
	// Example: 123e4567-e89b-12d3-a456-426614173000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine job inline resource
func (m *DataEngineJobInlineResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineJobInlineResourceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace","data_source","data_collection","policy","entity"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineJobInlineResourceTypeTypePropEnum = append(dataEngineJobInlineResourceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_job_inline_resource
	// DataEngineJobInlineResource
	// type
	// Type
	// workspace
	// END DEBUGGING
	// DataEngineJobInlineResourceTypeWorkspace captures enum value "workspace"
	DataEngineJobInlineResourceTypeWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// data_engine_job_inline_resource
	// DataEngineJobInlineResource
	// type
	// Type
	// data_source
	// END DEBUGGING
	// DataEngineJobInlineResourceTypeDataSource captures enum value "data_source"
	DataEngineJobInlineResourceTypeDataSource string = "data_source"

	// BEGIN DEBUGGING
	// data_engine_job_inline_resource
	// DataEngineJobInlineResource
	// type
	// Type
	// data_collection
	// END DEBUGGING
	// DataEngineJobInlineResourceTypeDataCollection captures enum value "data_collection"
	DataEngineJobInlineResourceTypeDataCollection string = "data_collection"

	// BEGIN DEBUGGING
	// data_engine_job_inline_resource
	// DataEngineJobInlineResource
	// type
	// Type
	// policy
	// END DEBUGGING
	// DataEngineJobInlineResourceTypePolicy captures enum value "policy"
	DataEngineJobInlineResourceTypePolicy string = "policy"

	// BEGIN DEBUGGING
	// data_engine_job_inline_resource
	// DataEngineJobInlineResource
	// type
	// Type
	// entity
	// END DEBUGGING
	// DataEngineJobInlineResourceTypeEntity captures enum value "entity"
	DataEngineJobInlineResourceTypeEntity string = "entity"
)

// prop value enum
func (m *DataEngineJobInlineResource) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineJobInlineResourceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineJobInlineResource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("resource"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJobInlineResource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("resource"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine job inline resource based on the context it is used
func (m *DataEngineJobInlineResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineJobInlineResource) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJobInlineResource) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineJobInlineResource) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineJobInlineResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineJobInlineResource) UnmarshalBinary(b []byte) error {
	var res DataEngineJobInlineResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
