// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineOperationsArrayInline data engine operations array inline
//
// swagger:model data_engine_operations_array_inline
type DataEngineOperationsArrayInline []*DataEngineOperationsArrayInlineInlineArrayItem

// Validate validates this data engine operations array inline
func (m DataEngineOperationsArrayInline) Validate(formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {
		if swag.IsZero(m[i]) { // not required
			continue
		}

		if m[i] != nil {
			if err := m[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validate this data engine operations array inline based on the context it is used
func (m DataEngineOperationsArrayInline) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {

		if m[i] != nil {
			if err := m[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// DataEngineOperationsArrayInlineInlineArrayItem data engine operations array inline inline array item
//
// swagger:model data_engine_operations_array_inline_inline_array_item
type DataEngineOperationsArrayInlineInlineArrayItem struct {

	// The name of the operation, service, or pod.
	// Example: content_processing
	Name *string `json:"name,omitempty"`

	// The consumption percentage of the operation, service, or pod.
	// Example: 25
	// Maximum: 100
	// Minimum: 0
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this data engine operations array inline inline array item
func (m *DataEngineOperationsArrayInlineInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUsedPercent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineOperationsArrayInlineInlineArrayItem) validateUsedPercent(formats strfmt.Registry) error {
	if swag.IsZero(m.UsedPercent) { // not required
		return nil
	}

	if err := validate.MinimumInt("used_percent", "body", *m.UsedPercent, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("used_percent", "body", *m.UsedPercent, 100, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine operations array inline inline array item based on context it is used
func (m *DataEngineOperationsArrayInlineInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineOperationsArrayInlineInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineOperationsArrayInlineInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineOperationsArrayInlineInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
