// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEnginePolicy Data engine policy.
//
// swagger:model data_engine_policy
type DataEnginePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the data engine policy was created. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// A list of actions to be performed by the data engine policy.
	DataEnginePolicyInlineActions []*DataEnginePolicyInlineActionsInlineArrayItem `json:"actions,omitempty"`

	// The list of attributes associated with the data engine policy.
	DataEnginePolicyInlineAttributes []*DataEnginePolicyInlineAttributesInlineArrayItem `json:"attributes,omitempty"`

	// A list of conditions that define how the data engine policy should be applied.
	DataEnginePolicyInlineConditions []*DataEnginePolicyInlineConditionsInlineArrayItem `json:"conditions,omitempty"`

	// The timestamp indicating when the data engine policy was deleted. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	DeleteTime *strfmt.DateTime `json:"delete_time,omitempty"`

	// A detailed description of the data engine policy.
	// Example: Exclude email addresses from the files.
	Description *string `json:"description,omitempty"`

	// Indicates whether the data engine policy is enabled.
	//
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// Name of the data engine policy. This field is required for POST requests.
	// Example: Exclude email addresses.
	Name *string `json:"name,omitempty"`

	// Specifies the scope of the data engine policy. Possible values are:
	// * <i>global</i> - Applies globally.
	// * <i>workspace</i> - Applies to workspaces.
	// * <i>data_source</i> - Applies to data sources.
	// * <i>data_collection</i> - Applies to data collections.
	//
	// Example: global
	// Enum: ["global","workspace","data_source","data_collection"]
	Scope *string `json:"scope,omitempty"`

	// Target resources for the data engine policy.
	// * <i>workspace</i> - Targets workspaces.
	// * <i>data_source</i> - Targets data sources.
	// * <i>data_collection</i> - Targets data collections.
	//
	// Example: workspace
	// Enum: ["workspace","data_source","data_collection"]
	Target *string `json:"target,omitempty"`

	// Specifies the type of the data engine policy. Possible values are:
	// * <i>data_source_exclusion</i> - A global data source exclusion policy.
	// * <i>classifier</i> - A global classifier enablement policy.
	// * <i>classification_guardrail</i> - A classification guardrail policy.
	//
	// Example: data_source_exclusion
	// Enum: ["data_source_exclusion","classifier","classification_guardrail"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the data engine policy was last updated. This field is auto-generated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the data engine policy.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *DataEnginePolicyInlineVersion `json:"version,omitempty"`
}

// Validate validates this data engine policy
func (m *DataEnginePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEnginePolicyInlineActions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEnginePolicyInlineAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEnginePolicyInlineConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeleteTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEnginePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEnginePolicy) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) validateDataEnginePolicyInlineActions(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEnginePolicyInlineActions) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEnginePolicyInlineActions); i++ {
		if swag.IsZero(m.DataEnginePolicyInlineActions[i]) { // not required
			continue
		}

		if m.DataEnginePolicyInlineActions[i] != nil {
			if err := m.DataEnginePolicyInlineActions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) validateDataEnginePolicyInlineAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEnginePolicyInlineAttributes) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEnginePolicyInlineAttributes); i++ {
		if swag.IsZero(m.DataEnginePolicyInlineAttributes[i]) { // not required
			continue
		}

		if m.DataEnginePolicyInlineAttributes[i] != nil {
			if err := m.DataEnginePolicyInlineAttributes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) validateDataEnginePolicyInlineConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEnginePolicyInlineConditions) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEnginePolicyInlineConditions); i++ {
		if swag.IsZero(m.DataEnginePolicyInlineConditions[i]) { // not required
			continue
		}

		if m.DataEnginePolicyInlineConditions[i] != nil {
			if err := m.DataEnginePolicyInlineConditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) validateDeleteTime(formats strfmt.Registry) error {
	if swag.IsZero(m.DeleteTime) { // not required
		return nil
	}

	if err := validate.FormatOf("delete_time", "body", "date-time", m.DeleteTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["global","workspace","data_source","data_collection"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyTypeScopePropEnum = append(dataEnginePolicyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// scope
	// Scope
	// global
	// END DEBUGGING
	// DataEnginePolicyScopeGlobal captures enum value "global"
	DataEnginePolicyScopeGlobal string = "global"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// scope
	// Scope
	// workspace
	// END DEBUGGING
	// DataEnginePolicyScopeWorkspace captures enum value "workspace"
	DataEnginePolicyScopeWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// scope
	// Scope
	// data_source
	// END DEBUGGING
	// DataEnginePolicyScopeDataSource captures enum value "data_source"
	DataEnginePolicyScopeDataSource string = "data_source"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// scope
	// Scope
	// data_collection
	// END DEBUGGING
	// DataEnginePolicyScopeDataCollection captures enum value "data_collection"
	DataEnginePolicyScopeDataCollection string = "data_collection"
)

// prop value enum
func (m *DataEnginePolicy) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEnginePolicy) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyTypeTargetPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace","data_source","data_collection"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyTypeTargetPropEnum = append(dataEnginePolicyTypeTargetPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// target
	// Target
	// workspace
	// END DEBUGGING
	// DataEnginePolicyTargetWorkspace captures enum value "workspace"
	DataEnginePolicyTargetWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// target
	// Target
	// data_source
	// END DEBUGGING
	// DataEnginePolicyTargetDataSource captures enum value "data_source"
	DataEnginePolicyTargetDataSource string = "data_source"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// target
	// Target
	// data_collection
	// END DEBUGGING
	// DataEnginePolicyTargetDataCollection captures enum value "data_collection"
	DataEnginePolicyTargetDataCollection string = "data_collection"
)

// prop value enum
func (m *DataEnginePolicy) validateTargetEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyTypeTargetPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEnginePolicy) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(m.Target) { // not required
		return nil
	}

	// value enum
	if err := m.validateTargetEnum("target", "body", *m.Target); err != nil {
		return err
	}

	return nil
}

var dataEnginePolicyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data_source_exclusion","classifier","classification_guardrail"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEnginePolicyTypeTypePropEnum = append(dataEnginePolicyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// type
	// Type
	// data_source_exclusion
	// END DEBUGGING
	// DataEnginePolicyTypeDataSourceExclusion captures enum value "data_source_exclusion"
	DataEnginePolicyTypeDataSourceExclusion string = "data_source_exclusion"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// type
	// Type
	// classifier
	// END DEBUGGING
	// DataEnginePolicyTypeClassifier captures enum value "classifier"
	DataEnginePolicyTypeClassifier string = "classifier"

	// BEGIN DEBUGGING
	// data_engine_policy
	// DataEnginePolicy
	// type
	// Type
	// classification_guardrail
	// END DEBUGGING
	// DataEnginePolicyTypeClassificationGuardrail captures enum value "classification_guardrail"
	DataEnginePolicyTypeClassificationGuardrail string = "classification_guardrail"
)

// prop value enum
func (m *DataEnginePolicy) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEnginePolicyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEnginePolicy) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine policy based on the context it is used
func (m *DataEnginePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEnginePolicyInlineActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEnginePolicyInlineAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEnginePolicyInlineConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeleteTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEnginePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEnginePolicy) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) contextValidateDataEnginePolicyInlineActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEnginePolicyInlineActions); i++ {

		if m.DataEnginePolicyInlineActions[i] != nil {
			if err := m.DataEnginePolicyInlineActions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) contextValidateDataEnginePolicyInlineAttributes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEnginePolicyInlineAttributes); i++ {

		if m.DataEnginePolicyInlineAttributes[i] != nil {
			if err := m.DataEnginePolicyInlineAttributes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) contextValidateDataEnginePolicyInlineConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEnginePolicyInlineConditions); i++ {

		if m.DataEnginePolicyInlineConditions[i] != nil {
			if err := m.DataEnginePolicyInlineConditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEnginePolicy) contextValidateDeleteTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "delete_time", "body", m.DeleteTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DataEnginePolicy) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEnginePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEnginePolicy) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEnginePolicyInlineActionsInlineArrayItem data engine policy inline actions inline array item
//
// swagger:model data_engine_policy_inline_actions_inline_array_item
type DataEnginePolicyInlineActionsInlineArrayItem struct {

	// Indicates whether the action is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the name of the action to be performed by the data engine policy.
	// Example: classify_email
	Name *string `json:"name,omitempty"`
}

// Validate validates this data engine policy inline actions inline array item
func (m *DataEnginePolicyInlineActionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline actions inline array item based on context it is used
func (m *DataEnginePolicyInlineActionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEnginePolicyInlineActionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEnginePolicyInlineActionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineActionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEnginePolicyInlineAttributesInlineArrayItem data engine policy inline attributes inline array item
//
// swagger:model data_engine_policy_inline_attributes_inline_array_item
type DataEnginePolicyInlineAttributesInlineArrayItem struct {

	// The key of the attribute.
	// Example: attribute_key_1
	Key *string `json:"key,omitempty"`

	// The value of the attribute.
	// Example: attribute_value_1
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine policy inline attributes inline array item
func (m *DataEnginePolicyInlineAttributesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline attributes inline array item based on context it is used
func (m *DataEnginePolicyInlineAttributesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEnginePolicyInlineAttributesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEnginePolicyInlineAttributesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineAttributesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEnginePolicyInlineConditionsInlineArrayItem data engine policy inline conditions inline array item
//
// swagger:model data_engine_policy_inline_conditions_inline_array_item
type DataEnginePolicyInlineConditionsInlineArrayItem struct {

	// Valid JSON string that defines the condition under which the data engine policy is applied.
	// Example: {'type': 'pdf'}
	Condition *string `json:"condition,omitempty"`
}

// Validate validates this data engine policy inline conditions inline array item
func (m *DataEnginePolicyInlineConditionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine policy inline conditions inline array item based on context it is used
func (m *DataEnginePolicyInlineConditionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEnginePolicyInlineConditionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEnginePolicyInlineConditionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineConditionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEnginePolicyInlineVersion Details of the latest version of the data engine policy.
//
// swagger:model data_engine_policy_inline_version
type DataEnginePolicyInlineVersion struct {

	// Unique identifier of the version.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine policy inline version
func (m *DataEnginePolicyInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEnginePolicyInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine policy inline version based on the context it is used
func (m *DataEnginePolicyInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DataEnginePolicyInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEnginePolicyInlineVersion) UnmarshalBinary(b []byte) error {
	var res DataEnginePolicyInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
