// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineSubJob The child job for the job.
//
// swagger:model data_engine_sub_job
type DataEngineSubJob struct {

	// links
	Links *DataEngineSubJobInlineLinks `json:"_links,omitempty"`

	// The creation time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Job tags in string format.
	DataEngineSubJobInlineTags []*string `json:"tags,omitempty"`

	// The description of the job.
	// Example: Workspace Create Job
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The end time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// error
	Error *DcnCommonError `json:"error,omitempty"`

	// The name of the job.
	// Example: workspace create
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// parent job
	ParentJob *DataEngineSubJobInlineParentJob `json:"parent_job,omitempty"`

	// The percentage of the job that is completed.
	// Example: 5
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// resource
	Resource *DataEngineSubJobInlineResource `json:"resource,omitempty"`

	// The start time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// The state of the data engine job:
	// * <i>queued</i> - The job is queued for execution.
	// * <i>running</i> - The job is currently in execution.
	// * <i>success</i> - The job has been completed successfully.
	// * <i>failure</i> - The job has failed.
	//
	// Example: success
	// Read Only: true
	// Enum: ["queued","running","success","failure"]
	State *string `json:"state,omitempty"`

	// The timeout period of the job in minutes.
	// Example: 30
	// Read Only: true
	Timeout *int64 `json:"timeout,omitempty"`

	// The type of the job.
	// Example: workspace_create
	// Read Only: true
	// Enum: ["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]
	Type *string `json:"type,omitempty"`

	// The update time of the job.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The unique identifier of the job.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine sub job
func (m *DataEngineSubJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJob) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) validateParentJob(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentJob) { // not required
		return nil
	}

	if m.ParentJob != nil {
		if err := m.ParentJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) validatePercentComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentComplete) { // not required
		return nil
	}

	if err := validate.MinimumInt("percent_complete", "body", *m.PercentComplete, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("percent_complete", "body", *m.PercentComplete, 100, false); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var dataEngineSubJobTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["queued","running","success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineSubJobTypeStatePropEnum = append(dataEngineSubJobTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// state
	// State
	// queued
	// END DEBUGGING
	// DataEngineSubJobStateQueued captures enum value "queued"
	DataEngineSubJobStateQueued string = "queued"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// state
	// State
	// running
	// END DEBUGGING
	// DataEngineSubJobStateRunning captures enum value "running"
	DataEngineSubJobStateRunning string = "running"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// state
	// State
	// success
	// END DEBUGGING
	// DataEngineSubJobStateSuccess captures enum value "success"
	DataEngineSubJobStateSuccess string = "success"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// state
	// State
	// failure
	// END DEBUGGING
	// DataEngineSubJobStateFailure captures enum value "failure"
	DataEngineSubJobStateFailure string = "failure"
)

// prop value enum
func (m *DataEngineSubJob) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineSubJobTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineSubJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineSubJobTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineSubJobTypeTypePropEnum = append(dataEngineSubJobTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_create
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceCreate captures enum value "workspace_create"
	DataEngineSubJobTypeWorkspaceCreate string = "workspace_create"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_update
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceUpdate captures enum value "workspace_update"
	DataEngineSubJobTypeWorkspaceUpdate string = "workspace_update"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_delete
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceDelete captures enum value "workspace_delete"
	DataEngineSubJobTypeWorkspaceDelete string = "workspace_delete"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_refresh
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceRefresh captures enum value "workspace_refresh"
	DataEngineSubJobTypeWorkspaceRefresh string = "workspace_refresh"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_restore
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceRestore captures enum value "workspace_restore"
	DataEngineSubJobTypeWorkspaceRestore string = "workspace_restore"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_content_processing
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceContentProcessing captures enum value "workspace_content_processing"
	DataEngineSubJobTypeWorkspaceContentProcessing string = "workspace_content_processing"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// workspace_versioning
	// END DEBUGGING
	// DataEngineSubJobTypeWorkspaceVersioning captures enum value "workspace_versioning"
	DataEngineSubJobTypeWorkspaceVersioning string = "workspace_versioning"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_create
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionCreate captures enum value "data_collection_create"
	DataEngineSubJobTypeDataCollectionCreate string = "data_collection_create"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_update
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionUpdate captures enum value "data_collection_update"
	DataEngineSubJobTypeDataCollectionUpdate string = "data_collection_update"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_delete
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionDelete captures enum value "data_collection_delete"
	DataEngineSubJobTypeDataCollectionDelete string = "data_collection_delete"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_refresh
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionRefresh captures enum value "data_collection_refresh"
	DataEngineSubJobTypeDataCollectionRefresh string = "data_collection_refresh"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_restore
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionRestore captures enum value "data_collection_restore"
	DataEngineSubJobTypeDataCollectionRestore string = "data_collection_restore"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_content_processing
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionContentProcessing captures enum value "data_collection_content_processing"
	DataEngineSubJobTypeDataCollectionContentProcessing string = "data_collection_content_processing"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_collection_versioning
	// END DEBUGGING
	// DataEngineSubJobTypeDataCollectionVersioning captures enum value "data_collection_versioning"
	DataEngineSubJobTypeDataCollectionVersioning string = "data_collection_versioning"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_source_create
	// END DEBUGGING
	// DataEngineSubJobTypeDataSourceCreate captures enum value "data_source_create"
	DataEngineSubJobTypeDataSourceCreate string = "data_source_create"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_source_update
	// END DEBUGGING
	// DataEngineSubJobTypeDataSourceUpdate captures enum value "data_source_update"
	DataEngineSubJobTypeDataSourceUpdate string = "data_source_update"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_source_delete
	// END DEBUGGING
	// DataEngineSubJobTypeDataSourceDelete captures enum value "data_source_delete"
	DataEngineSubJobTypeDataSourceDelete string = "data_source_delete"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// data_source_refresh
	// END DEBUGGING
	// DataEngineSubJobTypeDataSourceRefresh captures enum value "data_source_refresh"
	DataEngineSubJobTypeDataSourceRefresh string = "data_source_refresh"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// policy_enforcement
	// END DEBUGGING
	// DataEngineSubJobTypePolicyEnforcement captures enum value "policy_enforcement"
	DataEngineSubJobTypePolicyEnforcement string = "policy_enforcement"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// cleanup
	// END DEBUGGING
	// DataEngineSubJobTypeCleanup captures enum value "cleanup"
	DataEngineSubJobTypeCleanup string = "cleanup"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// entity_preview
	// END DEBUGGING
	// DataEngineSubJobTypeEntityPreview captures enum value "entity_preview"
	DataEngineSubJobTypeEntityPreview string = "entity_preview"

	// BEGIN DEBUGGING
	// data_engine_sub_job
	// DataEngineSubJob
	// type
	// Type
	// entity_cache_cleanup
	// END DEBUGGING
	// DataEngineSubJobTypeEntityCacheCleanup captures enum value "entity_cache_cleanup"
	DataEngineSubJobTypeEntityCacheCleanup string = "entity_cache_cleanup"
)

// prop value enum
func (m *DataEngineSubJob) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineSubJobTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineSubJob) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine sub job based on the context it is used
func (m *DataEngineSubJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineSubJobInlineTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJob) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateDataEngineSubJobInlineTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineSubJobInlineTags); i++ {

		if err := validate.ReadOnly(ctx, "tags"+"."+strconv.Itoa(i), "body", m.DataEngineSubJobInlineTags[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DataEngineSubJob) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateParentJob(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentJob != nil {
		if err := m.ParentJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {
		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timeout", "body", m.Timeout); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineSubJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineSubJob) UnmarshalBinary(b []byte) error {
	var res DataEngineSubJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineSubJobInlineLinks data engine sub job inline links
//
// swagger:model data_engine_sub_job_inline__links
type DataEngineSubJobInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this data engine sub job inline links
func (m *DataEngineSubJobInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJobInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine sub job inline links based on the context it is used
func (m *DataEngineSubJobInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJobInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineSubJobInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineSubJobInlineLinks) UnmarshalBinary(b []byte) error {
	var res DataEngineSubJobInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineSubJobInlineParentJob The parent job reference of the job.
//
// swagger:model data_engine_sub_job_inline_parent_job
type DataEngineSubJobInlineParentJob struct {

	// The unique identifier of the parent job.
	// Example: 123e4567-e89b-12d3-a456-426614173000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine sub job inline parent job
func (m *DataEngineSubJobInlineParentJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJobInlineParentJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("parent_job"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine sub job inline parent job based on the context it is used
func (m *DataEngineSubJobInlineParentJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJobInlineParentJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "parent_job"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineSubJobInlineParentJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineSubJobInlineParentJob) UnmarshalBinary(b []byte) error {
	var res DataEngineSubJobInlineParentJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineSubJobInlineResource The data engine resource for which the job has been created.
//
// swagger:model data_engine_sub_job_inline_resource
type DataEngineSubJobInlineResource struct {

	// The name of the data engine resource.
	// Example: workspace_1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The type of the data engine resource.
	// Example: workspace
	// Read Only: true
	// Enum: ["workspace","data_source","data_collection","policy","entity"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the data engine resource.
	// Example: 123e4567-e89b-12d3-a456-426614173000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine sub job inline resource
func (m *DataEngineSubJobInlineResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineSubJobInlineResourceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace","data_source","data_collection","policy","entity"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineSubJobInlineResourceTypeTypePropEnum = append(dataEngineSubJobInlineResourceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_sub_job_inline_resource
	// DataEngineSubJobInlineResource
	// type
	// Type
	// workspace
	// END DEBUGGING
	// DataEngineSubJobInlineResourceTypeWorkspace captures enum value "workspace"
	DataEngineSubJobInlineResourceTypeWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// data_engine_sub_job_inline_resource
	// DataEngineSubJobInlineResource
	// type
	// Type
	// data_source
	// END DEBUGGING
	// DataEngineSubJobInlineResourceTypeDataSource captures enum value "data_source"
	DataEngineSubJobInlineResourceTypeDataSource string = "data_source"

	// BEGIN DEBUGGING
	// data_engine_sub_job_inline_resource
	// DataEngineSubJobInlineResource
	// type
	// Type
	// data_collection
	// END DEBUGGING
	// DataEngineSubJobInlineResourceTypeDataCollection captures enum value "data_collection"
	DataEngineSubJobInlineResourceTypeDataCollection string = "data_collection"

	// BEGIN DEBUGGING
	// data_engine_sub_job_inline_resource
	// DataEngineSubJobInlineResource
	// type
	// Type
	// policy
	// END DEBUGGING
	// DataEngineSubJobInlineResourceTypePolicy captures enum value "policy"
	DataEngineSubJobInlineResourceTypePolicy string = "policy"

	// BEGIN DEBUGGING
	// data_engine_sub_job_inline_resource
	// DataEngineSubJobInlineResource
	// type
	// Type
	// entity
	// END DEBUGGING
	// DataEngineSubJobInlineResourceTypeEntity captures enum value "entity"
	DataEngineSubJobInlineResourceTypeEntity string = "entity"
)

// prop value enum
func (m *DataEngineSubJobInlineResource) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineSubJobInlineResourceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineSubJobInlineResource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("resource"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJobInlineResource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("resource"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine sub job inline resource based on the context it is used
func (m *DataEngineSubJobInlineResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineSubJobInlineResource) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJobInlineResource) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineSubJobInlineResource) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "resource"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineSubJobInlineResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineSubJobInlineResource) UnmarshalBinary(b []byte) error {
	var res DataEngineSubJobInlineResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
