// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineVersionJob The version job details.
//
// swagger:model data_engine_version_job
type DataEngineVersionJob struct {

	// links
	Links *DataEngineVersionJobInlineLinks `json:"_links,omitempty"`

	// The state of the data engine job:
	// * <i>queued</i> - The job is queued for execution.
	// * <i>running</i> - The job is currently in execution.
	// * <i>success</i> - The job has been completed successfully.
	// * <i>failure</i> - The job has failed.
	//
	// Example: success
	// Read Only: true
	// Enum: ["queued","running","success","failure"]
	State *string `json:"state,omitempty"`

	// The unique identifier of the job.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine version job
func (m *DataEngineVersionJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineVersionJob) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var dataEngineVersionJobTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["queued","running","success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineVersionJobTypeStatePropEnum = append(dataEngineVersionJobTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_version_job
	// DataEngineVersionJob
	// state
	// State
	// queued
	// END DEBUGGING
	// DataEngineVersionJobStateQueued captures enum value "queued"
	DataEngineVersionJobStateQueued string = "queued"

	// BEGIN DEBUGGING
	// data_engine_version_job
	// DataEngineVersionJob
	// state
	// State
	// running
	// END DEBUGGING
	// DataEngineVersionJobStateRunning captures enum value "running"
	DataEngineVersionJobStateRunning string = "running"

	// BEGIN DEBUGGING
	// data_engine_version_job
	// DataEngineVersionJob
	// state
	// State
	// success
	// END DEBUGGING
	// DataEngineVersionJobStateSuccess captures enum value "success"
	DataEngineVersionJobStateSuccess string = "success"

	// BEGIN DEBUGGING
	// data_engine_version_job
	// DataEngineVersionJob
	// state
	// State
	// failure
	// END DEBUGGING
	// DataEngineVersionJobStateFailure captures enum value "failure"
	DataEngineVersionJobStateFailure string = "failure"
)

// prop value enum
func (m *DataEngineVersionJob) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineVersionJobTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineVersionJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineVersionJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine version job based on the context it is used
func (m *DataEngineVersionJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineVersionJob) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineVersionJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineVersionJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineVersionJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineVersionJob) UnmarshalBinary(b []byte) error {
	var res DataEngineVersionJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineVersionJobInlineLinks data engine version job inline links
//
// swagger:model data_engine_version_job_inline__links
type DataEngineVersionJobInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this data engine version job inline links
func (m *DataEngineVersionJobInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineVersionJobInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine version job inline links based on the context it is used
func (m *DataEngineVersionJobInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineVersionJobInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineVersionJobInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineVersionJobInlineLinks) UnmarshalBinary(b []byte) error {
	var res DataEngineVersionJobInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
