// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataSource Data source information.
//
// swagger:model data_source
type DataSource struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// data source inline errors
	// Read Only: true
	DataSourceInlineErrors []*DataSourceInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// The list of workspaces that are associated with the data source.
	// Read Only: true
	DataSourceInlineWorkspaces []*WorkspaceReference `json:"workspaces,omitempty"`

	// The last refresh time of the data source. This field is generated when the data source is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The local storage used for a data source. Required on POST requests.
	LocalStorage *LocalStorage `json:"local_storage,omitempty"`

	// The message associated with the current state of the data source.
	// Example: refreshing data source
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// The remote storage used for a data source. Required on POST requests.
	RemoteStorage *RemoteStorage `json:"remote_storage,omitempty"`

	// space
	Space *DataSourceInlineSpace `json:"space,omitempty"`

	// State of the data source:
	// * <i>processing</i> - The data source is being processed after creation.
	// * <i>ready</i> - The data source is ready for use.
	// * <i>failed</i> - The data source has a failure.
	// * <i>outdated</i> - The data source is outdated.
	// * <i>deleted</i> - The data source has been marked for deletion.
	// * Valid in GET requests.
	//
	// Example: ready
	// Read Only: true
	// Enum: ["processing","ready","failed","outdated","deleted"]
	State *string `json:"state,omitempty"`

	// The type of the data source.
	Type *DataSourceType `json:"type,omitempty"`

	// Unique identifier for the data source.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data source
func (m *DataSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSourceInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSourceInlineWorkspaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSource) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) validateDataSourceInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSourceInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.DataSourceInlineErrors); i++ {
		if swag.IsZero(m.DataSourceInlineErrors[i]) { // not required
			continue
		}

		if m.DataSourceInlineErrors[i] != nil {
			if err := m.DataSourceInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataSource) validateDataSourceInlineWorkspaces(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSourceInlineWorkspaces) { // not required
		return nil
	}

	for i := 0; i < len(m.DataSourceInlineWorkspaces); i++ {
		if swag.IsZero(m.DataSourceInlineWorkspaces[i]) { // not required
			continue
		}

		if m.DataSourceInlineWorkspaces[i] != nil {
			if err := m.DataSourceInlineWorkspaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataSource) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_refresh_time", "body", "date-time", m.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataSource) validateLocalStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalStorage) { // not required
		return nil
	}

	if m.LocalStorage != nil {
		if err := m.LocalStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_storage")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) validateRemoteStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteStorage) { // not required
		return nil
	}

	if m.RemoteStorage != nil {
		if err := m.RemoteStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_storage")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var dataSourceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated","deleted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataSourceTypeStatePropEnum = append(dataSourceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_source
	// DataSource
	// state
	// State
	// processing
	// END DEBUGGING
	// DataSourceStateProcessing captures enum value "processing"
	DataSourceStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// data_source
	// DataSource
	// state
	// State
	// ready
	// END DEBUGGING
	// DataSourceStateReady captures enum value "ready"
	DataSourceStateReady string = "ready"

	// BEGIN DEBUGGING
	// data_source
	// DataSource
	// state
	// State
	// failed
	// END DEBUGGING
	// DataSourceStateFailed captures enum value "failed"
	DataSourceStateFailed string = "failed"

	// BEGIN DEBUGGING
	// data_source
	// DataSource
	// state
	// State
	// outdated
	// END DEBUGGING
	// DataSourceStateOutdated captures enum value "outdated"
	DataSourceStateOutdated string = "outdated"

	// BEGIN DEBUGGING
	// data_source
	// DataSource
	// state
	// State
	// deleted
	// END DEBUGGING
	// DataSourceStateDeleted captures enum value "deleted"
	DataSourceStateDeleted string = "deleted"
)

// prop value enum
func (m *DataSource) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataSourceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataSource) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataSource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if m.Type != nil {
		if err := m.Type.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data source based on the context it is used
func (m *DataSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSourceInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSourceInlineWorkspaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSource) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) contextValidateDataSourceInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*DataSourceInlineErrorsInlineArrayItem(m.DataSourceInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.DataSourceInlineErrors); i++ {

		if m.DataSourceInlineErrors[i] != nil {
			if err := m.DataSourceInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataSource) contextValidateDataSourceInlineWorkspaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspaces", "body", []*WorkspaceReference(m.DataSourceInlineWorkspaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.DataSourceInlineWorkspaces); i++ {

		if m.DataSourceInlineWorkspaces[i] != nil {
			if err := m.DataSourceInlineWorkspaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("workspaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataSource) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_refresh_time", "body", m.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (m *DataSource) contextValidateLocalStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.LocalStorage != nil {
		if err := m.LocalStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_storage")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *DataSource) contextValidateRemoteStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.RemoteStorage != nil {
		if err := m.RemoteStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_storage")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataSource) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if m.Type != nil {
		if err := m.Type.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

func (m *DataSource) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataSource) UnmarshalBinary(b []byte) error {
	var res DataSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataSourceInlineErrorsInlineArrayItem data source inline errors inline array item
//
// swagger:model data_source_inline_errors_inline_array_item
type DataSourceInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this data source inline errors inline array item
func (m *DataSourceInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourceInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data source inline errors inline array item based on the context it is used
func (m *DataSourceInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourceInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataSourceInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataSourceInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataSourceInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataSourceInlineSpace data source inline space
//
// swagger:model data_source_inline_space
type DataSourceInlineSpace struct {

	// The available space of a data source, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The total space of a data source, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// The used space of a data source, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this data source inline space
func (m *DataSourceInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this data source inline space based on the context it is used
func (m *DataSourceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourceInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *DataSourceInlineSpace) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *DataSourceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataSourceInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataSourceInlineSpace) UnmarshalBinary(b []byte) error {
	var res DataSourceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
