// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataSourcesAggregationsArrayInline Aggregation of data_sources in the workspace.
//
// swagger:model data_sources_aggregations_array_inline
type DataSourcesAggregationsArrayInline []*DataSourcesAggregationsArrayInlineInlineArrayItem

// Validate validates this data sources aggregations array inline
func (m DataSourcesAggregationsArrayInline) Validate(formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {
		if swag.IsZero(m[i]) { // not required
			continue
		}

		if m[i] != nil {
			if err := m[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validate this data sources aggregations array inline based on the context it is used
func (m DataSourcesAggregationsArrayInline) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {

		if m[i] != nil {
			if err := m[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// DataSourcesAggregationsArrayInlineInlineArrayItem data sources aggregations array inline inline array item
//
// swagger:model data_sources_aggregations_array_inline_inline_array_item
type DataSourcesAggregationsArrayInlineInlineArrayItem struct {

	// Number of entities in the data_source.
	// Example: 20
	EntityCount *int64 `json:"entity_count,omitempty"`

	// Name of the data_source.
	// Example: data_source_1
	Name *string `json:"name,omitempty"`

	// Number of sensitive entities in the data_source.
	// Example: 100
	SensitiveEntityCount *int64 `json:"sensitive_entity_count,omitempty"`

	// Percentage of sensitive entities in the data_source.
	// Example: 23
	SensitiveEntityPercent *int64 `json:"sensitive_entity_percent,omitempty"`

	// Total utilized size of the data_source.
	// Example: 2066541
	SpaceUsed *int64 `json:"space_used,omitempty"`

	// Top document categories of the data_source.
	// Example: General Privacy, Financial Documents
	TopDocumentCategories *string `json:"top_document_categories,omitempty"`

	// UUID of the data_source.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data sources aggregations array inline inline array item
func (m *DataSourcesAggregationsArrayInlineInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourcesAggregationsArrayInlineInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data sources aggregations array inline inline array item based on context it is used
func (m *DataSourcesAggregationsArrayInlineInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataSourcesAggregationsArrayInlineInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataSourcesAggregationsArrayInlineInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataSourcesAggregationsArrayInlineInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
