// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Datacollection Data collection information.
//
// swagger:model datacollection
type Datacollection struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The creation time of the data collection. This field is generated when the data collection is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// List of users or groups associated with the ACL.
	DatacollectionInlineAcls []*DataEngineDatacollectionACL `json:"acls,omitempty"`

	// List of entities.
	DatacollectionInlineEntities []*DatacollectionInlineEntitiesInlineArrayItem `json:"entities,omitempty"`

	// datacollection inline errors
	// Read Only: true
	DatacollectionInlineErrors []*DatacollectionInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// Description of the data collection.
	// Example: This is an example data collection.
	Description *string `json:"description,omitempty"`

	// embedding
	Embedding *DatacollectionInlineEmbedding `json:"embedding,omitempty"`

	// The count of entities in a data collection.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// The last refresh time of the data collection. This field is generated when the data collection is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The message associated with the current state of the data collection.
	// Example: creating data collection
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Name of the data collection.
	// Example: Example Data Collection
	Name *string `json:"name,omitempty"`

	// The owner of the data collection.
	// Example: Eva
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// query
	Query *DatacollectionInlineQuery `json:"query,omitempty"`

	// The size of the data collection, in bytes.
	// Example: 1000
	// Read Only: true
	Size *uint64 `json:"size,omitempty"`

	// State of the data collection:
	// * <i>draft</i> - The data collection is in draft.
	// * <i>processing</i> - The data collection is being processed.
	// * <i>published</i> - The data collection is published.
	// * <i>failed</i> - The data collection has a failure.
	// * <i>outdated</i> - The data collection is outdated.
	// * Valid in GET requests.
	//
	// Example: published
	// Read Only: true
	// Enum: ["draft","processing","published","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The type of the data collection.
	// * <i>manual</i> - The data collection is created by providing an entities list.
	// * <i>dynamic</i> - The data collection is created with a query selector.
	//
	// Example: dynamic
	// Enum: ["manual","dynamic"]
	Type *string `json:"type,omitempty"`

	// The update time of the data collection. This field is generated when the data collection is updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the data collection.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *DatacollectionInlineVersion `json:"version,omitempty"`

	// Workspace containing the data collection.
	// Read Only: true
	Workspace *EntityWorkspaceVersion `json:"workspace,omitempty"`
}

// Validate validates this datacollection
func (m *Datacollection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollectionInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollectionInlineEntities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollectionInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmbedding(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuery(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Datacollection) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) validateDatacollectionInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(m.DatacollectionInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(m.DatacollectionInlineAcls); i++ {
		if swag.IsZero(m.DatacollectionInlineAcls[i]) { // not required
			continue
		}

		if m.DatacollectionInlineAcls[i] != nil {
			if err := m.DatacollectionInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) validateDatacollectionInlineEntities(formats strfmt.Registry) error {
	if swag.IsZero(m.DatacollectionInlineEntities) { // not required
		return nil
	}

	for i := 0; i < len(m.DatacollectionInlineEntities); i++ {
		if swag.IsZero(m.DatacollectionInlineEntities[i]) { // not required
			continue
		}

		if m.DatacollectionInlineEntities[i] != nil {
			if err := m.DatacollectionInlineEntities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) validateDatacollectionInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.DatacollectionInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.DatacollectionInlineErrors); i++ {
		if swag.IsZero(m.DatacollectionInlineErrors[i]) { // not required
			continue
		}

		if m.DatacollectionInlineErrors[i] != nil {
			if err := m.DatacollectionInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) validateEmbedding(formats strfmt.Registry) error {
	if swag.IsZero(m.Embedding) { // not required
		return nil
	}

	if m.Embedding != nil {
		if err := m.Embedding.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("embedding")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_refresh_time", "body", "date-time", m.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) validateQuery(formats strfmt.Registry) error {
	if swag.IsZero(m.Query) { // not required
		return nil
	}

	if m.Query != nil {
		if err := m.Query.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("query")
			}
			return err
		}
	}

	return nil
}

var datacollectionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["draft","processing","published","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionTypeStatePropEnum = append(datacollectionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// state
	// State
	// draft
	// END DEBUGGING
	// DatacollectionStateDraft captures enum value "draft"
	DatacollectionStateDraft string = "draft"

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// state
	// State
	// processing
	// END DEBUGGING
	// DatacollectionStateProcessing captures enum value "processing"
	DatacollectionStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// state
	// State
	// published
	// END DEBUGGING
	// DatacollectionStatePublished captures enum value "published"
	DatacollectionStatePublished string = "published"

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// state
	// State
	// failed
	// END DEBUGGING
	// DatacollectionStateFailed captures enum value "failed"
	DatacollectionStateFailed string = "failed"

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// state
	// State
	// outdated
	// END DEBUGGING
	// DatacollectionStateOutdated captures enum value "outdated"
	DatacollectionStateOutdated string = "outdated"
)

// prop value enum
func (m *Datacollection) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Datacollection) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var datacollectionTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["manual","dynamic"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionTypeTypePropEnum = append(datacollectionTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// type
	// Type
	// manual
	// END DEBUGGING
	// DatacollectionTypeManual captures enum value "manual"
	DatacollectionTypeManual string = "manual"

	// BEGIN DEBUGGING
	// datacollection
	// Datacollection
	// type
	// Type
	// dynamic
	// END DEBUGGING
	// DatacollectionTypeDynamic captures enum value "dynamic"
	DatacollectionTypeDynamic string = "dynamic"
)

// prop value enum
func (m *Datacollection) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Datacollection) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection based on the context it is used
func (m *Datacollection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollectionInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollectionInlineEntities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollectionInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmbedding(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQuery(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Datacollection) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateDatacollectionInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DatacollectionInlineAcls); i++ {

		if m.DatacollectionInlineAcls[i] != nil {
			if err := m.DatacollectionInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) contextValidateDatacollectionInlineEntities(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DatacollectionInlineEntities); i++ {

		if m.DatacollectionInlineEntities[i] != nil {
			if err := m.DatacollectionInlineEntities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) contextValidateDatacollectionInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*DatacollectionInlineErrorsInlineArrayItem(m.DatacollectionInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.DatacollectionInlineErrors); i++ {

		if m.DatacollectionInlineErrors[i] != nil {
			if err := m.DatacollectionInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Datacollection) contextValidateEmbedding(ctx context.Context, formats strfmt.Registry) error {

	if m.Embedding != nil {
		if err := m.Embedding.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("embedding")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entity_count", "body", m.EntityCount); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_refresh_time", "body", m.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateQuery(ctx context.Context, formats strfmt.Registry) error {

	if m.Query != nil {
		if err := m.Query.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("query")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Datacollection) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Datacollection) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Datacollection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Datacollection) UnmarshalBinary(b []byte) error {
	var res Datacollection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineEmbedding Vectorization settings for the data collection.
//
// swagger:model datacollection_inline_embedding
type DatacollectionInlineEmbedding struct {

	// The chunk size value in the range (3..1536)
	// Example: 1536
	ChunkSize *int64 `json:"chunk_size,omitempty"`

	// The type of chunking.
	// Enum: ["sentence","paragraph","full_file","semantic","fixed_size","recursive"]
	ChunkType *string `json:"chunk_type,omitempty"`

	// The dimension of vectorization.
	// Example: 1024
	// Enum: [1024]
	Dimension *int64 `json:"dimension,omitempty"`

	// Indicates whether vectorization is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// The vector quantization value.
	// Example: fp32
	// Enum: ["fp32","fp16"]
	Quantization *string `json:"quantization,omitempty"`

	// Indicates whether re_rank is enabled
	// Example: true
	ReRank *bool `json:"re_rank,omitempty"`
}

// Validate validates this datacollection inline embedding
func (m *DatacollectionInlineEmbedding) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChunkType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDimension(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuantization(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var datacollectionInlineEmbeddingTypeChunkTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sentence","paragraph","full_file","semantic","fixed_size","recursive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeChunkTypePropEnum = append(datacollectionInlineEmbeddingTypeChunkTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// sentence
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeSentence captures enum value "sentence"
	DatacollectionInlineEmbeddingChunkTypeSentence string = "sentence"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// paragraph
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeParagraph captures enum value "paragraph"
	DatacollectionInlineEmbeddingChunkTypeParagraph string = "paragraph"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// full_file
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeFullFile captures enum value "full_file"
	DatacollectionInlineEmbeddingChunkTypeFullFile string = "full_file"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// semantic
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeSemantic captures enum value "semantic"
	DatacollectionInlineEmbeddingChunkTypeSemantic string = "semantic"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// fixed_size
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeFixedSize captures enum value "fixed_size"
	DatacollectionInlineEmbeddingChunkTypeFixedSize string = "fixed_size"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// recursive
	// END DEBUGGING
	// DatacollectionInlineEmbeddingChunkTypeRecursive captures enum value "recursive"
	DatacollectionInlineEmbeddingChunkTypeRecursive string = "recursive"
)

// prop value enum
func (m *DatacollectionInlineEmbedding) validateChunkTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeChunkTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionInlineEmbedding) validateChunkType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChunkType) { // not required
		return nil
	}

	// value enum
	if err := m.validateChunkTypeEnum("embedding"+"."+"chunk_type", "body", *m.ChunkType); err != nil {
		return err
	}

	return nil
}

var datacollectionInlineEmbeddingTypeDimensionPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1024]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeDimensionPropEnum = append(datacollectionInlineEmbeddingTypeDimensionPropEnum, v)
	}
}

// prop value enum
func (m *DatacollectionInlineEmbedding) validateDimensionEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeDimensionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionInlineEmbedding) validateDimension(formats strfmt.Registry) error {
	if swag.IsZero(m.Dimension) { // not required
		return nil
	}

	// value enum
	if err := m.validateDimensionEnum("embedding"+"."+"dimension", "body", *m.Dimension); err != nil {
		return err
	}

	return nil
}

var datacollectionInlineEmbeddingTypeQuantizationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fp32","fp16"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionInlineEmbeddingTypeQuantizationPropEnum = append(datacollectionInlineEmbeddingTypeQuantizationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// quantization
	// Quantization
	// fp32
	// END DEBUGGING
	// DatacollectionInlineEmbeddingQuantizationFp32 captures enum value "fp32"
	DatacollectionInlineEmbeddingQuantizationFp32 string = "fp32"

	// BEGIN DEBUGGING
	// datacollection_inline_embedding
	// DatacollectionInlineEmbedding
	// quantization
	// Quantization
	// fp16
	// END DEBUGGING
	// DatacollectionInlineEmbeddingQuantizationFp16 captures enum value "fp16"
	DatacollectionInlineEmbeddingQuantizationFp16 string = "fp16"
)

// prop value enum
func (m *DatacollectionInlineEmbedding) validateQuantizationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionInlineEmbeddingTypeQuantizationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionInlineEmbedding) validateQuantization(formats strfmt.Registry) error {
	if swag.IsZero(m.Quantization) { // not required
		return nil
	}

	// value enum
	if err := m.validateQuantizationEnum("embedding"+"."+"quantization", "body", *m.Quantization); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline embedding based on context it is used
func (m *DatacollectionInlineEmbedding) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineEmbedding) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineEmbedding) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineEmbedding
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineEntitiesInlineArrayItem datacollection inline entities inline array item
//
// swagger:model datacollection_inline_entities_inline_array_item
type DatacollectionInlineEntitiesInlineArrayItem struct {

	// Unique identifier of the entity.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline entities inline array item
func (m *DatacollectionInlineEntitiesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineEntitiesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline entities inline array item based on context it is used
func (m *DatacollectionInlineEntitiesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineEntitiesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineEntitiesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineEntitiesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineErrorsInlineArrayItem datacollection inline errors inline array item
//
// swagger:model datacollection_inline_errors_inline_array_item
type DatacollectionInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this datacollection inline errors inline array item
func (m *DatacollectionInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection inline errors inline array item based on the context it is used
func (m *DatacollectionInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineQuery The query selector associated with the data collection.
//
// swagger:model datacollection_inline_query
type DatacollectionInlineQuery struct {

	// The query expression for the selector.
	// Example: {'type': 'pdf'}
	Expression *string `json:"expression,omitempty"`

	// Unique identifier of the query.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline query
func (m *DatacollectionInlineQuery) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineQuery) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("query"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection inline query based on context it is used
func (m *DatacollectionInlineQuery) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineQuery) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineQuery) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineQuery
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineVersion The version information of a data collection.
//
// swagger:model datacollection_inline_version
type DatacollectionInlineVersion struct {

	// current
	Current *DatacollectionInlineVersionInlineCurrent `json:"current,omitempty"`

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// next
	Next *DatacollectionInlineVersionInlineNext `json:"next,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version
func (m *DatacollectionInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCurrent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersion) validateCurrent(formats strfmt.Registry) error {
	if swag.IsZero(m.Current) { // not required
		return nil
	}

	if m.Current != nil {
		if err := m.Current.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersion) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version based on the context it is used
func (m *DatacollectionInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersion) contextValidateCurrent(ctx context.Context, formats strfmt.Registry) error {

	if m.Current != nil {
		if err := m.Current.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersion) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineVersionInlineCurrent Current version information.
//
// swagger:model datacollection_inline_version_inline_current
type DatacollectionInlineVersionInlineCurrent struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the current version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version inline current
func (m *DatacollectionInlineVersionInlineCurrent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersionInlineCurrent) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersionInlineCurrent) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"current"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version inline current based on the context it is used
func (m *DatacollectionInlineVersionInlineCurrent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersionInlineCurrent) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineVersionInlineCurrent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineVersionInlineCurrent) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersionInlineCurrent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionInlineVersionInlineNext Next version information.
//
// swagger:model datacollection_inline_version_inline_next
type DatacollectionInlineVersionInlineNext struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the next version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection inline version inline next
func (m *DatacollectionInlineVersionInlineNext) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersionInlineNext) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionInlineVersionInlineNext) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"next"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection inline version inline next based on the context it is used
func (m *DatacollectionInlineVersionInlineNext) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionInlineVersionInlineNext) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionInlineVersionInlineNext) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionInlineVersionInlineNext) UnmarshalBinary(b []byte) error {
	var res DatacollectionInlineVersionInlineNext
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
