// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DatacollectionEntity Entity attributes.
//
// swagger:model datacollection_entity
type DatacollectionEntity struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The last access time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	AccessTime *strfmt.DateTime `json:"access_time,omitempty"`

	// attributes
	Attributes *DatacollectionEntityInlineAttributes `json:"attributes,omitempty"`

	// Indicates if the entity can be previewed.
	// Example: true
	// Read Only: true
	CanPreview *bool `json:"can_preview,omitempty"`

	// The hash of the entity content.
	// Read Only: true
	ContentHash *string `json:"content_hash,omitempty"`

	// The create time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// datacollection
	// Read Only: true
	Datacollection *DatacollectionReference `json:"datacollection,omitempty"`

	// datacollection entity inline errors
	// Read Only: true
	DatacollectionEntityInlineErrors []*DatacollectionEntityInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// datasource
	// Read Only: true
	Datasource *DataSourceVersion `json:"datasource,omitempty"`

	// The extension of the entity.
	// Read Only: true
	Extension *string `json:"extension,omitempty"`

	// The format of the entity (e.g. pdf document, jpeg image, mp4 video, zip).
	// Example: pdf
	// Read Only: true
	Format *string `json:"format,omitempty"`

	// Indicates if the entity has PII.
	// Example: false
	// Read Only: true
	HasPii *bool `json:"has_pii,omitempty"`

	// The name of the entity.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// permissions
	Permissions *DatacollectionEntityInlinePermissions `json:"permissions,omitempty"`

	// The size of the entity in bytes.
	// Example: 100
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Type of the entity:
	// * <i>file</i> - The entity is a file.
	// * <i>object</i> - The entity is an object.
	//
	// Read Only: true
	// Enum: ["file","object"]
	Type *string `json:"type,omitempty"`

	// The last update time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The URI of the entity.
	// Read Only: true
	URI *string `json:"uri,omitempty"`

	// Unique identifier for the entity.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	// Read Only: true
	Workspace *EntityWorkspaceVersion `json:"workspace,omitempty"`
}

// Validate validates this datacollection entity
func (m *DatacollectionEntity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollectionEntityInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatasource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntity) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) validateAccessTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessTime) { // not required
		return nil
	}

	if err := validate.FormatOf("access_time", "body", "date-time", m.AccessTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) validateAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.Attributes) { // not required
		return nil
	}

	if m.Attributes != nil {
		if err := m.Attributes.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) validateDatacollection(formats strfmt.Registry) error {
	if swag.IsZero(m.Datacollection) { // not required
		return nil
	}

	if m.Datacollection != nil {
		if err := m.Datacollection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datacollection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) validateDatacollectionEntityInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.DatacollectionEntityInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.DatacollectionEntityInlineErrors); i++ {
		if swag.IsZero(m.DatacollectionEntityInlineErrors[i]) { // not required
			continue
		}

		if m.DatacollectionEntityInlineErrors[i] != nil {
			if err := m.DatacollectionEntityInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntity) validateDatasource(formats strfmt.Registry) error {
	if swag.IsZero(m.Datasource) { // not required
		return nil
	}

	if m.Datasource != nil {
		if err := m.Datasource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) validatePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.Permissions) { // not required
		return nil
	}

	if m.Permissions != nil {
		if err := m.Permissions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

var datacollectionEntityTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionEntityTypeTypePropEnum = append(datacollectionEntityTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_entity
	// DatacollectionEntity
	// type
	// Type
	// file
	// END DEBUGGING
	// DatacollectionEntityTypeFile captures enum value "file"
	DatacollectionEntityTypeFile string = "file"

	// BEGIN DEBUGGING
	// datacollection_entity
	// DatacollectionEntity
	// type
	// Type
	// object
	// END DEBUGGING
	// DatacollectionEntityTypeObject captures enum value "object"
	DatacollectionEntityTypeObject string = "object"
)

// prop value enum
func (m *DatacollectionEntity) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionEntityTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionEntity) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection entity based on the context it is used
func (m *DatacollectionEntity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCanPreview(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContentHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollectionEntityInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatasource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtension(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasPii(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntity) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateAccessTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access_time", "body", m.AccessTime); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateAttributes(ctx context.Context, formats strfmt.Registry) error {

	if m.Attributes != nil {
		if err := m.Attributes.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateCanPreview(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "can_preview", "body", m.CanPreview); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateContentHash(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "content_hash", "body", m.ContentHash); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateDatacollection(ctx context.Context, formats strfmt.Registry) error {

	if m.Datacollection != nil {
		if err := m.Datacollection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datacollection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateDatacollectionEntityInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*DatacollectionEntityInlineErrorsInlineArrayItem(m.DatacollectionEntityInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.DatacollectionEntityInlineErrors); i++ {

		if m.DatacollectionEntityInlineErrors[i] != nil {
			if err := m.DatacollectionEntityInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntity) contextValidateDatasource(ctx context.Context, formats strfmt.Registry) error {

	if m.Datasource != nil {
		if err := m.Datasource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateExtension(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "extension", "body", m.Extension); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateHasPii(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "has_pii", "body", m.HasPii); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidatePermissions(ctx context.Context, formats strfmt.Registry) error {

	if m.Permissions != nil {
		if err := m.Permissions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateURI(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uri", "body", m.URI); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionEntity) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntity) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityInlineAttributes datacollection entity inline attributes
//
// swagger:model datacollection_entity_inline_attributes
type DatacollectionEntityInlineAttributes struct {

	// content
	Content []*DatacollectionEntityAttributesContentItems0 `json:"content,omitempty"`

	// custom
	Custom []*DatacollectionEntityAttributesCustomItems0 `json:"custom,omitempty"`

	// extended
	Extended []*DatacollectionEntityAttributesExtendedItems0 `json:"extended,omitempty"`

	// system
	System []*DatacollectionEntityAttributesSystemItems0 `json:"system,omitempty"`
}

// Validate validates this datacollection entity inline attributes
func (m *DatacollectionEntityInlineAttributes) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCustom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExtended(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntityInlineAttributes) validateContent(formats strfmt.Registry) error {
	if swag.IsZero(m.Content) { // not required
		return nil
	}

	for i := 0; i < len(m.Content); i++ {
		if swag.IsZero(m.Content[i]) { // not required
			continue
		}

		if m.Content[i] != nil {
			if err := m.Content[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) validateCustom(formats strfmt.Registry) error {
	if swag.IsZero(m.Custom) { // not required
		return nil
	}

	for i := 0; i < len(m.Custom); i++ {
		if swag.IsZero(m.Custom[i]) { // not required
			continue
		}

		if m.Custom[i] != nil {
			if err := m.Custom[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) validateExtended(formats strfmt.Registry) error {
	if swag.IsZero(m.Extended) { // not required
		return nil
	}

	for i := 0; i < len(m.Extended); i++ {
		if swag.IsZero(m.Extended[i]) { // not required
			continue
		}

		if m.Extended[i] != nil {
			if err := m.Extended[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) validateSystem(formats strfmt.Registry) error {
	if swag.IsZero(m.System) { // not required
		return nil
	}

	for i := 0; i < len(m.System); i++ {
		if swag.IsZero(m.System[i]) { // not required
			continue
		}

		if m.System[i] != nil {
			if err := m.System[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this datacollection entity inline attributes based on the context it is used
func (m *DatacollectionEntityInlineAttributes) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCustom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtended(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntityInlineAttributes) contextValidateContent(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Content); i++ {

		if m.Content[i] != nil {
			if err := m.Content[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) contextValidateCustom(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Custom); i++ {

		if m.Custom[i] != nil {
			if err := m.Custom[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) contextValidateExtended(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Extended); i++ {

		if m.Extended[i] != nil {
			if err := m.Extended[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionEntityInlineAttributes) contextValidateSystem(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.System); i++ {

		if m.System[i] != nil {
			if err := m.System[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityInlineAttributes) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityInlineAttributes) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityInlineAttributes
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityAttributesContentItems0 datacollection entity attributes content items0
//
// swagger:model DatacollectionEntityAttributesContentItems0
type DatacollectionEntityAttributesContentItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this datacollection entity attributes content items0
func (m *DatacollectionEntityAttributesContentItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this datacollection entity attributes content items0 based on context it is used
func (m *DatacollectionEntityAttributesContentItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityAttributesContentItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityAttributesContentItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityAttributesContentItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityAttributesCustomItems0 datacollection entity attributes custom items0
//
// swagger:model DatacollectionEntityAttributesCustomItems0
type DatacollectionEntityAttributesCustomItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this datacollection entity attributes custom items0
func (m *DatacollectionEntityAttributesCustomItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this datacollection entity attributes custom items0 based on context it is used
func (m *DatacollectionEntityAttributesCustomItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityAttributesCustomItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityAttributesCustomItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityAttributesCustomItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityAttributesExtendedItems0 datacollection entity attributes extended items0
//
// swagger:model DatacollectionEntityAttributesExtendedItems0
type DatacollectionEntityAttributesExtendedItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this datacollection entity attributes extended items0
func (m *DatacollectionEntityAttributesExtendedItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this datacollection entity attributes extended items0 based on context it is used
func (m *DatacollectionEntityAttributesExtendedItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityAttributesExtendedItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityAttributesExtendedItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityAttributesExtendedItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityAttributesSystemItems0 datacollection entity attributes system items0
//
// swagger:model DatacollectionEntityAttributesSystemItems0
type DatacollectionEntityAttributesSystemItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this datacollection entity attributes system items0
func (m *DatacollectionEntityAttributesSystemItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this datacollection entity attributes system items0 based on context it is used
func (m *DatacollectionEntityAttributesSystemItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityAttributesSystemItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityAttributesSystemItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityAttributesSystemItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityInlineErrorsInlineArrayItem datacollection entity inline errors inline array item
//
// swagger:model datacollection_entity_inline_errors_inline_array_item
type DatacollectionEntityInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this datacollection entity inline errors inline array item
func (m *DatacollectionEntityInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntityInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection entity inline errors inline array item based on the context it is used
func (m *DatacollectionEntityInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionEntityInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionEntityInlinePermissions The permissions of the entity.
//
// swagger:model datacollection_entity_inline_permissions
type DatacollectionEntityInlinePermissions struct {

	// key
	// Example: owner
	Key *string `json:"key,omitempty"`

	// value
	// Example: rwx
	Value *string `json:"value,omitempty"`
}

// Validate validates this datacollection entity inline permissions
func (m *DatacollectionEntityInlinePermissions) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this datacollection entity inline permissions based on the context it is used
func (m *DatacollectionEntityInlinePermissions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionEntityInlinePermissions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionEntityInlinePermissions) UnmarshalBinary(b []byte) error {
	var res DatacollectionEntityInlinePermissions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
