// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DatacollectionSearch Search result of a data collection.
//
// swagger:model datacollection_search
type DatacollectionSearch struct {

	// The content of the chunk.
	// Read Only: true
	Chunk *string `json:"chunk,omitempty"`

	// entity
	Entity *DatacollectionEntityReference `json:"entity,omitempty"`

	// The index of the chunk in the result.
	// Example: 1
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// Similarity score of the chunk with the prompt that was searched for.
	// Example: 0.9
	// Read Only: true
	Score *float32 `json:"score,omitempty"`
}

// Validate validates this datacollection search
func (m *DatacollectionSearch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEntity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionSearch) validateEntity(formats strfmt.Registry) error {
	if swag.IsZero(m.Entity) { // not required
		return nil
	}

	if m.Entity != nil {
		if err := m.Entity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection search based on the context it is used
func (m *DatacollectionSearch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChunk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScore(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionSearch) contextValidateChunk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "chunk", "body", m.Chunk); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionSearch) contextValidateEntity(ctx context.Context, formats strfmt.Registry) error {

	if m.Entity != nil {
		if err := m.Entity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entity")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionSearch) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionSearch) contextValidateScore(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "score", "body", m.Score); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionSearch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionSearch) UnmarshalBinary(b []byte) error {
	var res DatacollectionSearch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
