// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DatacollectionVersion Data collection version.
//
// swagger:model datacollection_version
type DatacollectionVersion struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// data collection
	DataCollection *DatacollectionVersionInlineDataCollection `json:"data_collection,omitempty"`

	// The unique identifier of the data collection version.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	Workspace *DatacollectionVersionInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this datacollection version
func (m *DatacollectionVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersion) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersion) validateDataCollection(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollection) { // not required
		return nil
	}

	if m.DataCollection != nil {
		if err := m.DataCollection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersion) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection version based on the context it is used
func (m *DatacollectionVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCollection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersion) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersion) contextValidateDataCollection(ctx context.Context, formats strfmt.Registry) error {

	if m.DataCollection != nil {
		if err := m.DataCollection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersion) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersion) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionInlineDataCollection datacollection version inline data collection
//
// swagger:model datacollection_version_inline_data_collection
type DatacollectionVersionInlineDataCollection struct {

	// The creation time of the data collection version.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Description of the data collection.
	// Example: This is an example data collection.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// embedding
	Embedding *DatacollectionVersionInlineDataCollectionInlineEmbedding `json:"embedding,omitempty"`

	// List of entities.
	// Read Only: true
	Entities []*DatacollectionVersionDataCollectionEntitiesItems0 `json:"entities,omitempty"`

	// The count of entities in a data collection.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// errors
	// Read Only: true
	Errors []*DatacollectionVersionDataCollectionErrorsItems0 `json:"errors,omitempty"`

	// The last refresh time of the data collection. This field is generated when the data collection is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The message associated with the current state of the data collection.
	// Example: creating data collection
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Name of the data collection.
	// Example: Example Data Collection
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The owner of the data collection.
	// Example: Eva
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// query
	Query *DatacollectionVersionInlineDataCollectionInlineQuery `json:"query,omitempty"`

	// The size of the data collection, in bytes.
	// Example: 1000
	// Read Only: true
	Size *uint64 `json:"size,omitempty"`

	// State of the data collection version:
	// * <i>draft</i> - The data collection is in draft.
	// * <i>processing</i> - The data collection is being processed.
	// * <i>published</i> - The data collection is published.
	// * <i>failed</i> - The data collection has a failure.
	// * <i>outdated</i> - The data collection is outdated.
	// * Valid in GET requests.
	//
	// Example: published
	// Read Only: true
	// Enum: ["draft","processing","published","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The type of the data collection.
	// * <i>manual</i> - The data collection is created by providing an entities list.
	// * <i>dynamic</i> - The data collection is created with a query selector.
	//
	// Example: dynamic
	// Read Only: true
	// Enum: ["manual","dynamic"]
	Type *string `json:"type,omitempty"`

	// Unique identifier of the data collection.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *DatacollectionVersionInlineDataCollectionInlineVersion `json:"version,omitempty"`

	// Workspace containing the data collection.
	// Read Only: true
	Workspace *WorkspaceReference `json:"workspace,omitempty"`
}

// Validate validates this datacollection version inline data collection
func (m *DatacollectionVersionInlineDataCollection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmbedding(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuery(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateEmbedding(formats strfmt.Registry) error {
	if swag.IsZero(m.Embedding) { // not required
		return nil
	}

	if m.Embedding != nil {
		if err := m.Embedding.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "embedding")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateEntities(formats strfmt.Registry) error {
	if swag.IsZero(m.Entities) { // not required
		return nil
	}

	for i := 0; i < len(m.Entities); i++ {
		if swag.IsZero(m.Entities[i]) { // not required
			continue
		}

		if m.Entities[i] != nil {
			if err := m.Entities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_collection" + "." + "entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.Errors) { // not required
		return nil
	}

	for i := 0; i < len(m.Errors); i++ {
		if swag.IsZero(m.Errors[i]) { // not required
			continue
		}

		if m.Errors[i] != nil {
			if err := m.Errors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_collection" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"last_refresh_time", "body", "date-time", m.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateQuery(formats strfmt.Registry) error {
	if swag.IsZero(m.Query) { // not required
		return nil
	}

	if m.Query != nil {
		if err := m.Query.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "query")
			}
			return err
		}
	}

	return nil
}

var datacollectionVersionInlineDataCollectionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["draft","processing","published","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionInlineDataCollectionTypeStatePropEnum = append(datacollectionVersionInlineDataCollectionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// state
	// State
	// draft
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionStateDraft captures enum value "draft"
	DatacollectionVersionInlineDataCollectionStateDraft string = "draft"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// state
	// State
	// processing
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionStateProcessing captures enum value "processing"
	DatacollectionVersionInlineDataCollectionStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// state
	// State
	// published
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionStatePublished captures enum value "published"
	DatacollectionVersionInlineDataCollectionStatePublished string = "published"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// state
	// State
	// failed
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionStateFailed captures enum value "failed"
	DatacollectionVersionInlineDataCollectionStateFailed string = "failed"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// state
	// State
	// outdated
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionStateOutdated captures enum value "outdated"
	DatacollectionVersionInlineDataCollectionStateOutdated string = "outdated"
)

// prop value enum
func (m *DatacollectionVersionInlineDataCollection) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionInlineDataCollectionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("data_collection"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var datacollectionVersionInlineDataCollectionTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["manual","dynamic"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionInlineDataCollectionTypeTypePropEnum = append(datacollectionVersionInlineDataCollectionTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// type
	// Type
	// manual
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionTypeManual captures enum value "manual"
	DatacollectionVersionInlineDataCollectionTypeManual string = "manual"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection
	// DatacollectionVersionInlineDataCollection
	// type
	// Type
	// dynamic
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionTypeDynamic captures enum value "dynamic"
	DatacollectionVersionInlineDataCollectionTypeDynamic string = "dynamic"
)

// prop value enum
func (m *DatacollectionVersionInlineDataCollection) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionInlineDataCollectionTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("data_collection"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection version inline data collection based on the context it is used
func (m *DatacollectionVersionInlineDataCollection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmbedding(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQuery(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateEmbedding(ctx context.Context, formats strfmt.Registry) error {

	if m.Embedding != nil {
		if err := m.Embedding.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "embedding")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateEntities(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"entities", "body", []*DatacollectionVersionDataCollectionEntitiesItems0(m.Entities)); err != nil {
		return err
	}

	for i := 0; i < len(m.Entities); i++ {

		if m.Entities[i] != nil {
			if err := m.Entities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_collection" + "." + "entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"entity_count", "body", m.EntityCount); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"errors", "body", []*DatacollectionVersionDataCollectionErrorsItems0(m.Errors)); err != nil {
		return err
	}

	for i := 0; i < len(m.Errors); i++ {

		if m.Errors[i] != nil {
			if err := m.Errors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_collection" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"last_refresh_time", "body", m.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateQuery(ctx context.Context, formats strfmt.Registry) error {

	if m.Query != nil {
		if err := m.Query.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "query")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollection) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollection) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionInlineDataCollection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionInlineDataCollectionInlineEmbedding Vectorization settings for the data collection.
//
// swagger:model datacollection_version_inline_data_collection_inline_embedding
type DatacollectionVersionInlineDataCollectionInlineEmbedding struct {

	// The chunk size value in the range (3..1536)
	// Example: 1536
	ChunkSize *int64 `json:"chunk_size,omitempty"`

	// The type of chunking.
	// Enum: ["sentence","paragraph","full_file","semantic","recursive","fixed_size"]
	ChunkType *string `json:"chunk_type,omitempty"`

	// The dimension of vectorization.
	// Example: 1024
	// Enum: [1024]
	Dimension *int64 `json:"dimension,omitempty"`

	// Indicates whether vectorization is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// The vector quantization value.
	// Example: fp32
	// Enum: ["fp32","fp16"]
	Quantization *string `json:"quantization,omitempty"`

	// Indicates whether re_rank is enabled
	// Example: true
	ReRank *bool `json:"re_rank,omitempty"`
}

// Validate validates this datacollection version inline data collection inline embedding
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChunkType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDimension(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuantization(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var datacollectionVersionInlineDataCollectionInlineEmbeddingTypeChunkTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sentence","paragraph","full_file","semantic","recursive","fixed_size"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionInlineDataCollectionInlineEmbeddingTypeChunkTypePropEnum = append(datacollectionVersionInlineDataCollectionInlineEmbeddingTypeChunkTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// sentence
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeSentence captures enum value "sentence"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeSentence string = "sentence"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// paragraph
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeParagraph captures enum value "paragraph"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeParagraph string = "paragraph"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// full_file
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeFullFile captures enum value "full_file"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeFullFile string = "full_file"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// semantic
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeSemantic captures enum value "semantic"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeSemantic string = "semantic"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// recursive
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeRecursive captures enum value "recursive"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeRecursive string = "recursive"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// chunk_type
	// ChunkType
	// fixed_size
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeFixedSize captures enum value "fixed_size"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingChunkTypeFixedSize string = "fixed_size"
)

// prop value enum
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateChunkTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionInlineDataCollectionInlineEmbeddingTypeChunkTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateChunkType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChunkType) { // not required
		return nil
	}

	// value enum
	if err := m.validateChunkTypeEnum("data_collection"+"."+"embedding"+"."+"chunk_type", "body", *m.ChunkType); err != nil {
		return err
	}

	return nil
}

var datacollectionVersionInlineDataCollectionInlineEmbeddingTypeDimensionPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1024]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionInlineDataCollectionInlineEmbeddingTypeDimensionPropEnum = append(datacollectionVersionInlineDataCollectionInlineEmbeddingTypeDimensionPropEnum, v)
	}
}

// prop value enum
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateDimensionEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionInlineDataCollectionInlineEmbeddingTypeDimensionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateDimension(formats strfmt.Registry) error {
	if swag.IsZero(m.Dimension) { // not required
		return nil
	}

	// value enum
	if err := m.validateDimensionEnum("data_collection"+"."+"embedding"+"."+"dimension", "body", *m.Dimension); err != nil {
		return err
	}

	return nil
}

var datacollectionVersionInlineDataCollectionInlineEmbeddingTypeQuantizationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fp32","fp16"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionInlineDataCollectionInlineEmbeddingTypeQuantizationPropEnum = append(datacollectionVersionInlineDataCollectionInlineEmbeddingTypeQuantizationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// quantization
	// Quantization
	// fp32
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingQuantizationFp32 captures enum value "fp32"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingQuantizationFp32 string = "fp32"

	// BEGIN DEBUGGING
	// datacollection_version_inline_data_collection_inline_embedding
	// DatacollectionVersionInlineDataCollectionInlineEmbedding
	// quantization
	// Quantization
	// fp16
	// END DEBUGGING
	// DatacollectionVersionInlineDataCollectionInlineEmbeddingQuantizationFp16 captures enum value "fp16"
	DatacollectionVersionInlineDataCollectionInlineEmbeddingQuantizationFp16 string = "fp16"
)

// prop value enum
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateQuantizationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionInlineDataCollectionInlineEmbeddingTypeQuantizationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) validateQuantization(formats strfmt.Registry) error {
	if swag.IsZero(m.Quantization) { // not required
		return nil
	}

	// value enum
	if err := m.validateQuantizationEnum("data_collection"+"."+"embedding"+"."+"quantization", "body", *m.Quantization); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version inline data collection inline embedding based on the context it is used
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineEmbedding) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionInlineDataCollectionInlineEmbedding
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDataCollectionEntitiesItems0 datacollection version data collection entities items0
//
// swagger:model DatacollectionVersionDataCollectionEntitiesItems0
type DatacollectionVersionDataCollectionEntitiesItems0 struct {

	// Unique identifier of the entity.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version data collection entities items0
func (m *DatacollectionVersionDataCollectionEntitiesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDataCollectionEntitiesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this datacollection version data collection entities items0 based on context it is used
func (m *DatacollectionVersionDataCollectionEntitiesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDataCollectionEntitiesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDataCollectionEntitiesItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDataCollectionEntitiesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDataCollectionErrorsItems0 datacollection version data collection errors items0
//
// swagger:model DatacollectionVersionDataCollectionErrorsItems0
type DatacollectionVersionDataCollectionErrorsItems0 struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this datacollection version data collection errors items0
func (m *DatacollectionVersionDataCollectionErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDataCollectionErrorsItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection version data collection errors items0 based on the context it is used
func (m *DatacollectionVersionDataCollectionErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDataCollectionErrorsItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDataCollectionErrorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDataCollectionErrorsItems0) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDataCollectionErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionInlineDataCollectionInlineQuery The query selector associated with the data collection.
//
// swagger:model datacollection_version_inline_data_collection_inline_query
type DatacollectionVersionInlineDataCollectionInlineQuery struct {

	// The query expression for the selector.
	// Example: {'type': 'pdf'}
	Expression *string `json:"expression,omitempty"`

	// Unique identifier of the query.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version inline data collection inline query
func (m *DatacollectionVersionInlineDataCollectionInlineQuery) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineQuery) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"query"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version inline data collection inline query based on the context it is used
func (m *DatacollectionVersionInlineDataCollectionInlineQuery) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineQuery) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineQuery) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionInlineDataCollectionInlineQuery
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionInlineDataCollectionInlineVersion The version information of a data collection.
//
// swagger:model datacollection_version_inline_data_collection_inline_version
type DatacollectionVersionInlineDataCollectionInlineVersion struct {

	// job
	Job *DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version inline data collection inline version
func (m *DatacollectionVersionInlineDataCollectionInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version inline data collection inline version based on the context it is used
func (m *DatacollectionVersionInlineDataCollectionInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineDataCollectionInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionInlineDataCollectionInlineVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionInlineDataCollectionInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionInlineWorkspace datacollection version inline workspace
//
// swagger:model datacollection_version_inline_workspace
type DatacollectionVersionInlineWorkspace struct {

	// Unique identifier of the workspace.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version inline workspace
func (m *DatacollectionVersionInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version inline workspace based on the context it is used
func (m *DatacollectionVersionInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionInlineWorkspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
