// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DatacollectionVersionDiff Data collection version diff.
//
// swagger:model datacollection_version_diff
type DatacollectionVersionDiff struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The type of change.
	// Read Only: true
	// Enum: ["added","modified","deleted","renamed"]
	ChangeType *string `json:"change_type,omitempty"`

	// data collection
	DataCollection *DatacollectionVersionDiffInlineDataCollection `json:"data_collection,omitempty"`

	// data source
	DataSource *DatacollectionVersionDiffInlineDataSource `json:"data_source,omitempty"`

	// The list of entities.
	// Read Only: true
	DatacollectionVersionDiffInlineEntities []*DatacollectionVersionDiffInlineEntitiesInlineArrayItem `json:"entities,omitempty"`

	// version
	Version *DatacollectionVersionDiffInlineVersion `json:"version,omitempty"`

	// workspace
	Workspace *DatacollectionVersionDiffInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this datacollection version diff
func (m *DatacollectionVersionDiff) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChangeType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatacollectionVersionDiffInlineEntities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiff) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var datacollectionVersionDiffTypeChangeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["added","modified","deleted","renamed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionDiffTypeChangeTypePropEnum = append(datacollectionVersionDiffTypeChangeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_diff
	// DatacollectionVersionDiff
	// change_type
	// ChangeType
	// added
	// END DEBUGGING
	// DatacollectionVersionDiffChangeTypeAdded captures enum value "added"
	DatacollectionVersionDiffChangeTypeAdded string = "added"

	// BEGIN DEBUGGING
	// datacollection_version_diff
	// DatacollectionVersionDiff
	// change_type
	// ChangeType
	// modified
	// END DEBUGGING
	// DatacollectionVersionDiffChangeTypeModified captures enum value "modified"
	DatacollectionVersionDiffChangeTypeModified string = "modified"

	// BEGIN DEBUGGING
	// datacollection_version_diff
	// DatacollectionVersionDiff
	// change_type
	// ChangeType
	// deleted
	// END DEBUGGING
	// DatacollectionVersionDiffChangeTypeDeleted captures enum value "deleted"
	DatacollectionVersionDiffChangeTypeDeleted string = "deleted"

	// BEGIN DEBUGGING
	// datacollection_version_diff
	// DatacollectionVersionDiff
	// change_type
	// ChangeType
	// renamed
	// END DEBUGGING
	// DatacollectionVersionDiffChangeTypeRenamed captures enum value "renamed"
	DatacollectionVersionDiffChangeTypeRenamed string = "renamed"
)

// prop value enum
func (m *DatacollectionVersionDiff) validateChangeTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionDiffTypeChangeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionDiff) validateChangeType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChangeType) { // not required
		return nil
	}

	// value enum
	if err := m.validateChangeTypeEnum("change_type", "body", *m.ChangeType); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiff) validateDataCollection(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollection) { // not required
		return nil
	}

	if m.DataCollection != nil {
		if err := m.DataCollection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSource) { // not required
		return nil
	}

	if m.DataSource != nil {
		if err := m.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) validateDatacollectionVersionDiffInlineEntities(formats strfmt.Registry) error {
	if swag.IsZero(m.DatacollectionVersionDiffInlineEntities) { // not required
		return nil
	}

	for i := 0; i < len(m.DatacollectionVersionDiffInlineEntities); i++ {
		if swag.IsZero(m.DatacollectionVersionDiffInlineEntities[i]) { // not required
			continue
		}

		if m.DatacollectionVersionDiffInlineEntities[i] != nil {
			if err := m.DatacollectionVersionDiffInlineEntities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionDiff) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection version diff based on the context it is used
func (m *DatacollectionVersionDiff) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateChangeType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCollection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatacollectionVersionDiffInlineEntities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiff) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateChangeType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "change_type", "body", m.ChangeType); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateDataCollection(ctx context.Context, formats strfmt.Registry) error {

	if m.DataCollection != nil {
		if err := m.DataCollection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSource != nil {
		if err := m.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateDatacollectionVersionDiffInlineEntities(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entities", "body", []*DatacollectionVersionDiffInlineEntitiesInlineArrayItem(m.DatacollectionVersionDiffInlineEntities)); err != nil {
		return err
	}

	for i := 0; i < len(m.DatacollectionVersionDiffInlineEntities); i++ {

		if m.DatacollectionVersionDiffInlineEntities[i] != nil {
			if err := m.DatacollectionVersionDiffInlineEntities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *DatacollectionVersionDiff) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiff) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiff) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiff
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineDataCollection datacollection version diff inline data collection
//
// swagger:model datacollection_version_diff_inline_data_collection
type DatacollectionVersionDiffInlineDataCollection struct {

	// The name of the data collection.
	// Example: Data Collection 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the data collection.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *DatacollectionVersionDiffInlineDataCollectionInlineVersion `json:"version,omitempty"`
}

// Validate validates this datacollection version diff inline data collection
func (m *DatacollectionVersionDiffInlineDataCollection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineDataCollection) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiffInlineDataCollection) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline data collection based on the context it is used
func (m *DatacollectionVersionDiffInlineDataCollection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineDataCollection) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataCollection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataCollection) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineDataCollection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineDataCollectionInlineVersion The version information of a data collection.
//
// swagger:model datacollection_version_diff_inline_data_collection_inline_version
type DatacollectionVersionDiffInlineDataCollectionInlineVersion struct {

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version diff inline data collection inline version
func (m *DatacollectionVersionDiffInlineDataCollectionInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineDataCollectionInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline data collection inline version based on the context it is used
func (m *DatacollectionVersionDiffInlineDataCollectionInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataCollectionInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataCollectionInlineVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineDataCollectionInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineDataSource Data source information.
//
// swagger:model datacollection_version_diff_inline_data_source
type DatacollectionVersionDiffInlineDataSource struct {

	// The name of the data source.
	// Example: volume 1
	Name *string `json:"name,omitempty"`

	// The type of the data source.
	// Enum: ["volume","bucket"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the data source.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version diff inline data source
func (m *DatacollectionVersionDiffInlineDataSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var datacollectionVersionDiffInlineDataSourceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","bucket"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionDiffInlineDataSourceTypeTypePropEnum = append(datacollectionVersionDiffInlineDataSourceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_diff_inline_data_source
	// DatacollectionVersionDiffInlineDataSource
	// type
	// Type
	// volume
	// END DEBUGGING
	// DatacollectionVersionDiffInlineDataSourceTypeVolume captures enum value "volume"
	DatacollectionVersionDiffInlineDataSourceTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// datacollection_version_diff_inline_data_source
	// DatacollectionVersionDiffInlineDataSource
	// type
	// Type
	// bucket
	// END DEBUGGING
	// DatacollectionVersionDiffInlineDataSourceTypeBucket captures enum value "bucket"
	DatacollectionVersionDiffInlineDataSourceTypeBucket string = "bucket"
)

// prop value enum
func (m *DatacollectionVersionDiffInlineDataSource) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionDiffInlineDataSourceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineDataSource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("data_source"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiffInlineDataSource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_source"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline data source based on the context it is used
func (m *DatacollectionVersionDiffInlineDataSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineDataSource) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineDataSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineEntitiesInlineArrayItem datacollection version diff inline entities inline array item
//
// swagger:model datacollection_version_diff_inline_entities_inline_array_item
type DatacollectionVersionDiffInlineEntitiesInlineArrayItem struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The type of the entity.
	// Enum: ["file","object"]
	EntityType *string `json:"entity_type,omitempty"`

	// The name of the entity.
	Name *string `json:"name,omitempty"`

	// The unique identifier of the entity.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version diff inline entities inline array item
func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntityType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var datacollectionVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		datacollectionVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum = append(datacollectionVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// datacollection_version_diff_inline_entities_inline_array_item
	// DatacollectionVersionDiffInlineEntitiesInlineArrayItem
	// entity_type
	// EntityType
	// file
	// END DEBUGGING
	// DatacollectionVersionDiffInlineEntitiesInlineArrayItemEntityTypeFile captures enum value "file"
	DatacollectionVersionDiffInlineEntitiesInlineArrayItemEntityTypeFile string = "file"

	// BEGIN DEBUGGING
	// datacollection_version_diff_inline_entities_inline_array_item
	// DatacollectionVersionDiffInlineEntitiesInlineArrayItem
	// entity_type
	// EntityType
	// object
	// END DEBUGGING
	// DatacollectionVersionDiffInlineEntitiesInlineArrayItemEntityTypeObject captures enum value "object"
	DatacollectionVersionDiffInlineEntitiesInlineArrayItemEntityTypeObject string = "object"
)

// prop value enum
func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) validateEntityTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, datacollectionVersionDiffInlineEntitiesInlineArrayItemTypeEntityTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) validateEntityType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntityType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntityTypeEnum("entity_type", "body", *m.EntityType); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline entities inline array item based on the context it is used
func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineEntitiesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineEntitiesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineVersion datacollection version diff inline version
//
// swagger:model datacollection_version_diff_inline_version
type DatacollectionVersionDiffInlineVersion struct {

	// The unique identifier of the base version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	Base *strfmt.UUID `json:"base,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version diff inline version
func (m *DatacollectionVersionDiffInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBase(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineVersion) validateBase(formats strfmt.Registry) error {
	if swag.IsZero(m.Base) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"base", "body", "uuid", m.Base.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DatacollectionVersionDiffInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("version"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline version based on the context it is used
func (m *DatacollectionVersionDiffInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineVersion) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineVersion) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DatacollectionVersionDiffInlineWorkspace datacollection version diff inline workspace
//
// swagger:model datacollection_version_diff_inline_workspace
type DatacollectionVersionDiffInlineWorkspace struct {

	// Unique identifier of the workspace.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this datacollection version diff inline workspace
func (m *DatacollectionVersionDiffInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this datacollection version diff inline workspace based on the context it is used
func (m *DatacollectionVersionDiffInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DatacollectionVersionDiffInlineWorkspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DatacollectionVersionDiffInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DatacollectionVersionDiffInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
