// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnBondPort A network port that is to be included in a network bond interface.
//
// swagger:model dcn_bond_port
type DcnBondPort struct {

	// The actual state of the physical network port, as read from the system.
	// Read Only: true
	ActualState *DcnInterfaceState `json:"actual_state,omitempty"`

	// The desired state of the physical network port.
	ConfiguredState *DcnInterfaceState `json:"configured_state,omitempty"`

	// The name of the physical network port that is included in this bond interface.
	// Example: e2a
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this dcn bond port
func (m *DcnBondPort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActualState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfiguredState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnBondPort) validateActualState(formats strfmt.Registry) error {
	if swag.IsZero(m.ActualState) { // not required
		return nil
	}

	if m.ActualState != nil {
		if err := m.ActualState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("actual_state")
			}
			return err
		}
	}

	return nil
}

func (m *DcnBondPort) validateConfiguredState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfiguredState) { // not required
		return nil
	}

	if m.ConfiguredState != nil {
		if err := m.ConfiguredState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configured_state")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn bond port based on the context it is used
func (m *DcnBondPort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActualState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfiguredState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnBondPort) contextValidateActualState(ctx context.Context, formats strfmt.Registry) error {

	if m.ActualState != nil {
		if err := m.ActualState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("actual_state")
			}
			return err
		}
	}

	return nil
}

func (m *DcnBondPort) contextValidateConfiguredState(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfiguredState != nil {
		if err := m.ConfiguredState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configured_state")
			}
			return err
		}
	}

	return nil
}

func (m *DcnBondPort) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnBondPort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnBondPort) UnmarshalBinary(b []byte) error {
	var res DcnBondPort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
