// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnCluster Compute cluster information.
//
// swagger:model dcn_cluster
type DcnCluster struct {

	// links
	Links *DcnClusterInlineLinks `json:"_links,omitempty"`

	// dcn cluster inline nodes
	DcnClusterInlineNodes []*DcnNode `json:"nodes,omitempty"`

	// network pool
	NetworkPool *DcnClusterInlineNetworkPool `json:"network_pool,omitempty"`

	// service ip
	ServiceIP *DcnClusterInlineServiceIP `json:"service_ip,omitempty"`

	// software
	Software *DcnClusterInlineSoftware `json:"software,omitempty"`

	// The UUID of the compute cluster.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this dcn cluster
func (m *DcnCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDcnClusterInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworkPool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSoftware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) validateDcnClusterInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.DcnClusterInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.DcnClusterInlineNodes); i++ {
		if swag.IsZero(m.DcnClusterInlineNodes[i]) { // not required
			continue
		}

		if m.DcnClusterInlineNodes[i] != nil {
			if err := m.DcnClusterInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnCluster) validateNetworkPool(formats strfmt.Registry) error {
	if swag.IsZero(m.NetworkPool) { // not required
		return nil
	}

	if m.NetworkPool != nil {
		if err := m.NetworkPool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_pool")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) validateServiceIP(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceIP) { // not required
		return nil
	}

	if m.ServiceIP != nil {
		if err := m.ServiceIP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_ip")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) validateSoftware(formats strfmt.Registry) error {
	if swag.IsZero(m.Software) { // not required
		return nil
	}

	if m.Software != nil {
		if err := m.Software.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn cluster based on the context it is used
func (m *DcnCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDcnClusterInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkPool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServiceIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) contextValidateDcnClusterInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DcnClusterInlineNodes); i++ {

		if m.DcnClusterInlineNodes[i] != nil {
			if err := m.DcnClusterInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnCluster) contextValidateNetworkPool(ctx context.Context, formats strfmt.Registry) error {

	if m.NetworkPool != nil {
		if err := m.NetworkPool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_pool")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) contextValidateServiceIP(ctx context.Context, formats strfmt.Registry) error {

	if m.ServiceIP != nil {
		if err := m.ServiceIP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_ip")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) contextValidateSoftware(ctx context.Context, formats strfmt.Registry) error {

	if m.Software != nil {
		if err := m.Software.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software")
			}
			return err
		}
	}

	return nil
}

func (m *DcnCluster) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnCluster) UnmarshalBinary(b []byte) error {
	var res DcnCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterInlineLinks dcn cluster inline links
//
// swagger:model dcn_cluster_inline__links
type DcnClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn cluster inline links
func (m *DcnClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster inline links based on the context it is used
func (m *DcnClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterInlineNetworkPool Pool of usable IP addresses for the compute cluster network.
//
// swagger:model dcn_cluster_inline_network_pool
type DcnClusterInlineNetworkPool struct {

	// ip ranges
	IPRanges []*IPAddressRange `json:"ip_ranges,omitempty"`

	// subnet
	Subnet *IPInfo `json:"subnet,omitempty"`
}

// Validate validates this dcn cluster inline network pool
func (m *DcnClusterInlineNetworkPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPRanges(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubnet(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineNetworkPool) validateIPRanges(formats strfmt.Registry) error {
	if swag.IsZero(m.IPRanges) { // not required
		return nil
	}

	for i := 0; i < len(m.IPRanges); i++ {
		if swag.IsZero(m.IPRanges[i]) { // not required
			continue
		}

		if m.IPRanges[i] != nil {
			if err := m.IPRanges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("network_pool" + "." + "ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnClusterInlineNetworkPool) validateSubnet(formats strfmt.Registry) error {
	if swag.IsZero(m.Subnet) { // not required
		return nil
	}

	if m.Subnet != nil {
		if err := m.Subnet.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_pool" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster inline network pool based on the context it is used
func (m *DcnClusterInlineNetworkPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPRanges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubnet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineNetworkPool) contextValidateIPRanges(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IPRanges); i++ {

		if m.IPRanges[i] != nil {
			if err := m.IPRanges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("network_pool" + "." + "ip_ranges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnClusterInlineNetworkPool) contextValidateSubnet(ctx context.Context, formats strfmt.Registry) error {

	if m.Subnet != nil {
		if err := m.Subnet.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_pool" + "." + "subnet")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterInlineNetworkPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterInlineNetworkPool) UnmarshalBinary(b []byte) error {
	var res DcnClusterInlineNetworkPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterInlineServiceIP The floating IP address used by DCN frontend clients to call DCN APIs.
//
// swagger:model dcn_cluster_inline_service_ip
type DcnClusterInlineServiceIP struct {

	// IPv4 or IPv6 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this dcn cluster inline service ip
func (m *DcnClusterInlineServiceIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineServiceIP) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster inline service ip based on the context it is used
func (m *DcnClusterInlineServiceIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineServiceIP) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterInlineServiceIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterInlineServiceIP) UnmarshalBinary(b []byte) error {
	var res DcnClusterInlineServiceIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterInlineSoftware The software information of the DCN cluster.
//
// swagger:model dcn_cluster_inline_software
type DcnClusterInlineSoftware struct {

	// version
	Version *DcnVersion `json:"version,omitempty"`
}

// Validate validates this dcn cluster inline software
func (m *DcnClusterInlineSoftware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineSoftware) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster inline software based on the context it is used
func (m *DcnClusterInlineSoftware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterInlineSoftware) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterInlineSoftware) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterInlineSoftware) UnmarshalBinary(b []byte) error {
	var res DcnClusterInlineSoftware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
