// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnClusterSoftwareInstallStatus dcn cluster software install status
//
// swagger:model dcn_cluster_software_install_status
type DcnClusterSoftwareInstallStatus struct {

	// Upgrade status.
	// Example: false
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// Upgrade duration in ISO 8601 duration format.
	// Example: PT2D2H2M2S
	// Read Only: true
	Duration *string `json:"duration,omitempty"`

	// Upgrade status.
	// Example: Upgrading node1
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Upgrade start time.
	// Example: 2025-05-20 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this dcn cluster software install status
func (m *DcnClusterSoftwareInstallStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwareInstallStatus) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn cluster software install status based on the context it is used
func (m *DcnClusterSoftwareInstallStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwareInstallStatus) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwareInstallStatus) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwareInstallStatus) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwareInstallStatus) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterSoftwareInstallStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterSoftwareInstallStatus) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwareInstallStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
