// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnClusterSoftwarePackage dcn cluster software package
//
// swagger:model dcn_cluster_software_package
type DcnClusterSoftwarePackage struct {

	// links
	Links *DcnClusterSoftwarePackageInlineLinks `json:"_links,omitempty"`

	// DCN software compatibility with ONTAP.
	// Example: true
	// Read Only: true
	Compatible *bool `json:"compatible,omitempty"`

	// Indicates when this package was placed on the system.
	// Example: 2025-05-20 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// install status
	InstallStatus *DcnClusterSoftwareInstallStatus `json:"install_status,omitempty"`

	// Size of the package in bytes.
	// Example: 5368709120
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// True if this software package is currently pending for upgrade. Set to true to start the upgrade.
	// Example: true
	Staged *bool `json:"staged,omitempty"`

	// Current status of the package.
	// Read Only: true
	// Enum: ["available","validating","valid","invalid","unavailable","installing","installed","install_failed","processing","downloading"]
	State *string `json:"state,omitempty"`

	// UUID of this entry.
	// Example: f0ce5ac2-3347-4fa9-9335-ff8f2212bdad
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// version
	Version *DcnVersion `json:"version,omitempty"`
}

// Validate validates this dcn cluster software package
func (m *DcnClusterSoftwarePackage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInstallStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackage) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) validateInstallStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.InstallStatus) { // not required
		return nil
	}

	if m.InstallStatus != nil {
		if err := m.InstallStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("install_status")
			}
			return err
		}
	}

	return nil
}

var dcnClusterSoftwarePackageTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","validating","valid","invalid","unavailable","installing","installed","install_failed","processing","downloading"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnClusterSoftwarePackageTypeStatePropEnum = append(dcnClusterSoftwarePackageTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// available
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateAvailable captures enum value "available"
	DcnClusterSoftwarePackageStateAvailable string = "available"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// validating
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateValidating captures enum value "validating"
	DcnClusterSoftwarePackageStateValidating string = "validating"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// valid
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateValid captures enum value "valid"
	DcnClusterSoftwarePackageStateValid string = "valid"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// invalid
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateInvalid captures enum value "invalid"
	DcnClusterSoftwarePackageStateInvalid string = "invalid"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// unavailable
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateUnavailable captures enum value "unavailable"
	DcnClusterSoftwarePackageStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// installing
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateInstalling captures enum value "installing"
	DcnClusterSoftwarePackageStateInstalling string = "installing"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// installed
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateInstalled captures enum value "installed"
	DcnClusterSoftwarePackageStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// install_failed
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateInstallFailed captures enum value "install_failed"
	DcnClusterSoftwarePackageStateInstallFailed string = "install_failed"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// processing
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateProcessing captures enum value "processing"
	DcnClusterSoftwarePackageStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// dcn_cluster_software_package
	// DcnClusterSoftwarePackage
	// state
	// State
	// downloading
	// END DEBUGGING
	// DcnClusterSoftwarePackageStateDownloading captures enum value "downloading"
	DcnClusterSoftwarePackageStateDownloading string = "downloading"
)

// prop value enum
func (m *DcnClusterSoftwarePackage) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnClusterSoftwarePackageTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnClusterSoftwarePackage) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package based on the context it is used
func (m *DcnClusterSoftwarePackage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompatible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInstallStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateCompatible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compatible", "body", m.Compatible); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateInstallStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.InstallStatus != nil {
		if err := m.InstallStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("install_status")
			}
			return err
		}
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DcnClusterSoftwarePackage) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterSoftwarePackage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterSoftwarePackage) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterSoftwarePackageInlineLinks dcn cluster software package inline links
//
// swagger:model dcn_cluster_software_package_inline__links
type DcnClusterSoftwarePackageInlineLinks struct {

	// self
	Self *DcnClusterSoftwarePackageInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this dcn cluster software package inline links
func (m *DcnClusterSoftwarePackageInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package inline links based on the context it is used
func (m *DcnClusterSoftwarePackageInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnClusterSoftwarePackageInlineLinksInlineSelf dcn cluster software package inline links inline self
//
// swagger:model dcn_cluster_software_package_inline__links_inline_self
type DcnClusterSoftwarePackageInlineLinksInlineSelf struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn cluster software package inline links inline self
func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn cluster software package inline links inline self based on the context it is used
func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
