// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// DcnClusterSoftwarePackageResponse dcn cluster software package response
//
// swagger:model dcn_cluster_software_package_response
type DcnClusterSoftwarePackageResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// dcn cluster software package response inline records
	DcnClusterSoftwarePackageResponseInlineRecords []*DcnClusterSoftwarePackage `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this dcn cluster software package response
func (m *DcnClusterSoftwarePackageResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDcnClusterSoftwarePackageResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnClusterSoftwarePackageResponse) validateDcnClusterSoftwarePackageResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DcnClusterSoftwarePackageResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DcnClusterSoftwarePackageResponseInlineRecords); i++ {
		if swag.IsZero(m.DcnClusterSoftwarePackageResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DcnClusterSoftwarePackageResponseInlineRecords[i] != nil {
			if err := m.DcnClusterSoftwarePackageResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this dcn cluster software package response based on the context it is used
func (m *DcnClusterSoftwarePackageResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDcnClusterSoftwarePackageResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnClusterSoftwarePackageResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnClusterSoftwarePackageResponse) contextValidateDcnClusterSoftwarePackageResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DcnClusterSoftwarePackageResponseInlineRecords); i++ {

		if m.DcnClusterSoftwarePackageResponseInlineRecords[i] != nil {
			if err := m.DcnClusterSoftwarePackageResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnClusterSoftwarePackageResponse) UnmarshalBinary(b []byte) error {
	var res DcnClusterSoftwarePackageResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
