// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnFru The field replaceable units (FRUs) on the node.
//
// swagger:model dcn_fru
type DcnFru struct {

	// Number count of the FRUs.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// fru type
	// Read Only: true
	// Enum: ["fan","psu","pcie","dimm"]
	FruType *string `json:"fru_type,omitempty"`

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`
}

// Validate validates this dcn fru
func (m *DcnFru) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFruType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dcnFruTypeFruTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","dimm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnFruTypeFruTypePropEnum = append(dcnFruTypeFruTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_fru
	// DcnFru
	// fru_type
	// FruType
	// fan
	// END DEBUGGING
	// DcnFruFruTypeFan captures enum value "fan"
	DcnFruFruTypeFan string = "fan"

	// BEGIN DEBUGGING
	// dcn_fru
	// DcnFru
	// fru_type
	// FruType
	// psu
	// END DEBUGGING
	// DcnFruFruTypePsu captures enum value "psu"
	DcnFruFruTypePsu string = "psu"

	// BEGIN DEBUGGING
	// dcn_fru
	// DcnFru
	// fru_type
	// FruType
	// pcie
	// END DEBUGGING
	// DcnFruFruTypePcie captures enum value "pcie"
	DcnFruFruTypePcie string = "pcie"

	// BEGIN DEBUGGING
	// dcn_fru
	// DcnFru
	// fru_type
	// FruType
	// dimm
	// END DEBUGGING
	// DcnFruFruTypeDimm captures enum value "dimm"
	DcnFruFruTypeDimm string = "dimm"
)

// prop value enum
func (m *DcnFru) validateFruTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnFruTypeFruTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnFru) validateFruType(formats strfmt.Registry) error {
	if swag.IsZero(m.FruType) { // not required
		return nil
	}

	// value enum
	if err := m.validateFruTypeEnum("fru_type", "body", *m.FruType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn fru based on the context it is used
func (m *DcnFru) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFruType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnFru) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *DcnFru) contextValidateFruType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fru_type", "body", m.FruType); err != nil {
		return err
	}

	return nil
}

func (m *DcnFru) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnFru) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnFru) UnmarshalBinary(b []byte) error {
	var res DcnFru
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
