// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnHardware Hardware information.
//
// swagger:model dcn_hardware
type DcnHardware struct {

	// Type of the system board, defined by the vendor.
	// Example: System Board XXVIII
	// Read Only: true
	Board *string `json:"board,omitempty"`

	// cpu
	CPU *DcnHardwareInlineCPU `json:"cpu,omitempty"`

	// dcn hardware inline frus
	// Read Only: true
	DcnHardwareInlineFrus []*DcnFru `json:"frus,omitempty"`

	// gpu
	Gpu *DcnHardwareInlineGpu `json:"gpu,omitempty"`
}

// Validate validates this dcn hardware
func (m *DcnHardware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDcnHardwareInlineFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGpu(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnHardware) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnHardware) validateDcnHardwareInlineFrus(formats strfmt.Registry) error {
	if swag.IsZero(m.DcnHardwareInlineFrus) { // not required
		return nil
	}

	for i := 0; i < len(m.DcnHardwareInlineFrus); i++ {
		if swag.IsZero(m.DcnHardwareInlineFrus[i]) { // not required
			continue
		}

		if m.DcnHardwareInlineFrus[i] != nil {
			if err := m.DcnHardwareInlineFrus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnHardware) validateGpu(formats strfmt.Registry) error {
	if swag.IsZero(m.Gpu) { // not required
		return nil
	}

	if m.Gpu != nil {
		if err := m.Gpu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn hardware based on the context it is used
func (m *DcnHardware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBoard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDcnHardwareInlineFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGpu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnHardware) contextValidateBoard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "board", "body", m.Board); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardware) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnHardware) contextValidateDcnHardwareInlineFrus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "frus", "body", []*DcnFru(m.DcnHardwareInlineFrus)); err != nil {
		return err
	}

	for i := 0; i < len(m.DcnHardwareInlineFrus); i++ {

		if m.DcnHardwareInlineFrus[i] != nil {
			if err := m.DcnHardwareInlineFrus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnHardware) contextValidateGpu(ctx context.Context, formats strfmt.Registry) error {

	if m.Gpu != nil {
		if err := m.Gpu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnHardware) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnHardware) UnmarshalBinary(b []byte) error {
	var res DcnHardware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnHardwareInlineCPU CPU information.
//
// swagger:model dcn_hardware_inline_cpu
type DcnHardwareInlineCPU struct {

	// Number count of CPUs on the node.
	// Example: 20
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Firmware release number. Defined by the CPU manufacturer.
	// Read Only: true
	FirmwareRelease *string `json:"firmware_release,omitempty"`

	// GPU Memory available on the node, in bytes.
	// Example: 1024000000
	// Read Only: true
	MemorySize *int64 `json:"memory_size,omitempty"`

	// CPU type on the node.
	// Read Only: true
	Processor *string `json:"processor,omitempty"`
}

// Validate validates this dcn hardware inline cpu
func (m *DcnHardwareInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this dcn hardware inline cpu based on the context it is used
func (m *DcnHardwareInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemorySize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnHardwareInlineCPU) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cpu"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineCPU) contextValidateFirmwareRelease(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cpu"+"."+"firmware_release", "body", m.FirmwareRelease); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineCPU) contextValidateMemorySize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cpu"+"."+"memory_size", "body", m.MemorySize); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineCPU) contextValidateProcessor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cpu"+"."+"processor", "body", m.Processor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnHardwareInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnHardwareInlineCPU) UnmarshalBinary(b []byte) error {
	var res DcnHardwareInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnHardwareInlineGpu GPU information.
//
// swagger:model dcn_hardware_inline_gpu
type DcnHardwareInlineGpu struct {

	// Number count of GPUs on the node.
	// Example: 4
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Firmware release number. Defined by the GPU manufacturer.
	// Read Only: true
	FirmwareRelease *string `json:"firmware_release,omitempty"`

	// GPU Memory available on the node, in bytes.
	// Example: 1024000000
	// Read Only: true
	MemorySize *int64 `json:"memory_size,omitempty"`

	// GPU type on the node.
	// Read Only: true
	Processor *string `json:"processor,omitempty"`
}

// Validate validates this dcn hardware inline gpu
func (m *DcnHardwareInlineGpu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this dcn hardware inline gpu based on the context it is used
func (m *DcnHardwareInlineGpu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemorySize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnHardwareInlineGpu) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "gpu"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineGpu) contextValidateFirmwareRelease(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "gpu"+"."+"firmware_release", "body", m.FirmwareRelease); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineGpu) contextValidateMemorySize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "gpu"+"."+"memory_size", "body", m.MemorySize); err != nil {
		return err
	}

	return nil
}

func (m *DcnHardwareInlineGpu) contextValidateProcessor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "gpu"+"."+"processor", "body", m.Processor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnHardwareInlineGpu) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnHardwareInlineGpu) UnmarshalBinary(b []byte) error {
	var res DcnHardwareInlineGpu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
