// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnNode Compute node information.
//
// swagger:model dcn_node
type DcnNode struct {

	// links
	Links *DcnNodeInlineLinks `json:"_links,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// dcn node inline error
	// Read Only: true
	DcnNodeInlineError []*DcnNodeError `json:"error,omitempty"`

	// hardware
	Hardware *DcnHardware `json:"hardware,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// Possible values:
	// * <i>available</i> - A node is detected on the network and can be added to the compute cluster. Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *DcnNodeMetrics `json:"metric,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// The node's hostname.
	// Example: node1
	Name *string `json:"name,omitempty"`

	// network
	Network *DcnNodeInlineNetwork `json:"network,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	SerialNumber *string `json:"serial_number,omitempty"`

	// software
	Software *DcnNodeInlineSoftware `json:"software,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>degraded</i> - Node has one or more critical services offline.
	//
	// Read Only: true
	// Enum: ["up","down","degraded"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *DcnNodeStatistics `json:"statistics,omitempty"`

	// system id
	// Example: 0537035403
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// The total time that the node has been up, in seconds.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`
}

// Validate validates this dcn node
func (m *DcnNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDcnNodeInlineError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHardware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSoftware(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("date", "body", "date-time", m.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) validateDcnNodeInlineError(formats strfmt.Registry) error {
	if swag.IsZero(m.DcnNodeInlineError) { // not required
		return nil
	}

	for i := 0; i < len(m.DcnNodeInlineError); i++ {
		if swag.IsZero(m.DcnNodeInlineError[i]) { // not required
			continue
		}

		if m.DcnNodeInlineError[i] != nil {
			if err := m.DcnNodeInlineError[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnNode) validateHardware(formats strfmt.Registry) error {
	if swag.IsZero(m.Hardware) { // not required
		return nil
	}

	if m.Hardware != nil {
		if err := m.Hardware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hardware")
			}
			return err
		}
	}

	return nil
}

var dcnNodeTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeTypeMembershipPropEnum = append(dcnNodeTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// membership
	// Membership
	// available
	// END DEBUGGING
	// DcnNodeMembershipAvailable captures enum value "available"
	DcnNodeMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// DcnNodeMembershipJoining captures enum value "joining"
	DcnNodeMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// membership
	// Membership
	// member
	// END DEBUGGING
	// DcnNodeMembershipMember captures enum value "member"
	DcnNodeMembershipMember string = "member"
)

// prop value enum
func (m *DcnNode) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNode) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(m.Membership) { // not required
		return nil
	}

	// value enum
	if err := m.validateMembershipEnum("membership", "body", *m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) validateNetwork(formats strfmt.Registry) error {
	if swag.IsZero(m.Network) { // not required
		return nil
	}

	if m.Network != nil {
		if err := m.Network.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) validateSoftware(formats strfmt.Registry) error {
	if swag.IsZero(m.Software) { // not required
		return nil
	}

	if m.Software != nil {
		if err := m.Software.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software")
			}
			return err
		}
	}

	return nil
}

var dcnNodeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","degraded"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeTypeStatePropEnum = append(dcnNodeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// state
	// State
	// up
	// END DEBUGGING
	// DcnNodeStateUp captures enum value "up"
	DcnNodeStateUp string = "up"

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// state
	// State
	// down
	// END DEBUGGING
	// DcnNodeStateDown captures enum value "down"
	DcnNodeStateDown string = "down"

	// BEGIN DEBUGGING
	// dcn_node
	// DcnNode
	// state
	// State
	// degraded
	// END DEBUGGING
	// DcnNodeStateDegraded captures enum value "degraded"
	DcnNodeStateDegraded string = "degraded"
)

// prop value enum
func (m *DcnNode) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNode) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn node based on the context it is used
func (m *DcnNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDcnNodeInlineError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHardware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetwork(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoftware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "date", "body", m.Date); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateDcnNodeInlineError(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error", "body", []*DcnNodeError(m.DcnNodeInlineError)); err != nil {
		return err
	}

	for i := 0; i < len(m.DcnNodeInlineError); i++ {

		if m.DcnNodeInlineError[i] != nil {
			if err := m.DcnNodeInlineError[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DcnNode) contextValidateHardware(ctx context.Context, formats strfmt.Registry) error {

	if m.Hardware != nil {
		if err := m.Hardware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hardware")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "membership", "body", m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateNetwork(ctx context.Context, formats strfmt.Registry) error {

	if m.Network != nil {
		if err := m.Network.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateSoftware(ctx context.Context, formats strfmt.Registry) error {

	if m.Software != nil {
		if err := m.Software.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNode) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_id", "body", m.SystemID); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uptime", "body", m.Uptime); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DcnNode) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vendor_serial_number", "body", m.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNode) UnmarshalBinary(b []byte) error {
	var res DcnNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeInlineLinks dcn node inline links
//
// swagger:model dcn_node_inline__links
type DcnNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn node inline links
func (m *DcnNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline links based on the context it is used
func (m *DcnNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeInlineNetwork dcn node inline network
//
// swagger:model dcn_node_inline_network
type DcnNodeInlineNetwork struct {

	// Information about the configuration and state of the node's internal (cluster) network interface.
	DcnNodeInlineNetworkInlineInternalInterface interface{} `json:"internal_interface,omitempty"`

	// external interface
	ExternalInterface *DcnNodeInlineNetworkInlineExternalInterface `json:"external_interface,omitempty"`
}

// Validate validates this dcn node inline network
func (m *DcnNodeInlineNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExternalInterface(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineNetwork) validateExternalInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalInterface) { // not required
		return nil
	}

	if m.ExternalInterface != nil {
		if err := m.ExternalInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network" + "." + "external_interface")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline network based on the context it is used
func (m *DcnNodeInlineNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExternalInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineNetwork) contextValidateExternalInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalInterface != nil {
		if err := m.ExternalInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network" + "." + "external_interface")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeInlineNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeInlineNetwork) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeInlineNetworkInlineExternalInterface Information about the configuration and state of the node's external network interface.
//
// swagger:model dcn_node_inline_network_inline_external_interface
type DcnNodeInlineNetworkInlineExternalInterface struct {

	// The MAC address of the node's external interface.
	// Example: 00:B0:D0:63:C2:26
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// The MTU of the external interface.
	// Example: 1500
	Mtu *int64 `json:"mtu,omitempty"`

	// The OS-level name of the external network interface.
	// Example: ext
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this dcn node inline network inline external interface
func (m *DcnNodeInlineNetworkInlineExternalInterface) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this dcn node inline network inline external interface based on the context it is used
func (m *DcnNodeInlineNetworkInlineExternalInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineNetworkInlineExternalInterface) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "network"+"."+"external_interface"+"."+"mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeInlineNetworkInlineExternalInterface) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "network"+"."+"external_interface"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeInlineNetworkInlineExternalInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeInlineNetworkInlineExternalInterface) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineNetworkInlineExternalInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeInlineSoftware The software information of the node.
//
// swagger:model dcn_node_inline_software
type DcnNodeInlineSoftware struct {

	// Indicates whether the node's software version is compatible with the ONTAP cluster. A node is considered compatible if its software release is not newer than the ONTAP cluster's release, and not more than four major versions older. This field helps determine if the node can join or be used to form the DCN cluster.
	//
	// Enum: ["full","incompatible"]
	Compatibility *string `json:"compatibility,omitempty"`

	// version
	Version *DcnVersion `json:"version,omitempty"`
}

// Validate validates this dcn node inline software
func (m *DcnNodeInlineSoftware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCompatibility(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dcnNodeInlineSoftwareTypeCompatibilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","incompatible"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeInlineSoftwareTypeCompatibilityPropEnum = append(dcnNodeInlineSoftwareTypeCompatibilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_inline_software
	// DcnNodeInlineSoftware
	// compatibility
	// Compatibility
	// full
	// END DEBUGGING
	// DcnNodeInlineSoftwareCompatibilityFull captures enum value "full"
	DcnNodeInlineSoftwareCompatibilityFull string = "full"

	// BEGIN DEBUGGING
	// dcn_node_inline_software
	// DcnNodeInlineSoftware
	// compatibility
	// Compatibility
	// incompatible
	// END DEBUGGING
	// DcnNodeInlineSoftwareCompatibilityIncompatible captures enum value "incompatible"
	DcnNodeInlineSoftwareCompatibilityIncompatible string = "incompatible"
)

// prop value enum
func (m *DcnNodeInlineSoftware) validateCompatibilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeInlineSoftwareTypeCompatibilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeInlineSoftware) validateCompatibility(formats strfmt.Registry) error {
	if swag.IsZero(m.Compatibility) { // not required
		return nil
	}

	// value enum
	if err := m.validateCompatibilityEnum("software"+"."+"compatibility", "body", *m.Compatibility); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeInlineSoftware) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node inline software based on the context it is used
func (m *DcnNodeInlineSoftware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeInlineSoftware) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("software" + "." + "version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeInlineSoftware) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeInlineSoftware) UnmarshalBinary(b []byte) error {
	var res DcnNodeInlineSoftware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
