// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnNodeMetrics CPU and GPU performance metrics for the nodes. It provides detailed insights into the utilization and memory usage of the processors over specified time durations.
//
// swagger:model dcn_node_metrics
type DcnNodeMetrics struct {

	// links
	Links *DcnNodeMetricsInlineLinks `json:"_links,omitempty"`

	// cpu
	CPU *DcnNodeMetricsInlineCPU `json:"cpu,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// gpu
	Gpu *DcnNodeMetricsInlineGpu `json:"gpu,omitempty"`

	// * ok: The sample was collected successfully without any errors.
	// * error: An internal uncategorized failure occurred during the sample collection.
	// * partial_no_data: The sample collection was incomplete due to missing data.
	// * partial_no_uuid: The sample collection was incomplete due to a missing UUID.
	// * partial_no_response: The sample collection was incomplete due to no response from one or more nodes.
	// * partial_other_error: The sample collection was incomplete due to other unspecified errors.
	// * negative_delta: An expected monotonically increasing value has decreased in value.
	// * backfilled_data: The sample collection was completed at a later time and backfilled to the previous 15-second timestamp.
	// * inconsistent_delta_time: The time between two collections is not the same for all nodes, causing the aggregated value to be over or under-inflated.
	// * inconsistent_old_data: One or more nodes do not have the latest data.
	//
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// Unique identifier for the node.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this dcn node metrics
func (m *DcnNodeMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGpu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetrics) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

var dcnNodeMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeMetricsTypeDurationPropEnum = append(dcnNodeMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// DcnNodeMetricsDurationPT15S captures enum value "PT15S"
	DcnNodeMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// DcnNodeMetricsDurationPT5M captures enum value "PT5M"
	DcnNodeMetricsDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// DcnNodeMetricsDurationPT30M captures enum value "PT30M"
	DcnNodeMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// DcnNodeMetricsDurationPT2H captures enum value "PT2H"
	DcnNodeMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// DcnNodeMetricsDurationP1D captures enum value "P1D"
	DcnNodeMetricsDurationP1D string = "P1D"
)

// prop value enum
func (m *DcnNodeMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeMetrics) validateGpu(formats strfmt.Registry) error {
	if swag.IsZero(m.Gpu) { // not required
		return nil
	}

	if m.Gpu != nil {
		if err := m.Gpu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

var dcnNodeMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeMetricsTypeStatusPropEnum = append(dcnNodeMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// DcnNodeMetricsStatusOk captures enum value "ok"
	DcnNodeMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// DcnNodeMetricsStatusError captures enum value "error"
	DcnNodeMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// DcnNodeMetricsStatusPartialNoData captures enum value "partial_no_data"
	DcnNodeMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// DcnNodeMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	DcnNodeMetricsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// DcnNodeMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	DcnNodeMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// DcnNodeMetricsStatusPartialOtherError captures enum value "partial_other_error"
	DcnNodeMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// DcnNodeMetricsStatusNegativeDelta captures enum value "negative_delta"
	DcnNodeMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// DcnNodeMetricsStatusBackfilledData captures enum value "backfilled_data"
	DcnNodeMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// DcnNodeMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	DcnNodeMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// dcn_node_metrics
	// DcnNodeMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// DcnNodeMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	DcnNodeMetricsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *DcnNodeMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn node metrics based on the context it is used
func (m *DcnNodeMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGpu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetrics) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetrics) contextValidateGpu(ctx context.Context, formats strfmt.Registry) error {

	if m.Gpu != nil {
		if err := m.Gpu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetrics) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsInlineCPU dcn node metrics inline cpu
//
// swagger:model dcn_node_metrics_inline_cpu
type DcnNodeMetricsInlineCPU struct {

	// Average memory usage on the node's CPUs, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Average CPU utilization for the node.
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`
}

// Validate validates this dcn node metrics inline cpu
func (m *DcnNodeMetricsInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node metrics inline cpu based on context it is used
func (m *DcnNodeMetricsInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsInlineCPU) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsInlineGpu dcn node metrics inline gpu
//
// swagger:model dcn_node_metrics_inline_gpu
type DcnNodeMetricsInlineGpu struct {

	// Average memory usage on the node's GPUs, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Average GPU utilization for the node.
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`
}

// Validate validates this dcn node metrics inline gpu
func (m *DcnNodeMetricsInlineGpu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node metrics inline gpu based on context it is used
func (m *DcnNodeMetricsInlineGpu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsInlineGpu) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsInlineGpu) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsInlineGpu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsInlineLinks dcn node metrics inline links
//
// swagger:model dcn_node_metrics_inline__links
type DcnNodeMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn node metrics inline links
func (m *DcnNodeMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node metrics inline links based on the context it is used
func (m *DcnNodeMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
