// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnNodeMetricsResponse A collection of historical performance metrics for a node.
//
// swagger:model dcn_node_metrics_response
type DcnNodeMetricsResponse struct {

	// links
	Links *DcnNodeMetricsResponseInlineLinks `json:"_links,omitempty"`

	// dcn node metrics response inline records
	DcnNodeMetricsResponseInlineRecords []*DcnNodeMetricsResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this dcn node metrics response
func (m *DcnNodeMetricsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDcnNodeMetricsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponse) validateDcnNodeMetricsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DcnNodeMetricsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DcnNodeMetricsResponseInlineRecords); i++ {
		if swag.IsZero(m.DcnNodeMetricsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DcnNodeMetricsResponseInlineRecords[i] != nil {
			if err := m.DcnNodeMetricsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this dcn node metrics response based on the context it is used
func (m *DcnNodeMetricsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDcnNodeMetricsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponse) contextValidateDcnNodeMetricsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DcnNodeMetricsResponseInlineRecords); i++ {

		if m.DcnNodeMetricsResponseInlineRecords[i] != nil {
			if err := m.DcnNodeMetricsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponse) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsResponseInlineLinks dcn node metrics response inline links
//
// swagger:model dcn_node_metrics_response_inline__links
type DcnNodeMetricsResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn node metrics response inline links
func (m *DcnNodeMetricsResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node metrics response inline links based on the context it is used
func (m *DcnNodeMetricsResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsResponseInlineRecordsInlineArrayItem CPU and GPU performance metrics for the nodes. It provides detailed insights into the utilization and memory usage of the processors over specified time durations.
//
// swagger:model dcn_node_metrics_response_inline_records_inline_array_item
type DcnNodeMetricsResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// cpu
	CPU *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU `json:"cpu,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// gpu
	Gpu *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu `json:"gpu,omitempty"`

	// * ok: The sample was collected successfully without any errors.
	// * error: An internal uncategorized failure occurred during the sample collection.
	// * partial_no_data: The sample collection was incomplete due to missing data.
	// * partial_no_uuid: The sample collection was incomplete due to a missing UUID.
	// * partial_no_response: The sample collection was incomplete due to no response from one or more nodes.
	// * partial_other_error: The sample collection was incomplete due to other unspecified errors.
	// * negative_delta: An expected monotonically increasing value has decreased in value.
	// * backfilled_data: The sample collection was completed at a later time and backfilled to the previous 15-second timestamp.
	// * inconsistent_delta_time: The time between two collections is not the same for all nodes, causing the aggregated value to be over or under-inflated.
	// * inconsistent_old_data: One or more nodes do not have the latest data.
	//
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// Unique identifier for the node.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this dcn node metrics response inline records inline array item
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGpu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

var dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeDurationPropEnum = append(dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT15S captures enum value "PT15S"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT5M captures enum value "PT5M"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT30M captures enum value "PT30M"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT2H captures enum value "PT2H"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationP1D captures enum value "P1D"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemDurationP1D string = "P1D"
)

// prop value enum
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateGpu(formats strfmt.Registry) error {
	if swag.IsZero(m.Gpu) { // not required
		return nil
	}

	if m.Gpu != nil {
		if err := m.Gpu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

var dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeStatusPropEnum = append(dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// ok
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusOk captures enum value "ok"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusOk string = "ok"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// error
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusError captures enum value "error"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusError string = "error"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoData captures enum value "partial_no_data"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoUUID captures enum value "partial_no_uuid"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoResponse captures enum value "partial_no_response"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialOtherError captures enum value "partial_other_error"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusNegativeDelta captures enum value "negative_delta"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusBackfilledData captures enum value "backfilled_data"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// dcn_node_metrics_response_inline_records_inline_array_item
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusInconsistentOldData captures enum value "inconsistent_old_data"
	DcnNodeMetricsResponseInlineRecordsInlineArrayItemStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeMetricsResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn node metrics response inline records inline array item based on the context it is used
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGpu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) contextValidateGpu(ctx context.Context, formats strfmt.Registry) error {

	if m.Gpu != nil {
		if err := m.Gpu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU dcn node metrics response inline records inline array item inline cpu
//
// swagger:model dcn_node_metrics_response_inline_records_inline_array_item_inline_cpu
type DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU struct {

	// Average memory usage on the node's CPUs, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Average CPU utilization for the node.
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`
}

// Validate validates this dcn node metrics response inline records inline array item inline cpu
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node metrics response inline records inline array item inline cpu based on context it is used
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu dcn node metrics response inline records inline array item inline gpu
//
// swagger:model dcn_node_metrics_response_inline_records_inline_array_item_inline_gpu
type DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu struct {

	// Average memory usage on the node's GPUs, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Average GPU utilization for the node.
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`
}

// Validate validates this dcn node metrics response inline records inline array item inline gpu
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node metrics response inline records inline array item inline gpu based on context it is used
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineGpu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks dcn node metrics response inline records inline array item inline links
//
// swagger:model dcn_node_metrics_response_inline_records_inline_array_item_inline__links
type DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this dcn node metrics response inline records inline array item inline links
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node metrics response inline records inline array item inline links based on the context it is used
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeMetricsResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
