// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnNodeStatistics Detailed CPU and GPU performance metrics for the nodes. It provides raw utilization and memory usage data, enabling precise calculations of processor performance.
//
// swagger:model dcn_node_statistics
type DcnNodeStatistics struct {

	// cpu
	CPU *DcnNodeStatisticsInlineCPU `json:"cpu,omitempty"`

	// gpu
	Gpu *DcnNodeStatisticsInlineGpu `json:"gpu,omitempty"`

	// * ok: The sample was collected successfully without any errors.
	// * error: An internal uncategorized failure occurred during the sample collection.
	// * partial_no_data: The sample collection was incomplete due to missing data.
	// * partial_no_uuid: The sample collection was incomplete due to a missing UUID.
	// * partial_no_response: The sample collection was incomplete due to no response from one or more nodes.
	// * partial_other_error: The sample collection was incomplete due to other unspecified errors.
	// * negative_delta: An expected monotonically increasing value has decreased in value.
	// * backfilled_data: The sample collection was completed at a later time and backfilled to the previous 15-second timestamp.
	// * inconsistent_delta_time: The time between two collections is not the same for all nodes, causing the aggregated value to be over or under-inflated.
	// * inconsistent_old_data: One or more nodes do not have the latest data.
	//
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this dcn node statistics
func (m *DcnNodeStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGpu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeStatistics) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeStatistics) validateGpu(formats strfmt.Registry) error {
	if swag.IsZero(m.Gpu) { // not required
		return nil
	}

	if m.Gpu != nil {
		if err := m.Gpu.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

var dcnNodeStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnNodeStatisticsTypeStatusPropEnum = append(dcnNodeStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// DcnNodeStatisticsStatusOk captures enum value "ok"
	DcnNodeStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// DcnNodeStatisticsStatusError captures enum value "error"
	DcnNodeStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// DcnNodeStatisticsStatusPartialNoData captures enum value "partial_no_data"
	DcnNodeStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// DcnNodeStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	DcnNodeStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// DcnNodeStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	DcnNodeStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// DcnNodeStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	DcnNodeStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// DcnNodeStatisticsStatusNegativeDelta captures enum value "negative_delta"
	DcnNodeStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// DcnNodeStatisticsStatusBackfilledData captures enum value "backfilled_data"
	DcnNodeStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// DcnNodeStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	DcnNodeStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// dcn_node_statistics
	// DcnNodeStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// DcnNodeStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	DcnNodeStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *DcnNodeStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnNodeStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnNodeStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DcnNodeStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn node statistics based on the context it is used
func (m *DcnNodeStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGpu(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnNodeStatistics) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *DcnNodeStatistics) contextValidateGpu(ctx context.Context, formats strfmt.Registry) error {

	if m.Gpu != nil {
		if err := m.Gpu.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gpu")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeStatistics) UnmarshalBinary(b []byte) error {
	var res DcnNodeStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeStatisticsInlineCPU dcn node statistics inline cpu
//
// swagger:model dcn_node_statistics_inline_cpu
type DcnNodeStatisticsInlineCPU struct {

	// Current memory usage on the node, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Base counter for CPU utilization.
	// Example: 35042835393
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw CPU utilization for the node. Divide this by the processor_utilization_base to calculate the percentage CPU utilization for the node.
	// Example: 2514992973
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`
}

// Validate validates this dcn node statistics inline cpu
func (m *DcnNodeStatisticsInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node statistics inline cpu based on context it is used
func (m *DcnNodeStatisticsInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeStatisticsInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeStatisticsInlineCPU) UnmarshalBinary(b []byte) error {
	var res DcnNodeStatisticsInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnNodeStatisticsInlineGpu dcn node statistics inline gpu
//
// swagger:model dcn_node_statistics_inline_gpu
type DcnNodeStatisticsInlineGpu struct {

	// Current memory usage on the node, in bytes.
	// Example: 1024000000
	MemoryUsed *int64 `json:"memory_used,omitempty"`

	// Base counter for GPU utilization.
	// Example: 35042835393
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw GPU utilization for the node. Divide this by the processor_utilization_base to calculate the percentage GPU utilization for the node.
	// Example: 2514992973
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`
}

// Validate validates this dcn node statistics inline gpu
func (m *DcnNodeStatisticsInlineGpu) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this dcn node statistics inline gpu based on context it is used
func (m *DcnNodeStatisticsInlineGpu) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DcnNodeStatisticsInlineGpu) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnNodeStatisticsInlineGpu) UnmarshalBinary(b []byte) error {
	var res DcnNodeStatisticsInlineGpu
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
