// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnServiceProcessor The service processor information of the data compute node.
//
// swagger:model dcn_service_processor
type DcnServiceProcessor struct {

	// Indicates whether the service processor can be automatically updated from ONTAP.
	AutoupdateEnabled *bool `json:"autoupdate_enabled,omitempty"`

	// Set to "true" to use DHCP to configure an IPv4 interface. Do not provide values for address, netmask and gateway when set to "true".
	DhcpEnabled *bool `json:"dhcp_enabled,omitempty"`

	// The version of firmware installed.
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// ipv4 interface
	IPV4Interface *DcnServiceProcessorInlineIPV4Interface `json:"ipv4_interface,omitempty"`

	// ipv6 interface
	IPV6Interface *DcnServiceProcessorInlineIPV6Interface `json:"ipv6_interface,omitempty"`

	// Indicates whether the service processor network is configured.
	// Read Only: true
	IsIPConfigured *bool `json:"is_ip_configured,omitempty"`

	// Provides the "update status" of the last service processor update.
	// Read Only: true
	// Enum: ["failed","passed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// link state
	// Read Only: true
	// Enum: ["up","down","disabled","unknown"]
	LinkState *string `json:"link_state,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// state
	// Read Only: true
	// Enum: ["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]
	State *string `json:"state,omitempty"`
}

// Validate validates this dcn service processor
func (m *DcnServiceProcessor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnServiceProcessor) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *DcnServiceProcessor) validateIPV6Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6Interface) { // not required
		return nil
	}

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv6_interface")
			}
			return err
		}
	}

	return nil
}

var dcnServiceProcessorTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","passed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnServiceProcessorTypeLastUpdateStatePropEnum = append(dcnServiceProcessorTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// DcnServiceProcessorLastUpdateStateFailed captures enum value "failed"
	DcnServiceProcessorLastUpdateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// DcnServiceProcessorLastUpdateStatePassed captures enum value "passed"
	DcnServiceProcessorLastUpdateStatePassed string = "passed"
)

// prop value enum
func (m *DcnServiceProcessor) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnServiceProcessorTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnServiceProcessor) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

var dcnServiceProcessorTypeLinkStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnServiceProcessorTypeLinkStatePropEnum = append(dcnServiceProcessorTypeLinkStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// link_state
	// LinkState
	// up
	// END DEBUGGING
	// DcnServiceProcessorLinkStateUp captures enum value "up"
	DcnServiceProcessorLinkStateUp string = "up"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// link_state
	// LinkState
	// down
	// END DEBUGGING
	// DcnServiceProcessorLinkStateDown captures enum value "down"
	DcnServiceProcessorLinkStateDown string = "down"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// link_state
	// LinkState
	// disabled
	// END DEBUGGING
	// DcnServiceProcessorLinkStateDisabled captures enum value "disabled"
	DcnServiceProcessorLinkStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// link_state
	// LinkState
	// unknown
	// END DEBUGGING
	// DcnServiceProcessorLinkStateUnknown captures enum value "unknown"
	DcnServiceProcessorLinkStateUnknown string = "unknown"
)

// prop value enum
func (m *DcnServiceProcessor) validateLinkStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnServiceProcessorTypeLinkStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnServiceProcessor) validateLinkState(formats strfmt.Registry) error {
	if swag.IsZero(m.LinkState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkStateEnum("link_state", "body", *m.LinkState); err != nil {
		return err
	}

	return nil
}

var dcnServiceProcessorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnServiceProcessorTypeStatePropEnum = append(dcnServiceProcessorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// online
	// END DEBUGGING
	// DcnServiceProcessorStateOnline captures enum value "online"
	DcnServiceProcessorStateOnline string = "online"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// offline
	// END DEBUGGING
	// DcnServiceProcessorStateOffline captures enum value "offline"
	DcnServiceProcessorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// degraded
	// END DEBUGGING
	// DcnServiceProcessorStateDegraded captures enum value "degraded"
	DcnServiceProcessorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// rebooting
	// END DEBUGGING
	// DcnServiceProcessorStateRebooting captures enum value "rebooting"
	DcnServiceProcessorStateRebooting string = "rebooting"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// unknown
	// END DEBUGGING
	// DcnServiceProcessorStateUnknown captures enum value "unknown"
	DcnServiceProcessorStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// updating
	// END DEBUGGING
	// DcnServiceProcessorStateUpdating captures enum value "updating"
	DcnServiceProcessorStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// node_offline
	// END DEBUGGING
	// DcnServiceProcessorStateNodeOffline captures enum value "node_offline"
	DcnServiceProcessorStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// dcn_service_processor
	// DcnServiceProcessor
	// state
	// State
	// sp_daemon_offline
	// END DEBUGGING
	// DcnServiceProcessorStateSpDaemonOffline captures enum value "sp_daemon_offline"
	DcnServiceProcessorStateSpDaemonOffline string = "sp_daemon_offline"
)

// prop value enum
func (m *DcnServiceProcessor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnServiceProcessorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnServiceProcessor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn service processor based on the context it is used
func (m *DcnServiceProcessor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsIPConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLinkState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnServiceProcessor) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateIPV6Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipv6_interface")
			}
			return err
		}
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateIsIPConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_ip_configured", "body", m.IsIPConfigured); err != nil {
		return err
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateLinkState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "link_state", "body", m.LinkState); err != nil {
		return err
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *DcnServiceProcessor) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnServiceProcessor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnServiceProcessor) UnmarshalBinary(b []byte) error {
	var res DcnServiceProcessor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnServiceProcessorInlineIPV4Interface Object to set up an interface along with its default router.
//
// swagger:model dcn_service_processor_inline_ipv4_interface
type DcnServiceProcessorInlineIPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this dcn service processor inline ipv4 interface
func (m *DcnServiceProcessorInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dcnServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum = append(dcnServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv4_interface
	// DcnServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	DcnServiceProcessorInlineIPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv4_interface
	// DcnServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	DcnServiceProcessorInlineIPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv4_interface
	// DcnServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	DcnServiceProcessorInlineIPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv4_interface
	// DcnServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV4InterfaceSetupStateFailed captures enum value "failed"
	DcnServiceProcessorInlineIPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *DcnServiceProcessorInlineIPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnServiceProcessorInlineIPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("ipv4_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn service processor inline ipv4 interface based on the context it is used
func (m *DcnServiceProcessorInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnServiceProcessorInlineIPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ipv4_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnServiceProcessorInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnServiceProcessorInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res DcnServiceProcessorInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DcnServiceProcessorInlineIPV6Interface Object to setup an interface along with its default router.
//
// swagger:model dcn_service_processor_inline_ipv6_interface
type DcnServiceProcessorInlineIPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this dcn service processor inline ipv6 interface
func (m *DcnServiceProcessorInlineIPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dcnServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dcnServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum = append(dcnServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv6_interface
	// DcnServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	DcnServiceProcessorInlineIPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv6_interface
	// DcnServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	DcnServiceProcessorInlineIPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv6_interface
	// DcnServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	DcnServiceProcessorInlineIPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// dcn_service_processor_inline_ipv6_interface
	// DcnServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// DcnServiceProcessorInlineIPV6InterfaceSetupStateFailed captures enum value "failed"
	DcnServiceProcessorInlineIPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *DcnServiceProcessorInlineIPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dcnServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DcnServiceProcessorInlineIPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("ipv6_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this dcn service processor inline ipv6 interface based on the context it is used
func (m *DcnServiceProcessorInlineIPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnServiceProcessorInlineIPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ipv6_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnServiceProcessorInlineIPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnServiceProcessorInlineIPV6Interface) UnmarshalBinary(b []byte) error {
	var res DcnServiceProcessorInlineIPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
