// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DcnVersion This contains DCN version information.
//
// swagger:model dcn_version
type DcnVersion struct {

	// The full version string.
	// Example: DCN Release PLACEHOLDER: Wed Jun 04 18:20:57 UTC 2025
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`

	// The patch portion of the version.
	// Example: P2
	// Read Only: true
	Patch *string `json:"patch,omitempty"`
}

// Validate validates this dcn version
func (m *DcnVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this dcn version based on the context it is used
func (m *DcnVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePatch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DcnVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *DcnVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *DcnVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *DcnVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

func (m *DcnVersion) contextValidatePatch(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "patch", "body", m.Patch); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DcnVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DcnVersion) UnmarshalBinary(b []byte) error {
	var res DcnVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
