// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceDiscoveryData device discovery data
//
// swagger:model device_discovery_data
type DeviceDiscoveryData struct {

	// The list of the capabilities of the discovered device.
	// Example: ["router","switch"]
	Capabilities []*string `json:"capabilities,omitempty"`

	// Identifier associated with this specific discovered device, useful for locating the device in a data center.
	ChassisID *string `json:"chassis_id,omitempty"`

	// The IP addresses on the discovered device.
	// Example: ["192.168.100.24","192.168.100.26"]
	DeviceDiscoveryDataInlineIPAddresses []*IPAddressReadonly `json:"ip_addresses,omitempty"`

	// Name of the discovered device.
	// Example: ETY-R1S4-510Q13.datacenter.example.com
	Name *string `json:"name,omitempty"`

	// Hardware platform of the discovered device.
	// Example: 93180YC-EX
	Platform *string `json:"platform,omitempty"`

	// The protocol used to identify the discovered device. This can have a value of CDP or LLDP.
	// Example: cdp
	// Enum: ["cdp","lldp"]
	Protocol *string `json:"protocol,omitempty"`

	// The number of seconds until the discovered device entry expires and is removed.
	RemainingHoldTime *int64 `json:"remaining_hold_time,omitempty"`

	// The name of the remote port on the discovered device. The format is dependent on the reporting device.
	// Example: FastEthernet0/12
	RemotePort *string `json:"remote_port,omitempty"`

	// Additional name used to identify a specific piece of equipment.
	SystemName *string `json:"system_name,omitempty"`

	// The version of the software running on the discovered device.
	// Example: Cisco Nexus Operating System (NX-OS) Software, Version 8.1
	Version *string `json:"version,omitempty"`
}

// Validate validates this device discovery data
func (m *DeviceDiscoveryData) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeviceDiscoveryDataInlineIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var deviceDiscoveryDataCapabilitiesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["router","transparent_bridge","source_route_bridge","switch","host","igmp","repeater","phone"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceDiscoveryDataCapabilitiesItemsEnum = append(deviceDiscoveryDataCapabilitiesItemsEnum, v)
	}
}

func (m *DeviceDiscoveryData) validateCapabilitiesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceDiscoveryDataCapabilitiesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceDiscoveryData) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(m.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(m.Capabilities); i++ {
		if swag.IsZero(m.Capabilities[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateCapabilitiesItemsEnum("capabilities"+"."+strconv.Itoa(i), "body", *m.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DeviceDiscoveryData) validateDeviceDiscoveryDataInlineIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.DeviceDiscoveryDataInlineIPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.DeviceDiscoveryDataInlineIPAddresses); i++ {
		if swag.IsZero(m.DeviceDiscoveryDataInlineIPAddresses[i]) { // not required
			continue
		}

		if m.DeviceDiscoveryDataInlineIPAddresses[i] != nil {
			if err := m.DeviceDiscoveryDataInlineIPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var deviceDiscoveryDataTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cdp","lldp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceDiscoveryDataTypeProtocolPropEnum = append(deviceDiscoveryDataTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// device_discovery_data
	// DeviceDiscoveryData
	// protocol
	// Protocol
	// cdp
	// END DEBUGGING
	// DeviceDiscoveryDataProtocolCdp captures enum value "cdp"
	DeviceDiscoveryDataProtocolCdp string = "cdp"

	// BEGIN DEBUGGING
	// device_discovery_data
	// DeviceDiscoveryData
	// protocol
	// Protocol
	// lldp
	// END DEBUGGING
	// DeviceDiscoveryDataProtocolLldp captures enum value "lldp"
	DeviceDiscoveryDataProtocolLldp string = "lldp"
)

// prop value enum
func (m *DeviceDiscoveryData) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceDiscoveryDataTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceDiscoveryData) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this device discovery data based on the context it is used
func (m *DeviceDiscoveryData) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDeviceDiscoveryDataInlineIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceDiscoveryData) contextValidateDeviceDiscoveryDataInlineIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DeviceDiscoveryDataInlineIPAddresses); i++ {

		if m.DeviceDiscoveryDataInlineIPAddresses[i] != nil {
			if err := m.DeviceDiscoveryDataInlineIPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceDiscoveryData) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceDiscoveryData) UnmarshalBinary(b []byte) error {
	var res DeviceDiscoveryData
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
