// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Disk disk
//
// swagger:model disk
type Disk struct {

	// Disk shelf bay
	// Example: 1
	// Read Only: true
	Bay *int64 `json:"bay,omitempty"`

	// Bytes per sector.
	// Example: 520
	// Read Only: true
	BytesPerSector *int64 `json:"bytes_per_sector,omitempty"`

	// Disk class
	// Example: solid_state
	// Read Only: true
	// Enum: ["unknown","capacity","performance","archive","solid_state","array","virtual"]
	Class *string `json:"class,omitempty"`

	// Security standard that the device is certified to.
	// Example: FIPS 140-2
	// Read Only: true
	ComplianceStandard *string `json:"compliance_standard,omitempty"`

	// Type of overlying disk container
	// Example: spare
	// Read Only: true
	// Enum: ["aggregate","broken","foreign","labelmaint","maintenance","shared","spare","unassigned","unknown","unsupported","remote","mediator"]
	ContainerType *string `json:"container_type,omitempty"`

	// Standard that the device supports for encryption control.
	// Example: TCG Enterprise
	// Read Only: true
	ControlStandard *string `json:"control_standard,omitempty"`

	// List of aggregates sharing this disk
	// Read Only: true
	DiskInlineAggregates []*DiskInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// List of disk errors information.
	// Read Only: true
	DiskInlineError []*DiskErrorInfo `json:"error,omitempty"`

	// List of paths to a disk
	// Read Only: true
	DiskInlinePaths []*DiskPathInfo `json:"paths,omitempty"`

	// dr node
	DrNode *DiskInlineDrNode `json:"dr_node,omitempty"`

	// drawer
	Drawer *DiskInlineDrawer `json:"drawer,omitempty"`

	// Effective Disk type
	// Example: vmdisk
	// Read Only: true
	// Enum: ["ata","fcal","lun","msata","sas","bsas","ssd","ssd_nvm","ssd_zns","ssd_cap","fsas","vmdisk","unknown"]
	EffectiveType *string `json:"effective_type,omitempty"`

	// This field should only be set as a query parameter in a PATCH operation. It is input only and won't be returned by a subsequent GET.
	//
	EncryptionOperation *string `json:"encryption_operation,omitempty"`

	// fips certified
	// Read Only: true
	FipsCertified *bool `json:"fips_certified,omitempty"`

	// firmware version
	// Example: NA51
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// home node
	HomeNode *DiskInlineHomeNode `json:"home_node,omitempty"`

	// key id
	KeyID *DiskInlineKeyID `json:"key_id,omitempty"`

	// Indicates if a disk is locally attached versus being remotely attached.
	// A locally attached disk resides in the same proximity as the host
	// cluster versus been attached to the remote cluster.
	//
	// Read Only: true
	Local *bool `json:"local,omitempty"`

	// Physical location of the disk
	// Example: node-01
	// Read Only: true
	Location *string `json:"location,omitempty"`

	// model
	// Example: X421_HCOBE450A10
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// Cluster-wide disk name
	// Example: 1.0.1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *DiskInlineNode `json:"node,omitempty"`

	// outage
	Outage *DiskInlineOutage `json:"outage,omitempty"`

	// Overall Security rating, for FIPS-certified devices.
	// Example: Level 2
	// Read Only: true
	OverallSecurity *string `json:"overall_security,omitempty"`

	// Physical size, in units of bytes
	// Example: 228930
	// Read Only: true
	PhysicalSize *int64 `json:"physical_size,omitempty"`

	// Pool to which disk is assigned
	// Example: pool0
	// Enum: ["pool0","pool1","failed","none"]
	Pool *string `json:"pool,omitempty"`

	// Mode of drive data protection and FIPS compliance. Possible values are:
	// - _open_ - Data is unprotected
	// - _data_ - Data protection only, without FIPS compliance
	// - _part_ - Data is unprotected; other FIPS compliance settings present
	// - _full_ - Full data and FIPS compliance protection
	// - _miss_ - Protection mode information is not available
	//
	// Example: data
	// Read Only: true
	// Enum: ["open","data","part","full","miss"]
	ProtectionMode *string `json:"protection_mode,omitempty"`

	// Percentage of rated life used
	// Example: 10
	// Read Only: true
	RatedLifeUsedPercent *int64 `json:"rated_life_used_percent,omitempty"`

	// Number of usable disk sectors that remain after subtracting the right-size adjustment for this disk.
	// Example: 1172123568
	// Read Only: true
	RightSizeSectorCount *int64 `json:"right_size_sector_count,omitempty"`

	// Revolutions per minute
	// Example: 15000
	// Read Only: true
	Rpm *int64 `json:"rpm,omitempty"`

	// Confirms spare disk sanitization (non-cryptographically).
	SanitizeSpare *bool `json:"sanitize_spare,omitempty"`

	// Number of sectors on the disk.
	// Example: 1172123568
	// Read Only: true
	SectorCount *int64 `json:"sector_count,omitempty"`

	// self encrypting
	// Read Only: true
	SelfEncrypting *bool `json:"self_encrypting,omitempty"`

	// serial number
	// Example: KHG2VX8R
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// shelf
	Shelf *DiskInlineShelf `json:"shelf,omitempty"`

	// State
	// Example: present
	// Enum: ["broken","copy","maintenance","partner","pending","present","reconstructing","removed","spare","unfail","zeroing"]
	State *string `json:"state,omitempty"`

	// stats
	Stats *DiskInlineStats `json:"stats,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *DiskInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// storage pool
	StoragePool *DiskInlineStoragePool `json:"storage_pool,omitempty"`

	// Disk interface type
	// Example: ssd
	// Read Only: true
	// Enum: ["ata","bsas","fcal","fsas","lun","sas","msata","ssd","vmdisk","unknown","ssd_cap","ssd_nvm","ssd_zns"]
	Type *string `json:"type,omitempty"`

	// The unique identifier for a disk
	// Example: 002538E5:71B00B2F:00000000:00000000:00000000:00000000:00000000:00000000:00000000:00000000
	// Read Only: true
	UID *string `json:"uid,omitempty"`

	// usable size
	// Example: 959934889984
	// Read Only: true
	UsableSize *int64 `json:"usable_size,omitempty"`

	// vendor
	// Example: NETAPP
	// Read Only: true
	Vendor *string `json:"vendor,omitempty"`

	// virtual
	Virtual *DiskInlineVirtual `json:"virtual,omitempty"`
}

// Validate validates this disk
func (m *Disk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContainerType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskInlineError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskInlinePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDrNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDrawer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEffectiveType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOutage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShelf(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVirtual(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var diskTypeClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","capacity","performance","archive","solid_state","array","virtual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeClassPropEnum = append(diskTypeClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// unknown
	// END DEBUGGING
	// DiskClassUnknown captures enum value "unknown"
	DiskClassUnknown string = "unknown"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// capacity
	// END DEBUGGING
	// DiskClassCapacity captures enum value "capacity"
	DiskClassCapacity string = "capacity"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// performance
	// END DEBUGGING
	// DiskClassPerformance captures enum value "performance"
	DiskClassPerformance string = "performance"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// archive
	// END DEBUGGING
	// DiskClassArchive captures enum value "archive"
	DiskClassArchive string = "archive"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// solid_state
	// END DEBUGGING
	// DiskClassSolidState captures enum value "solid_state"
	DiskClassSolidState string = "solid_state"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// array
	// END DEBUGGING
	// DiskClassArray captures enum value "array"
	DiskClassArray string = "array"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// class
	// Class
	// virtual
	// END DEBUGGING
	// DiskClassVirtual captures enum value "virtual"
	DiskClassVirtual string = "virtual"
)

// prop value enum
func (m *Disk) validateClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateClass(formats strfmt.Registry) error {
	if swag.IsZero(m.Class) { // not required
		return nil
	}

	// value enum
	if err := m.validateClassEnum("class", "body", *m.Class); err != nil {
		return err
	}

	return nil
}

var diskTypeContainerTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aggregate","broken","foreign","labelmaint","maintenance","shared","spare","unassigned","unknown","unsupported","remote","mediator"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeContainerTypePropEnum = append(diskTypeContainerTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// aggregate
	// END DEBUGGING
	// DiskContainerTypeAggregate captures enum value "aggregate"
	DiskContainerTypeAggregate string = "aggregate"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// broken
	// END DEBUGGING
	// DiskContainerTypeBroken captures enum value "broken"
	DiskContainerTypeBroken string = "broken"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// foreign
	// END DEBUGGING
	// DiskContainerTypeForeign captures enum value "foreign"
	DiskContainerTypeForeign string = "foreign"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// labelmaint
	// END DEBUGGING
	// DiskContainerTypeLabelmaint captures enum value "labelmaint"
	DiskContainerTypeLabelmaint string = "labelmaint"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// maintenance
	// END DEBUGGING
	// DiskContainerTypeMaintenance captures enum value "maintenance"
	DiskContainerTypeMaintenance string = "maintenance"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// shared
	// END DEBUGGING
	// DiskContainerTypeShared captures enum value "shared"
	DiskContainerTypeShared string = "shared"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// spare
	// END DEBUGGING
	// DiskContainerTypeSpare captures enum value "spare"
	DiskContainerTypeSpare string = "spare"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// unassigned
	// END DEBUGGING
	// DiskContainerTypeUnassigned captures enum value "unassigned"
	DiskContainerTypeUnassigned string = "unassigned"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// unknown
	// END DEBUGGING
	// DiskContainerTypeUnknown captures enum value "unknown"
	DiskContainerTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// unsupported
	// END DEBUGGING
	// DiskContainerTypeUnsupported captures enum value "unsupported"
	DiskContainerTypeUnsupported string = "unsupported"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// remote
	// END DEBUGGING
	// DiskContainerTypeRemote captures enum value "remote"
	DiskContainerTypeRemote string = "remote"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// container_type
	// ContainerType
	// mediator
	// END DEBUGGING
	// DiskContainerTypeMediator captures enum value "mediator"
	DiskContainerTypeMediator string = "mediator"
)

// prop value enum
func (m *Disk) validateContainerTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeContainerTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateContainerType(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerType) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerTypeEnum("container_type", "body", *m.ContainerType); err != nil {
		return err
	}

	return nil
}

func (m *Disk) validateDiskInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.DiskInlineAggregates); i++ {
		if swag.IsZero(m.DiskInlineAggregates[i]) { // not required
			continue
		}

		if m.DiskInlineAggregates[i] != nil {
			if err := m.DiskInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) validateDiskInlineError(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskInlineError) { // not required
		return nil
	}

	for i := 0; i < len(m.DiskInlineError); i++ {
		if swag.IsZero(m.DiskInlineError[i]) { // not required
			continue
		}

		if m.DiskInlineError[i] != nil {
			if err := m.DiskInlineError[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) validateDiskInlinePaths(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskInlinePaths) { // not required
		return nil
	}

	for i := 0; i < len(m.DiskInlinePaths); i++ {
		if swag.IsZero(m.DiskInlinePaths[i]) { // not required
			continue
		}

		if m.DiskInlinePaths[i] != nil {
			if err := m.DiskInlinePaths[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) validateDrNode(formats strfmt.Registry) error {
	if swag.IsZero(m.DrNode) { // not required
		return nil
	}

	if m.DrNode != nil {
		if err := m.DrNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateDrawer(formats strfmt.Registry) error {
	if swag.IsZero(m.Drawer) { // not required
		return nil
	}

	if m.Drawer != nil {
		if err := m.Drawer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

var diskTypeEffectiveTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ata","fcal","lun","msata","sas","bsas","ssd","ssd_nvm","ssd_zns","ssd_cap","fsas","vmdisk","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeEffectiveTypePropEnum = append(diskTypeEffectiveTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// ata
	// END DEBUGGING
	// DiskEffectiveTypeAta captures enum value "ata"
	DiskEffectiveTypeAta string = "ata"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// fcal
	// END DEBUGGING
	// DiskEffectiveTypeFcal captures enum value "fcal"
	DiskEffectiveTypeFcal string = "fcal"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// lun
	// END DEBUGGING
	// DiskEffectiveTypeLun captures enum value "lun"
	DiskEffectiveTypeLun string = "lun"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// msata
	// END DEBUGGING
	// DiskEffectiveTypeMsata captures enum value "msata"
	DiskEffectiveTypeMsata string = "msata"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// sas
	// END DEBUGGING
	// DiskEffectiveTypeSas captures enum value "sas"
	DiskEffectiveTypeSas string = "sas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// bsas
	// END DEBUGGING
	// DiskEffectiveTypeBsas captures enum value "bsas"
	DiskEffectiveTypeBsas string = "bsas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// ssd
	// END DEBUGGING
	// DiskEffectiveTypeSsd captures enum value "ssd"
	DiskEffectiveTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// ssd_nvm
	// END DEBUGGING
	// DiskEffectiveTypeSsdNvm captures enum value "ssd_nvm"
	DiskEffectiveTypeSsdNvm string = "ssd_nvm"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// ssd_zns
	// END DEBUGGING
	// DiskEffectiveTypeSsdZns captures enum value "ssd_zns"
	DiskEffectiveTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// ssd_cap
	// END DEBUGGING
	// DiskEffectiveTypeSsdCap captures enum value "ssd_cap"
	DiskEffectiveTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// fsas
	// END DEBUGGING
	// DiskEffectiveTypeFsas captures enum value "fsas"
	DiskEffectiveTypeFsas string = "fsas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// vmdisk
	// END DEBUGGING
	// DiskEffectiveTypeVmdisk captures enum value "vmdisk"
	DiskEffectiveTypeVmdisk string = "vmdisk"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// effective_type
	// EffectiveType
	// unknown
	// END DEBUGGING
	// DiskEffectiveTypeUnknown captures enum value "unknown"
	DiskEffectiveTypeUnknown string = "unknown"
)

// prop value enum
func (m *Disk) validateEffectiveTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeEffectiveTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateEffectiveType(formats strfmt.Registry) error {
	if swag.IsZero(m.EffectiveType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEffectiveTypeEnum("effective_type", "body", *m.EffectiveType); err != nil {
		return err
	}

	return nil
}

func (m *Disk) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(m.HomeNode) { // not required
		return nil
	}

	if m.HomeNode != nil {
		if err := m.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateKeyID(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyID) { // not required
		return nil
	}

	if m.KeyID != nil {
		if err := m.KeyID.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("key_id")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateOutage(formats strfmt.Registry) error {
	if swag.IsZero(m.Outage) { // not required
		return nil
	}

	if m.Outage != nil {
		if err := m.Outage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("outage")
			}
			return err
		}
	}

	return nil
}

var diskTypePoolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pool0","pool1","failed","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypePoolPropEnum = append(diskTypePoolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// pool
	// Pool
	// pool0
	// END DEBUGGING
	// DiskPoolPool0 captures enum value "pool0"
	DiskPoolPool0 string = "pool0"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// pool
	// Pool
	// pool1
	// END DEBUGGING
	// DiskPoolPool1 captures enum value "pool1"
	DiskPoolPool1 string = "pool1"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// pool
	// Pool
	// failed
	// END DEBUGGING
	// DiskPoolFailed captures enum value "failed"
	DiskPoolFailed string = "failed"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// pool
	// Pool
	// none
	// END DEBUGGING
	// DiskPoolNone captures enum value "none"
	DiskPoolNone string = "none"
)

// prop value enum
func (m *Disk) validatePoolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypePoolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validatePool(formats strfmt.Registry) error {
	if swag.IsZero(m.Pool) { // not required
		return nil
	}

	// value enum
	if err := m.validatePoolEnum("pool", "body", *m.Pool); err != nil {
		return err
	}

	return nil
}

var diskTypeProtectionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["open","data","part","full","miss"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeProtectionModePropEnum = append(diskTypeProtectionModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// protection_mode
	// ProtectionMode
	// open
	// END DEBUGGING
	// DiskProtectionModeOpen captures enum value "open"
	DiskProtectionModeOpen string = "open"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// protection_mode
	// ProtectionMode
	// data
	// END DEBUGGING
	// DiskProtectionModeData captures enum value "data"
	DiskProtectionModeData string = "data"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// protection_mode
	// ProtectionMode
	// part
	// END DEBUGGING
	// DiskProtectionModePart captures enum value "part"
	DiskProtectionModePart string = "part"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// protection_mode
	// ProtectionMode
	// full
	// END DEBUGGING
	// DiskProtectionModeFull captures enum value "full"
	DiskProtectionModeFull string = "full"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// protection_mode
	// ProtectionMode
	// miss
	// END DEBUGGING
	// DiskProtectionModeMiss captures enum value "miss"
	DiskProtectionModeMiss string = "miss"
)

// prop value enum
func (m *Disk) validateProtectionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeProtectionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateProtectionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtectionModeEnum("protection_mode", "body", *m.ProtectionMode); err != nil {
		return err
	}

	return nil
}

func (m *Disk) validateShelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Shelf) { // not required
		return nil
	}

	if m.Shelf != nil {
		if err := m.Shelf.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf")
			}
			return err
		}
	}

	return nil
}

var diskTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["broken","copy","maintenance","partner","pending","present","reconstructing","removed","spare","unfail","zeroing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeStatePropEnum = append(diskTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// broken
	// END DEBUGGING
	// DiskStateBroken captures enum value "broken"
	DiskStateBroken string = "broken"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// copy
	// END DEBUGGING
	// DiskStateCopy captures enum value "copy"
	DiskStateCopy string = "copy"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// maintenance
	// END DEBUGGING
	// DiskStateMaintenance captures enum value "maintenance"
	DiskStateMaintenance string = "maintenance"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// partner
	// END DEBUGGING
	// DiskStatePartner captures enum value "partner"
	DiskStatePartner string = "partner"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// pending
	// END DEBUGGING
	// DiskStatePending captures enum value "pending"
	DiskStatePending string = "pending"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// present
	// END DEBUGGING
	// DiskStatePresent captures enum value "present"
	DiskStatePresent string = "present"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// reconstructing
	// END DEBUGGING
	// DiskStateReconstructing captures enum value "reconstructing"
	DiskStateReconstructing string = "reconstructing"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// removed
	// END DEBUGGING
	// DiskStateRemoved captures enum value "removed"
	DiskStateRemoved string = "removed"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// spare
	// END DEBUGGING
	// DiskStateSpare captures enum value "spare"
	DiskStateSpare string = "spare"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// unfail
	// END DEBUGGING
	// DiskStateUnfail captures enum value "unfail"
	DiskStateUnfail string = "unfail"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// state
	// State
	// zeroing
	// END DEBUGGING
	// DiskStateZeroing captures enum value "zeroing"
	DiskStateZeroing string = "zeroing"
)

// prop value enum
func (m *Disk) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Disk) validateStats(formats strfmt.Registry) error {
	if swag.IsZero(m.Stats) { // not required
		return nil
	}

	if m.Stats != nil {
		if err := m.Stats.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) validateStoragePool(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePool) { // not required
		return nil
	}

	if m.StoragePool != nil {
		if err := m.StoragePool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

var diskTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ata","bsas","fcal","fsas","lun","sas","msata","ssd","vmdisk","unknown","ssd_cap","ssd_nvm","ssd_zns"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskTypeTypePropEnum = append(diskTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// ata
	// END DEBUGGING
	// DiskTypeAta captures enum value "ata"
	DiskTypeAta string = "ata"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// bsas
	// END DEBUGGING
	// DiskTypeBsas captures enum value "bsas"
	DiskTypeBsas string = "bsas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// fcal
	// END DEBUGGING
	// DiskTypeFcal captures enum value "fcal"
	DiskTypeFcal string = "fcal"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// fsas
	// END DEBUGGING
	// DiskTypeFsas captures enum value "fsas"
	DiskTypeFsas string = "fsas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// lun
	// END DEBUGGING
	// DiskTypeLun captures enum value "lun"
	DiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// sas
	// END DEBUGGING
	// DiskTypeSas captures enum value "sas"
	DiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// msata
	// END DEBUGGING
	// DiskTypeMsata captures enum value "msata"
	DiskTypeMsata string = "msata"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// ssd
	// END DEBUGGING
	// DiskTypeSsd captures enum value "ssd"
	DiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// vmdisk
	// END DEBUGGING
	// DiskTypeVmdisk captures enum value "vmdisk"
	DiskTypeVmdisk string = "vmdisk"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// unknown
	// END DEBUGGING
	// DiskTypeUnknown captures enum value "unknown"
	DiskTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// ssd_cap
	// END DEBUGGING
	// DiskTypeSsdCap captures enum value "ssd_cap"
	DiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// ssd_nvm
	// END DEBUGGING
	// DiskTypeSsdNvm captures enum value "ssd_nvm"
	DiskTypeSsdNvm string = "ssd_nvm"

	// BEGIN DEBUGGING
	// disk
	// Disk
	// type
	// Type
	// ssd_zns
	// END DEBUGGING
	// DiskTypeSsdZns captures enum value "ssd_zns"
	DiskTypeSsdZns string = "ssd_zns"
)

// prop value enum
func (m *Disk) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Disk) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Disk) validateVirtual(formats strfmt.Registry) error {
	if swag.IsZero(m.Virtual) { // not required
		return nil
	}

	if m.Virtual != nil {
		if err := m.Virtual.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("virtual")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk based on the context it is used
func (m *Disk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBay(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBytesPerSector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateComplianceStandard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContainerType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateControlStandard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskInlineError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDiskInlinePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDrNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDrawer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEffectiveType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFipsCertified(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOutage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverallSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatedLifeUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRightSizeSectorCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRpm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSectorCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelfEncrypting(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStats(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVirtual(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Disk) contextValidateBay(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bay", "body", m.Bay); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateBytesPerSector(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bytes_per_sector", "body", m.BytesPerSector); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "class", "body", m.Class); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateComplianceStandard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compliance_standard", "body", m.ComplianceStandard); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateContainerType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "container_type", "body", m.ContainerType); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateControlStandard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "control_standard", "body", m.ControlStandard); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateDiskInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregates", "body", []*DiskInlineAggregatesInlineArrayItem(m.DiskInlineAggregates)); err != nil {
		return err
	}

	for i := 0; i < len(m.DiskInlineAggregates); i++ {

		if m.DiskInlineAggregates[i] != nil {
			if err := m.DiskInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) contextValidateDiskInlineError(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error", "body", []*DiskErrorInfo(m.DiskInlineError)); err != nil {
		return err
	}

	for i := 0; i < len(m.DiskInlineError); i++ {

		if m.DiskInlineError[i] != nil {
			if err := m.DiskInlineError[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) contextValidateDiskInlinePaths(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "paths", "body", []*DiskPathInfo(m.DiskInlinePaths)); err != nil {
		return err
	}

	for i := 0; i < len(m.DiskInlinePaths); i++ {

		if m.DiskInlinePaths[i] != nil {
			if err := m.DiskInlinePaths[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("paths" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Disk) contextValidateDrNode(ctx context.Context, formats strfmt.Registry) error {

	if m.DrNode != nil {
		if err := m.DrNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateDrawer(ctx context.Context, formats strfmt.Registry) error {

	if m.Drawer != nil {
		if err := m.Drawer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("drawer")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateEffectiveType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "effective_type", "body", m.EffectiveType); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateFipsCertified(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fips_certified", "body", m.FipsCertified); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if m.HomeNode != nil {
		if err := m.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateKeyID(ctx context.Context, formats strfmt.Registry) error {

	if m.KeyID != nil {
		if err := m.KeyID.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("key_id")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local", "body", m.Local); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "location", "body", m.Location); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateOutage(ctx context.Context, formats strfmt.Registry) error {

	if m.Outage != nil {
		if err := m.Outage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("outage")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateOverallSecurity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "overall_security", "body", m.OverallSecurity); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidatePhysicalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "physical_size", "body", m.PhysicalSize); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateProtectionMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_mode", "body", m.ProtectionMode); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateRatedLifeUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rated_life_used_percent", "body", m.RatedLifeUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateRightSizeSectorCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "right_size_sector_count", "body", m.RightSizeSectorCount); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateRpm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpm", "body", m.Rpm); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateSectorCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sector_count", "body", m.SectorCount); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateSelfEncrypting(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "self_encrypting", "body", m.SelfEncrypting); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateShelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Shelf != nil {
		if err := m.Shelf.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateStats(ctx context.Context, formats strfmt.Registry) error {

	if m.Stats != nil {
		if err := m.Stats.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if m.StoragePool != nil {
		if err := m.StoragePool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

func (m *Disk) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uid", "body", m.UID); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateUsableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "usable_size", "body", m.UsableSize); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateVendor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vendor", "body", m.Vendor); err != nil {
		return err
	}

	return nil
}

func (m *Disk) contextValidateVirtual(ctx context.Context, formats strfmt.Registry) error {

	if m.Virtual != nil {
		if err := m.Virtual.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("virtual")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Disk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Disk) UnmarshalBinary(b []byte) error {
	var res Disk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineAggregatesInlineArrayItem Aggregate
//
// swagger:model disk_inline_aggregates_inline_array_item
type DiskInlineAggregatesInlineArrayItem struct {

	// links
	Links *DiskInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline aggregates inline array item
func (m *DiskInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline aggregates inline array item based on the context it is used
func (m *DiskInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DiskInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineAggregatesInlineArrayItemInlineLinks disk inline aggregates inline array item inline links
//
// swagger:model disk_inline_aggregates_inline_array_item_inline__links
type DiskInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline aggregates inline array item inline links
func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline aggregates inline array item inline links based on the context it is used
func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineDrNode disk inline dr node
//
// swagger:model disk_inline_dr_node
type DiskInlineDrNode struct {

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline dr node
func (m *DiskInlineDrNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this disk inline dr node based on the context it is used
func (m *DiskInlineDrNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineDrNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineDrNode) UnmarshalBinary(b []byte) error {
	var res DiskInlineDrNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineDrawer disk inline drawer
//
// swagger:model disk_inline_drawer
type DiskInlineDrawer struct {

	// id
	ID *int64 `json:"id,omitempty"`

	// slot
	Slot *int64 `json:"slot,omitempty"`
}

// Validate validates this disk inline drawer
func (m *DiskInlineDrawer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this disk inline drawer based on the context it is used
func (m *DiskInlineDrawer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineDrawer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineDrawer) UnmarshalBinary(b []byte) error {
	var res DiskInlineDrawer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineHomeNode disk inline home node
//
// swagger:model disk_inline_home_node
type DiskInlineHomeNode struct {

	// links
	Links *DiskInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline home node
func (m *DiskInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline home node based on the context it is used
func (m *DiskInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineHomeNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res DiskInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineHomeNodeInlineLinks disk inline home node inline links
//
// swagger:model disk_inline_home_node_inline__links
type DiskInlineHomeNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline home node inline links
func (m *DiskInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline home node inline links based on the context it is used
func (m *DiskInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineKeyID disk inline key id
//
// swagger:model disk_inline_key_id
type DiskInlineKeyID struct {

	// Key ID of the data authentication key
	Data *string `json:"data,omitempty"`

	// Key ID of the FIPS authentication key
	Fips *string `json:"fips,omitempty"`
}

// Validate validates this disk inline key id
func (m *DiskInlineKeyID) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this disk inline key id based on the context it is used
func (m *DiskInlineKeyID) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineKeyID) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineKeyID) UnmarshalBinary(b []byte) error {
	var res DiskInlineKeyID
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineNode disk inline node
//
// swagger:model disk_inline_node
type DiskInlineNode struct {

	// links
	Links *DiskInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline node
func (m *DiskInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline node based on the context it is used
func (m *DiskInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineNode) UnmarshalBinary(b []byte) error {
	var res DiskInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineNodeInlineLinks disk inline node inline links
//
// swagger:model disk_inline_node_inline__links
type DiskInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline node inline links
func (m *DiskInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline node inline links based on the context it is used
func (m *DiskInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineOutage Indicates if a disk has an entry in the failed disk registry, along with the reason for the failure.
//
// swagger:model disk_inline_outage
type DiskInlineOutage struct {

	// Indicates whether RAID maintains the state of this disk as failed across reboots.
	// Read Only: true
	PersistentlyFailed *bool `json:"persistently_failed,omitempty"`

	// This error message and code explaining the disk failure.
	Reason *Error `json:"reason,omitempty"`
}

// Validate validates this disk inline outage
func (m *DiskInlineOutage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineOutage) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("outage" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline outage based on the context it is used
func (m *DiskInlineOutage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePersistentlyFailed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineOutage) contextValidatePersistentlyFailed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "outage"+"."+"persistently_failed", "body", m.PersistentlyFailed); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineOutage) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("outage" + "." + "reason")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineOutage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineOutage) UnmarshalBinary(b []byte) error {
	var res DiskInlineOutage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineShelf Shelf
//
// swagger:model disk_inline_shelf
type DiskInlineShelf struct {

	// links
	Links *DiskInlineShelfInlineLinks `json:"_links,omitempty"`

	// uid
	// Example: 7777841915827391056
	UID *string `json:"uid,omitempty"`
}

// Validate validates this disk inline shelf
func (m *DiskInlineShelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineShelf) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline shelf based on the context it is used
func (m *DiskInlineShelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineShelf) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineShelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineShelf) UnmarshalBinary(b []byte) error {
	var res DiskInlineShelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineShelfInlineLinks disk inline shelf inline links
//
// swagger:model disk_inline_shelf_inline__links
type DiskInlineShelfInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline shelf inline links
func (m *DiskInlineShelfInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineShelfInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline shelf inline links based on the context it is used
func (m *DiskInlineShelfInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineShelfInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("shelf" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineShelfInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineShelfInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineShelfInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineStats disk inline stats
//
// swagger:model disk_inline_stats
type DiskInlineStats struct {

	// Average I/O latency across all active paths, in milliseconds.
	// Example: 3
	// Read Only: true
	AverageLatency *int64 `json:"average_latency,omitempty"`

	// Total I/O operations per second read and written to this disk across all active paths.
	// Example: 12854
	// Read Only: true
	IopsTotal *int64 `json:"iops_total,omitempty"`

	// Disk path error count; failed I/O operations.
	// Example: 0
	// Read Only: true
	PathErrorCount *int64 `json:"path_error_count,omitempty"`

	// Hours powered on.
	// Example: 21016
	// Read Only: true
	PowerOnHours *int64 `json:"power_on_hours,omitempty"`

	// Total disk throughput per second across all active paths, in bytes.
	// Example: 1957888
	// Read Only: true
	Throughput *int64 `json:"throughput,omitempty"`
}

// Validate validates this disk inline stats
func (m *DiskInlineStats) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this disk inline stats based on the context it is used
func (m *DiskInlineStats) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAverageLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePathErrorCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePowerOnHours(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStats) contextValidateAverageLatency(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stats"+"."+"average_latency", "body", m.AverageLatency); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineStats) contextValidateIopsTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stats"+"."+"iops_total", "body", m.IopsTotal); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineStats) contextValidatePathErrorCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stats"+"."+"path_error_count", "body", m.PathErrorCount); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineStats) contextValidatePowerOnHours(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stats"+"."+"power_on_hours", "body", m.PowerOnHours); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineStats) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "stats"+"."+"throughput", "body", m.Throughput); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineStats) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineStats) UnmarshalBinary(b []byte) error {
	var res DiskInlineStats
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineStorageAvailabilityZone Storage availability zone that the device is attached to.
//
// swagger:model disk_inline_storage_availability_zone
type DiskInlineStorageAvailabilityZone struct {

	// links
	Links *DiskInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline storage availability zone
func (m *DiskInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline storage availability zone based on the context it is used
func (m *DiskInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res DiskInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineStorageAvailabilityZoneInlineLinks disk inline storage availability zone inline links
//
// swagger:model disk_inline_storage_availability_zone_inline__links
type DiskInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline storage availability zone inline links
func (m *DiskInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline storage availability zone inline links based on the context it is used
func (m *DiskInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineStoragePool Shared Storage Pool
//
// swagger:model disk_inline_storage_pool
type DiskInlineStoragePool struct {

	// links
	Links *DiskInlineStoragePoolInlineLinks `json:"_links,omitempty"`

	// name
	// Example: storage_pool_1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this disk inline storage pool
func (m *DiskInlineStoragePool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStoragePool) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline storage pool based on the context it is used
func (m *DiskInlineStoragePool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStoragePool) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineStoragePool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineStoragePool) UnmarshalBinary(b []byte) error {
	var res DiskInlineStoragePool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineStoragePoolInlineLinks disk inline storage pool inline links
//
// swagger:model disk_inline_storage_pool_inline__links
type DiskInlineStoragePoolInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this disk inline storage pool inline links
func (m *DiskInlineStoragePoolInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStoragePoolInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this disk inline storage pool inline links based on the context it is used
func (m *DiskInlineStoragePoolInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineStoragePoolInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineStoragePoolInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineStoragePoolInlineLinks) UnmarshalBinary(b []byte) error {
	var res DiskInlineStoragePoolInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DiskInlineVirtual Information about backing storage for disks on cloud platforms.
//
// swagger:model disk_inline_virtual
type DiskInlineVirtual struct {

	// Container name of the virtual disk.
	// Example: nviet12122018113936-rg
	// Read Only: true
	Container *string `json:"container,omitempty"`

	// Object name of the virtual disk.
	// Example: f1fu63se
	// Read Only: true
	Object *string `json:"object,omitempty"`

	// Storage account name of the virtual disk.
	// Example: nviet12122018113936ps
	// Read Only: true
	StorageAccount *string `json:"storage_account,omitempty"`

	// Target address of the virtual disk.
	// Read Only: true
	TargetAddress *string `json:"target_address,omitempty"`
}

// Validate validates this disk inline virtual
func (m *DiskInlineVirtual) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this disk inline virtual based on the context it is used
func (m *DiskInlineVirtual) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskInlineVirtual) contextValidateContainer(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "virtual"+"."+"container", "body", m.Container); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineVirtual) contextValidateObject(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "virtual"+"."+"object", "body", m.Object); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineVirtual) contextValidateStorageAccount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "virtual"+"."+"storage_account", "body", m.StorageAccount); err != nil {
		return err
	}

	return nil
}

func (m *DiskInlineVirtual) contextValidateTargetAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "virtual"+"."+"target_address", "body", m.TargetAddress); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskInlineVirtual) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskInlineVirtual) UnmarshalBinary(b []byte) error {
	var res DiskInlineVirtual
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
