// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DiskErrorInfo disk error info
//
// swagger:model disk_error_info
type DiskErrorInfo struct {

	// The message and code detailing the error state of this disk.
	Reason *Error `json:"reason,omitempty"`

	// Disk error type.
	// Example: notallflashdisk
	// Read Only: true
	// Enum: ["onepath","onedomain","control","foreign","toobig","toosmall","invalidblocksize","targetasymmap","deviceassymmap","failovermisconfig","unknown","netapp","fwdownrev","qualfail","diskfail","notallflashdisk"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this disk error info
func (m *DiskErrorInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskErrorInfo) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

var diskErrorInfoTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["onepath","onedomain","control","foreign","toobig","toosmall","invalidblocksize","targetasymmap","deviceassymmap","failovermisconfig","unknown","netapp","fwdownrev","qualfail","diskfail","notallflashdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		diskErrorInfoTypeTypePropEnum = append(diskErrorInfoTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// onepath
	// END DEBUGGING
	// DiskErrorInfoTypeOnepath captures enum value "onepath"
	DiskErrorInfoTypeOnepath string = "onepath"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// onedomain
	// END DEBUGGING
	// DiskErrorInfoTypeOnedomain captures enum value "onedomain"
	DiskErrorInfoTypeOnedomain string = "onedomain"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// control
	// END DEBUGGING
	// DiskErrorInfoTypeControl captures enum value "control"
	DiskErrorInfoTypeControl string = "control"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// foreign
	// END DEBUGGING
	// DiskErrorInfoTypeForeign captures enum value "foreign"
	DiskErrorInfoTypeForeign string = "foreign"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// toobig
	// END DEBUGGING
	// DiskErrorInfoTypeToobig captures enum value "toobig"
	DiskErrorInfoTypeToobig string = "toobig"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// toosmall
	// END DEBUGGING
	// DiskErrorInfoTypeToosmall captures enum value "toosmall"
	DiskErrorInfoTypeToosmall string = "toosmall"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// invalidblocksize
	// END DEBUGGING
	// DiskErrorInfoTypeInvalidblocksize captures enum value "invalidblocksize"
	DiskErrorInfoTypeInvalidblocksize string = "invalidblocksize"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// targetasymmap
	// END DEBUGGING
	// DiskErrorInfoTypeTargetasymmap captures enum value "targetasymmap"
	DiskErrorInfoTypeTargetasymmap string = "targetasymmap"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// deviceassymmap
	// END DEBUGGING
	// DiskErrorInfoTypeDeviceassymmap captures enum value "deviceassymmap"
	DiskErrorInfoTypeDeviceassymmap string = "deviceassymmap"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// failovermisconfig
	// END DEBUGGING
	// DiskErrorInfoTypeFailovermisconfig captures enum value "failovermisconfig"
	DiskErrorInfoTypeFailovermisconfig string = "failovermisconfig"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// unknown
	// END DEBUGGING
	// DiskErrorInfoTypeUnknown captures enum value "unknown"
	DiskErrorInfoTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// netapp
	// END DEBUGGING
	// DiskErrorInfoTypeNetapp captures enum value "netapp"
	DiskErrorInfoTypeNetapp string = "netapp"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// fwdownrev
	// END DEBUGGING
	// DiskErrorInfoTypeFwdownrev captures enum value "fwdownrev"
	DiskErrorInfoTypeFwdownrev string = "fwdownrev"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// qualfail
	// END DEBUGGING
	// DiskErrorInfoTypeQualfail captures enum value "qualfail"
	DiskErrorInfoTypeQualfail string = "qualfail"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// diskfail
	// END DEBUGGING
	// DiskErrorInfoTypeDiskfail captures enum value "diskfail"
	DiskErrorInfoTypeDiskfail string = "diskfail"

	// BEGIN DEBUGGING
	// disk_error_info
	// DiskErrorInfo
	// type
	// Type
	// notallflashdisk
	// END DEBUGGING
	// DiskErrorInfoTypeNotallflashdisk captures enum value "notallflashdisk"
	DiskErrorInfoTypeNotallflashdisk string = "notallflashdisk"
)

// prop value enum
func (m *DiskErrorInfo) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, diskErrorInfoTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DiskErrorInfo) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this disk error info based on the context it is used
func (m *DiskErrorInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DiskErrorInfo) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

func (m *DiskErrorInfo) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DiskErrorInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DiskErrorInfo) UnmarshalBinary(b []byte) error {
	var res DiskErrorInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
