// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DNSDomainsArrayInline A list of DNS domains.
// Domain names have the following requirements:
//   - The name must contain only the following characters: A through Z,
//     a through z, 0 through 9, ".", "-" or "_".
//   - The first character of each label, delimited by ".", must be one
//     of the following characters: A through Z or a through z or 0
//     through 9.
//   - The last character of each label, delimited by ".", must be one of
//     the following characters: A through Z, a through z, or 0 through 9.
//   - The top level domain must contain only the following characters: A
//     through Z, a through z.
//   - The system reserves the following names:"all", "local", and "localhost".
//
// Example: ["example.com","example2.example3.com"]
//
// swagger:model dns_domains_array_inline
type DNSDomainsArrayInline []*string

// Validate validates this dns domains array inline
func (m DNSDomainsArrayInline) Validate(formats strfmt.Registry) error {
	var res []error

	iDNSDomainsArrayInlineSize := int64(len(m))

	if err := validate.MaxItems("", "body", iDNSDomainsArrayInlineSize, 6); err != nil {
		return err
	}

	for i := 0; i < len(m); i++ {
		if swag.IsZero(m[i]) { // not required
			continue
		}

		if err := validate.MinLength(strconv.Itoa(i), "body", *m[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength(strconv.Itoa(i), "body", *m[i], 255); err != nil {
			return err
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this dns domains array inline based on context it is used
func (m DNSDomainsArrayInline) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
