// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EbrOperation ebr operation
//
// swagger:model ebr_operation
type EbrOperation struct {

	// links
	Links *EbrOperationInlineLinks `json:"_links,omitempty"`

	// Operation ID
	// Example: 16842759
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Specifies the number of files on which the application of EBR policy failed.
	// Example: 0
	// Read Only: true
	NumFilesFailed *int64 `json:"num_files_failed,omitempty"`

	// Specifies the number of files on which EBR policy was applied successfully.
	// Example: 50
	// Read Only: true
	NumFilesProcessed *int64 `json:"num_files_processed,omitempty"`

	// Specifies the number of files on which the application of EBR policy was skipped.
	// Example: 2
	// Read Only: true
	NumFilesSkipped *int64 `json:"num_files_skipped,omitempty"`

	// Specifies the number of inodes on which the application of EBR policy was not attempted because they were not regular files.
	// Example: 2
	// Read Only: true
	NumInodesIgnored *int64 `json:"num_inodes_ignored,omitempty"`

	// The path for the EBR operation. Specifies the path relative to the output volume root, of the form "/path". The path can be path to a file or a directory.
	// Example: /dir1/file
	Path *string `json:"path,omitempty"`

	// policy
	Policy *EbrOperationInlinePolicy `json:"policy,omitempty"`

	// Specifies the operation status of an EBR operation.
	// Example: completed
	// Read Only: true
	// Enum: ["unknown","in_progress","failed","aborting","completed"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *EbrOperationInlineSvm `json:"svm,omitempty"`

	// volume
	Volume *EbrOperationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this ebr operation
func (m *EbrOperation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperation) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperation) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

var ebrOperationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","in_progress","failed","aborting","completed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ebrOperationTypeStatePropEnum = append(ebrOperationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ebr_operation
	// EbrOperation
	// state
	// State
	// unknown
	// END DEBUGGING
	// EbrOperationStateUnknown captures enum value "unknown"
	EbrOperationStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// ebr_operation
	// EbrOperation
	// state
	// State
	// in_progress
	// END DEBUGGING
	// EbrOperationStateInProgress captures enum value "in_progress"
	EbrOperationStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// ebr_operation
	// EbrOperation
	// state
	// State
	// failed
	// END DEBUGGING
	// EbrOperationStateFailed captures enum value "failed"
	EbrOperationStateFailed string = "failed"

	// BEGIN DEBUGGING
	// ebr_operation
	// EbrOperation
	// state
	// State
	// aborting
	// END DEBUGGING
	// EbrOperationStateAborting captures enum value "aborting"
	EbrOperationStateAborting string = "aborting"

	// BEGIN DEBUGGING
	// ebr_operation
	// EbrOperation
	// state
	// State
	// completed
	// END DEBUGGING
	// EbrOperationStateCompleted captures enum value "completed"
	EbrOperationStateCompleted string = "completed"
)

// prop value enum
func (m *EbrOperation) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ebrOperationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EbrOperation) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation based on the context it is used
func (m *EbrOperation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesFailed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesProcessed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumFilesSkipped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumInodesIgnored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperation) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperation) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidateNumFilesFailed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_failed", "body", m.NumFilesFailed); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidateNumFilesProcessed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_processed", "body", m.NumFilesProcessed); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidateNumFilesSkipped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_files_skipped", "body", m.NumFilesSkipped); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidateNumInodesIgnored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_inodes_ignored", "body", m.NumInodesIgnored); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperation) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *EbrOperation) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperation) UnmarshalBinary(b []byte) error {
	var res EbrOperation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlineLinks ebr operation inline links
//
// swagger:model ebr_operation_inline__links
type EbrOperationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ebr operation inline links
func (m *EbrOperationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline links based on the context it is used
func (m *EbrOperationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlineLinks) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlinePolicy ebr operation inline policy
//
// swagger:model ebr_operation_inline_policy
type EbrOperationInlinePolicy struct {

	// links
	Links *EbrOperationInlinePolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the EBR policy name
	Name *string `json:"name,omitempty"`

	// Specifies the retention period of an event based retention policy. The retention period value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours or minutes. A period specified for years, months and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively. For example "P10Y" represents a duration of 10 years. Similarly, a duration in hours, minutes is represented by "PT<num>H", "PT<num>M" respectively. The period string must contain only a single time element i.e. either years, months, days, hours or minutes. A duration which combines different periods is not supported, example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the retention period field also accepts the strings "infinite" and "unspecified".
	// Example: P30M
	// Read Only: true
	RetentionPeriod *string `json:"retention_period,omitempty"`
}

// Validate validates this ebr operation inline policy
func (m *EbrOperationInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline policy based on the context it is used
func (m *EbrOperationInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetentionPeriod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *EbrOperationInlinePolicy) contextValidateRetentionPeriod(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "policy"+"."+"retention_period", "body", m.RetentionPeriod); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlinePolicy) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlinePolicyInlineLinks ebr operation inline policy inline links
//
// swagger:model ebr_operation_inline_policy_inline__links
type EbrOperationInlinePolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ebr operation inline policy inline links
func (m *EbrOperationInlinePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlinePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline policy inline links based on the context it is used
func (m *EbrOperationInlinePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlinePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlinePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlinePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlinePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model ebr_operation_inline_svm
type EbrOperationInlineSvm struct {

	// links
	Links *EbrOperationInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ebr operation inline svm
func (m *EbrOperationInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline svm based on the context it is used
func (m *EbrOperationInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlineSvm) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlineSvmInlineLinks ebr operation inline svm inline links
//
// swagger:model ebr_operation_inline_svm_inline__links
type EbrOperationInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ebr operation inline svm inline links
func (m *EbrOperationInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline svm inline links based on the context it is used
func (m *EbrOperationInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlineVolume ebr operation inline volume
//
// swagger:model ebr_operation_inline_volume
type EbrOperationInlineVolume struct {

	// links
	Links *EbrOperationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ebr operation inline volume
func (m *EbrOperationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline volume based on the context it is used
func (m *EbrOperationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlineVolume) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EbrOperationInlineVolumeInlineLinks ebr operation inline volume inline links
//
// swagger:model ebr_operation_inline_volume_inline__links
type EbrOperationInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ebr operation inline volume inline links
func (m *EbrOperationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ebr operation inline volume inline links based on the context it is used
func (m *EbrOperationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EbrOperationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EbrOperationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EbrOperationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res EbrOperationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
