// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EffectivePermission Displays the effective permission granted to a Windows or UNIX user on the specified file or folder path.
//
// swagger:model effective_permission
type EffectivePermission struct {

	// Specifies the effective permission granted to a user on the specified file or folder path.
	FilePermissions []*string `json:"file_permissions,omitempty"`

	// Specifies the path of the file or the folder for which you want to display effective permissions.
	// The path is relative to the SVM root volume. If "-share-name" is specified then path will be relative to the share path.
	//
	// Example: /dir1/dir2
	Path *string `json:"path,omitempty"`

	// share
	Share *Share `json:"share,omitempty"`

	// Specifies the effective permission granted to a user on the specified file or folder path.
	SharePermissions []*string `json:"share_permissions,omitempty"`

	// svm
	Svm *SvmReference `json:"svm,omitempty"`

	// Specifies the user type. The following values are allowed:
	// * windows  - Windows user
	// * unix     - UNIX user
	//
	// Enum: ["windows","unix"]
	Type *string `json:"type,omitempty"`

	// Specifies the user for which effective permission needs to be displayed for the specified path.
	// Example: cifs1/administrator
	User *string `json:"user,omitempty"`
}

// Validate validates this effective permission
func (m *EffectivePermission) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFilePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSharePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var effectivePermissionFilePermissionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["generic_read","generic_write","generic_execute","generic_all","system_security","synchronize","write_owner","write_dac","read_control","delete","write_attributes","read_attributes","delete_child","execute","write_ea","read_ea","append","write","read"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		effectivePermissionFilePermissionsItemsEnum = append(effectivePermissionFilePermissionsItemsEnum, v)
	}
}

func (m *EffectivePermission) validateFilePermissionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, effectivePermissionFilePermissionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EffectivePermission) validateFilePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.FilePermissions) { // not required
		return nil
	}

	for i := 0; i < len(m.FilePermissions); i++ {
		if swag.IsZero(m.FilePermissions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateFilePermissionsItemsEnum("file_permissions"+"."+strconv.Itoa(i), "body", *m.FilePermissions[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *EffectivePermission) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if m.Share != nil {
		if err := m.Share.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

var effectivePermissionSharePermissionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["generic_read","generic_write","generic_execute","generic_all","system_security","synchronize","write_owner","write_dac","read_control","delete","write_attributes","read_attributes","delete_child","execute","write_ea","read_ea","append","write","read"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		effectivePermissionSharePermissionsItemsEnum = append(effectivePermissionSharePermissionsItemsEnum, v)
	}
}

func (m *EffectivePermission) validateSharePermissionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, effectivePermissionSharePermissionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EffectivePermission) validateSharePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.SharePermissions) { // not required
		return nil
	}

	for i := 0; i < len(m.SharePermissions); i++ {
		if swag.IsZero(m.SharePermissions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateSharePermissionsItemsEnum("share_permissions"+"."+strconv.Itoa(i), "body", *m.SharePermissions[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *EffectivePermission) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var effectivePermissionTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["windows","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		effectivePermissionTypeTypePropEnum = append(effectivePermissionTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// effective_permission
	// EffectivePermission
	// type
	// Type
	// windows
	// END DEBUGGING
	// EffectivePermissionTypeWindows captures enum value "windows"
	EffectivePermissionTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// effective_permission
	// EffectivePermission
	// type
	// Type
	// unix
	// END DEBUGGING
	// EffectivePermissionTypeUnix captures enum value "unix"
	EffectivePermissionTypeUnix string = "unix"
)

// prop value enum
func (m *EffectivePermission) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, effectivePermissionTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EffectivePermission) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this effective permission based on the context it is used
func (m *EffectivePermission) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShare(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EffectivePermission) contextValidateShare(ctx context.Context, formats strfmt.Registry) error {

	if m.Share != nil {
		if err := m.Share.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

func (m *EffectivePermission) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EffectivePermission) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EffectivePermission) UnmarshalBinary(b []byte) error {
	var res EffectivePermission
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
