// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsApplicationLog Input for generation of app.log.x and callhome.client.app.x events.
//
// swagger:model ems_application_log
type EmsApplicationLog struct {

	// Client application version.
	// Example: 3.0.0.2373
	AppVersion *string `json:"app_version,omitempty"`

	// Indicates whether AutoSupport generation is required.
	// Example: false
	AutosupportRequired *bool `json:"autosupport_required,omitempty"`

	// Event category.
	// Example: Error
	Category *string `json:"category,omitempty"`

	// Client computer connected to the cluster.
	// Example: W12-R2-DC
	ComputerName *string `json:"computer_name,omitempty"`

	// Event description, which corresponds to the subject parameter in the generated event.
	// Example: Clone split job failed
	EventDescription *string `json:"event_description,omitempty"`

	// Application eventID.
	// Example: 10001
	EventID *int64 `json:"event_id,omitempty"`

	// Client application that generated this event.
	// Example: SnapCenter Software
	EventSource *string `json:"event_source,omitempty"`

	// Severity
	// Example: error
	// Enum: ["emergency","alert","error","notice"]
	Severity *string `json:"severity,omitempty"`
}

// Validate validates this ems application log
func (m *EmsApplicationLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var emsApplicationLogTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["emergency","alert","error","notice"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsApplicationLogTypeSeverityPropEnum = append(emsApplicationLogTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_application_log
	// EmsApplicationLog
	// severity
	// Severity
	// emergency
	// END DEBUGGING
	// EmsApplicationLogSeverityEmergency captures enum value "emergency"
	EmsApplicationLogSeverityEmergency string = "emergency"

	// BEGIN DEBUGGING
	// ems_application_log
	// EmsApplicationLog
	// severity
	// Severity
	// alert
	// END DEBUGGING
	// EmsApplicationLogSeverityAlert captures enum value "alert"
	EmsApplicationLogSeverityAlert string = "alert"

	// BEGIN DEBUGGING
	// ems_application_log
	// EmsApplicationLog
	// severity
	// Severity
	// error
	// END DEBUGGING
	// EmsApplicationLogSeverityError captures enum value "error"
	EmsApplicationLogSeverityError string = "error"

	// BEGIN DEBUGGING
	// ems_application_log
	// EmsApplicationLog
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// EmsApplicationLogSeverityNotice captures enum value "notice"
	EmsApplicationLogSeverityNotice string = "notice"
)

// prop value enum
func (m *EmsApplicationLog) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsApplicationLogTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsApplicationLog) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ems application log based on context it is used
func (m *EmsApplicationLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsApplicationLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsApplicationLog) UnmarshalBinary(b []byte) error {
	var res EmsApplicationLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
