// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// EmsConfig ems config
//
// swagger:model ems_config
type EmsConfig struct {

	// links
	Links *EmsConfigInlineLinks `json:"_links,omitempty"`

	// Mail from
	// Example: administrator@mycompany.com
	MailFrom *string `json:"mail_from,omitempty"`

	// Mail server (SMTP)
	// Example: mail.mycompany.com
	MailServer *string `json:"mail_server,omitempty"`

	// Password for Mail server (SMTP)
	// Example: password
	MailServerPassword *string `json:"mail_server_password,omitempty"`

	// Username for Mail server (SMTP)
	// Example: user
	MailServerUser *string `json:"mail_server_user,omitempty"`

	// Password for HTTP/HTTPS proxy
	// Example: password
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// HTTP/HTTPS proxy URL
	// Example: https://proxyserver.mycompany.com
	ProxyURL *string `json:"proxy_url,omitempty"`

	// User name for HTTP/HTTPS proxy
	// Example: proxy_user
	ProxyUser *string `json:"proxy_user,omitempty"`

	// Is Publish/Subscribe Messaging Enabled?
	// Example: true
	PubsubEnabled *bool `json:"pubsub_enabled,omitempty"`
}

// Validate validates this ems config
func (m *EmsConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsConfig) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems config based on the context it is used
func (m *EmsConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsConfig) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsConfig) UnmarshalBinary(b []byte) error {
	var res EmsConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsConfigInlineLinks ems config inline links
//
// swagger:model ems_config_inline__links
type EmsConfigInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems config inline links
func (m *EmsConfigInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsConfigInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems config inline links based on the context it is used
func (m *EmsConfigInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsConfigInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsConfigInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsConfigInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsConfigInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
