// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsDestination ems destination
//
// swagger:model ems_destination
type EmsDestination struct {

	// links
	Links *EmsDestinationInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *EmsDestinationInlineAccessControlRole `json:"access_control_role,omitempty"`

	// certificate
	Certificate *EmsDestinationInlineCertificate `json:"certificate,omitempty"`

	// connectivity
	Connectivity *EmsDestinationInlineConnectivity `json:"connectivity,omitempty"`

	// Event destination
	// Example: administrator@mycompany.com
	Destination *string `json:"destination,omitempty"`

	// ems destination inline filters
	EmsDestinationInlineFilters []*EmsDestinationInlineFiltersInlineArrayItem `json:"filters,omitempty"`

	// Destination name.  Valid in POST.
	// Example: Admin_Email
	Name *string `json:"name,omitempty"`

	// syslog
	Syslog *EmsDestinationInlineSyslog `json:"syslog,omitempty"`

	// Flag indicating system-defined destinations.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`

	// Type of destination. Valid in POST.
	// Example: email
	// Enum: ["snmp","email","syslog","rest_api"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems destination
func (m *EmsDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsDestinationInlineFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyslog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestination) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControlRole) { // not required
		return nil
	}

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.Connectivity) { // not required
		return nil
	}

	if m.Connectivity != nil {
		if err := m.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) validateEmsDestinationInlineFilters(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsDestinationInlineFilters) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsDestinationInlineFilters); i++ {
		if swag.IsZero(m.EmsDestinationInlineFilters[i]) { // not required
			continue
		}

		if m.EmsDestinationInlineFilters[i] != nil {
			if err := m.EmsDestinationInlineFilters[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestination) validateSyslog(formats strfmt.Registry) error {
	if swag.IsZero(m.Syslog) { // not required
		return nil
	}

	if m.Syslog != nil {
		if err := m.Syslog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

var emsDestinationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmp","email","syslog","rest_api"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationTypeTypePropEnum = append(emsDestinationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination
	// EmsDestination
	// type
	// Type
	// snmp
	// END DEBUGGING
	// EmsDestinationTypeSnmp captures enum value "snmp"
	EmsDestinationTypeSnmp string = "snmp"

	// BEGIN DEBUGGING
	// ems_destination
	// EmsDestination
	// type
	// Type
	// email
	// END DEBUGGING
	// EmsDestinationTypeEmail captures enum value "email"
	EmsDestinationTypeEmail string = "email"

	// BEGIN DEBUGGING
	// ems_destination
	// EmsDestination
	// type
	// Type
	// syslog
	// END DEBUGGING
	// EmsDestinationTypeSyslog captures enum value "syslog"
	EmsDestinationTypeSyslog string = "syslog"

	// BEGIN DEBUGGING
	// ems_destination
	// EmsDestination
	// type
	// Type
	// rest_api
	// END DEBUGGING
	// EmsDestinationTypeRestAPI captures enum value "rest_api"
	EmsDestinationTypeRestAPI string = "rest_api"
)

// prop value enum
func (m *EmsDestination) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestination) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination based on the context it is used
func (m *EmsDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsDestinationInlineFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSyslog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestination) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.Connectivity != nil {
		if err := m.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) contextValidateEmsDestinationInlineFilters(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsDestinationInlineFilters); i++ {

		if m.EmsDestinationInlineFilters[i] != nil {
			if err := m.EmsDestinationInlineFilters[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestination) contextValidateSyslog(ctx context.Context, formats strfmt.Registry) error {

	if m.Syslog != nil {
		if err := m.Syslog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestination) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", m.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestination) UnmarshalBinary(b []byte) error {
	var res EmsDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineAccessControlRole Indicates the access control role that created the event destination and is used to control access to the destination based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
//
// swagger:model ems_destination_inline_access_control_role
type EmsDestinationInlineAccessControlRole struct {

	// links
	Links *EmsDestinationInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination inline access control role
func (m *EmsDestinationInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline access control role based on the context it is used
func (m *EmsDestinationInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineAccessControlRoleInlineLinks ems destination inline access control role inline links
//
// swagger:model ems_destination_inline_access_control_role_inline__links
type EmsDestinationInlineAccessControlRoleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination inline access control role inline links
func (m *EmsDestinationInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline access control role inline links based on the context it is used
func (m *EmsDestinationInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineCertificate Specifies the client-side certificate used by the ONTAP system when mutual authentication is required. This object is only applicable for __rest_api__ type destinations. Both the `ca` and `serial_number` fields must be specified when configuring a certificate in a PATCH or POST request. The `name` field is read-only and cannot be used to configure a client-side certificate.
//
// swagger:model ems_destination_inline_certificate
type EmsDestinationInlineCertificate struct {

	// links
	Links *EmsDestinationInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Client certificate issuing CA
	// Example: VeriSign
	// Max Length: 256
	// Min Length: 1
	Ca *string `json:"ca,omitempty"`

	// Certificate name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Client certificate serial number
	// Example: 1234567890
	// Max Length: 40
	// Min Length: 1
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this ems destination inline certificate
func (m *EmsDestinationInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationInlineCertificate) validateCa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ca) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"ca", "body", *m.Ca, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"ca", "body", *m.Ca, 256); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationInlineCertificate) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 40); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination inline certificate based on the context it is used
func (m *EmsDestinationInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationInlineCertificate) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineCertificate) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineCertificateInlineLinks ems destination inline certificate inline links
//
// swagger:model ems_destination_inline_certificate_inline__links
type EmsDestinationInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination inline certificate inline links
func (m *EmsDestinationInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline certificate inline links based on the context it is used
func (m *EmsDestinationInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineConnectivity ems destination inline connectivity
//
// swagger:model ems_destination_inline_connectivity
type EmsDestinationInlineConnectivity struct {

	// A list of errors encountered during connectivity checks.
	// Read Only: true
	Errors []*EmsDestinationConnectivityErrorsItems0 `json:"errors,omitempty"`

	// Current connectivity state.
	// Example: fail
	// Read Only: true
	// Enum: ["success","fail","not_supported"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ems destination inline connectivity
func (m *EmsDestinationInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineConnectivity) validateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.Errors) { // not required
		return nil
	}

	for i := 0; i < len(m.Errors); i++ {
		if swag.IsZero(m.Errors[i]) { // not required
			continue
		}

		if m.Errors[i] != nil {
			if err := m.Errors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsDestinationInlineConnectivityTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["success","fail","not_supported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationInlineConnectivityTypeStatePropEnum = append(emsDestinationInlineConnectivityTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_inline_connectivity
	// EmsDestinationInlineConnectivity
	// state
	// State
	// success
	// END DEBUGGING
	// EmsDestinationInlineConnectivityStateSuccess captures enum value "success"
	EmsDestinationInlineConnectivityStateSuccess string = "success"

	// BEGIN DEBUGGING
	// ems_destination_inline_connectivity
	// EmsDestinationInlineConnectivity
	// state
	// State
	// fail
	// END DEBUGGING
	// EmsDestinationInlineConnectivityStateFail captures enum value "fail"
	EmsDestinationInlineConnectivityStateFail string = "fail"

	// BEGIN DEBUGGING
	// ems_destination_inline_connectivity
	// EmsDestinationInlineConnectivity
	// state
	// State
	// not_supported
	// END DEBUGGING
	// EmsDestinationInlineConnectivityStateNotSupported captures enum value "not_supported"
	EmsDestinationInlineConnectivityStateNotSupported string = "not_supported"
)

// prop value enum
func (m *EmsDestinationInlineConnectivity) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationInlineConnectivityTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationInlineConnectivity) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("connectivity"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination inline connectivity based on the context it is used
func (m *EmsDestinationInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineConnectivity) contextValidateErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"errors", "body", []*EmsDestinationConnectivityErrorsItems0(m.Errors)); err != nil {
		return err
	}

	for i := 0; i < len(m.Errors); i++ {

		if m.Errors[i] != nil {
			if err := m.Errors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationInlineConnectivity) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationConnectivityErrorsItems0 Error object included in the event of connectivity failure.
//
// swagger:model EmsDestinationConnectivityErrorsItems0
type EmsDestinationConnectivityErrorsItems0 struct {

	// message
	Message *EmsDestinationConnectivityErrorsItems0Message `json:"message,omitempty"`

	// node
	Node *EmsDestinationConnectivityErrorsItems0Node `json:"node,omitempty"`
}

// Validate validates this ems destination connectivity errors items0
func (m *EmsDestinationConnectivityErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination connectivity errors items0 based on the context it is used
func (m *EmsDestinationConnectivityErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationConnectivityErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationConnectivityErrorsItems0Message Information to be displayed to the user.
//
// swagger:model EmsDestinationConnectivityErrorsItems0Message
type EmsDestinationConnectivityErrorsItems0Message struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination connectivity errors items0 message
func (m *EmsDestinationConnectivityErrorsItems0Message) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Message) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination connectivity errors items0 message based on the context it is used
func (m *EmsDestinationConnectivityErrorsItems0Message) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Message) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"arguments", "body", []*EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Message) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Message) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0Message) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0Message) UnmarshalBinary(b []byte) error {
	var res EmsDestinationConnectivityErrorsItems0Message
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0 ems destination connectivity errors items0 message arguments items0
//
// swagger:model EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0
type EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination connectivity errors items0 message arguments items0
func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems destination connectivity errors items0 message arguments items0 based on the context it is used
func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationConnectivityErrorsItems0MessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationConnectivityErrorsItems0Node ems destination connectivity errors items0 node
//
// swagger:model EmsDestinationConnectivityErrorsItems0Node
type EmsDestinationConnectivityErrorsItems0Node struct {

	// links
	Links *EmsDestinationConnectivityErrorsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ems destination connectivity errors items0 node
func (m *EmsDestinationConnectivityErrorsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination connectivity errors items0 node based on the context it is used
func (m *EmsDestinationConnectivityErrorsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0Node) UnmarshalBinary(b []byte) error {
	var res EmsDestinationConnectivityErrorsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationConnectivityErrorsItems0NodeLinks ems destination connectivity errors items0 node links
//
// swagger:model EmsDestinationConnectivityErrorsItems0NodeLinks
type EmsDestinationConnectivityErrorsItems0NodeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination connectivity errors items0 node links
func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination connectivity errors items0 node links based on the context it is used
func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationConnectivityErrorsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationConnectivityErrorsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineFiltersInlineArrayItem ems destination inline filters inline array item
//
// swagger:model ems_destination_inline_filters_inline_array_item
type EmsDestinationInlineFiltersInlineArrayItem struct {

	// links
	Links *EmsDestinationInlineFiltersInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination inline filters inline array item
func (m *EmsDestinationInlineFiltersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineFiltersInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline filters inline array item based on the context it is used
func (m *EmsDestinationInlineFiltersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineFiltersInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineFiltersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineFiltersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineFiltersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineFiltersInlineArrayItemInlineLinks ems destination inline filters inline array item inline links
//
// swagger:model ems_destination_inline_filters_inline_array_item_inline__links
type EmsDestinationInlineFiltersInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination inline filters inline array item inline links
func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline filters inline array item inline links based on the context it is used
func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineFiltersInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineFiltersInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineLinks ems destination inline links
//
// swagger:model ems_destination_inline__links
type EmsDestinationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination inline links
func (m *EmsDestinationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination inline links based on the context it is used
func (m *EmsDestinationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineSyslog ems destination inline syslog
//
// swagger:model ems_destination_inline_syslog
type EmsDestinationInlineSyslog struct {

	// format
	Format *EmsDestinationInlineSyslogInlineFormat `json:"format,omitempty"`

	// Syslog Port.
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Syslog Transport Protocol.
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Transport *string `json:"transport,omitempty"`
}

// Validate validates this ems destination inline syslog
func (m *EmsDestinationInlineSyslog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineSyslog) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	if m.Format != nil {
		if err := m.Format.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

var emsDestinationInlineSyslogTypeTransportPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationInlineSyslogTypeTransportPropEnum = append(emsDestinationInlineSyslogTypeTransportPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog
	// EmsDestinationInlineSyslog
	// transport
	// Transport
	// udp_unencrypted
	// END DEBUGGING
	// EmsDestinationInlineSyslogTransportUDPUnencrypted captures enum value "udp_unencrypted"
	EmsDestinationInlineSyslogTransportUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog
	// EmsDestinationInlineSyslog
	// transport
	// Transport
	// tcp_unencrypted
	// END DEBUGGING
	// EmsDestinationInlineSyslogTransportTCPUnencrypted captures enum value "tcp_unencrypted"
	EmsDestinationInlineSyslogTransportTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog
	// EmsDestinationInlineSyslog
	// transport
	// Transport
	// tcp_encrypted
	// END DEBUGGING
	// EmsDestinationInlineSyslogTransportTCPEncrypted captures enum value "tcp_encrypted"
	EmsDestinationInlineSyslogTransportTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (m *EmsDestinationInlineSyslog) validateTransportEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationInlineSyslogTypeTransportPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationInlineSyslog) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(m.Transport) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransportEnum("syslog"+"."+"transport", "body", *m.Transport); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination inline syslog based on the context it is used
func (m *EmsDestinationInlineSyslog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationInlineSyslog) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if m.Format != nil {
		if err := m.Format.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineSyslog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineSyslog) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineSyslog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationInlineSyslogInlineFormat ems destination inline syslog inline format
//
// swagger:model ems_destination_inline_syslog_inline_format
type EmsDestinationInlineSyslogInlineFormat struct {

	// Syslog Hostname Format Override. The supported hostname formats are no_override (hostname format based on the syslog.format.message property i.e. fqdn if syslog.format.message is rfc_5424, hostname_only if syslog.format.message is legacy_netapp), fqdn (Fully Qualified Domain Name) and hostname_only.
	//
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameOverride *string `json:"hostname_override,omitempty"`

	// Syslog Message Format. The supported message formats are legacy_netapp (format: &lt;PRIVAL&gt;TIMESTAMP [HOSTNAME:Event-name:Event-severity]: MSG) and rfc_5424 (format: &lt;PRIVAL&gt;VERSION TIMESTAMP HOSTNAME Event-source - Event-name - MSG).
	//
	// Enum: ["legacy_netapp","rfc_5424"]
	Message *string `json:"message,omitempty"`

	// Syslog Timestamp Format Override. The supported timestamp formats are no_override (timestamp format based on the syslog.format.message property i.e. rfc_3164 if syslog.format.message is legacy_netapp, iso_8601_local_time if syslog.format.message is rfc_5424), rfc_3164 (format: Mmm dd hh:mm:ss), iso_8601_local_time (format: YYYY-MM-DDThh:mm:ss+/-hh:mm) and iso_8601_utc (format: YYYY-MM-DDThh:mm:ssZ).
	//
	// Enum: ["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]
	TimestampOverride *string `json:"timestamp_override,omitempty"`
}

// Validate validates this ems destination inline syslog inline format
func (m *EmsDestinationInlineSyslogInlineFormat) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostnameOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var emsDestinationInlineSyslogInlineFormatTypeHostnameOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationInlineSyslogInlineFormatTypeHostnameOverridePropEnum = append(emsDestinationInlineSyslogInlineFormatTypeHostnameOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatHostnameOverrideNoOverride captures enum value "no_override"
	EmsDestinationInlineSyslogInlineFormatHostnameOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// fqdn
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatHostnameOverrideFqdn captures enum value "fqdn"
	EmsDestinationInlineSyslogInlineFormatHostnameOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// hostname_only
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatHostnameOverrideHostnameOnly captures enum value "hostname_only"
	EmsDestinationInlineSyslogInlineFormatHostnameOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (m *EmsDestinationInlineSyslogInlineFormat) validateHostnameOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationInlineSyslogInlineFormatTypeHostnameOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationInlineSyslogInlineFormat) validateHostnameOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.HostnameOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateHostnameOverrideEnum("syslog"+"."+"format"+"."+"hostname_override", "body", *m.HostnameOverride); err != nil {
		return err
	}

	return nil
}

var emsDestinationInlineSyslogInlineFormatTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationInlineSyslogInlineFormatTypeMessagePropEnum = append(emsDestinationInlineSyslogInlineFormatTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// message
	// Message
	// legacy_netapp
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatMessageLegacyNetapp captures enum value "legacy_netapp"
	EmsDestinationInlineSyslogInlineFormatMessageLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// message
	// Message
	// rfc_5424
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatMessageRfc5424 captures enum value "rfc_5424"
	EmsDestinationInlineSyslogInlineFormatMessageRfc5424 string = "rfc_5424"
)

// prop value enum
func (m *EmsDestinationInlineSyslogInlineFormat) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationInlineSyslogInlineFormatTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationInlineSyslogInlineFormat) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("syslog"+"."+"format"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

var emsDestinationInlineSyslogInlineFormatTypeTimestampOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationInlineSyslogInlineFormatTypeTimestampOverridePropEnum = append(emsDestinationInlineSyslogInlineFormatTypeTimestampOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatTimestampOverrideNoOverride captures enum value "no_override"
	EmsDestinationInlineSyslogInlineFormatTimestampOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// rfc_3164
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatTimestampOverrideRfc3164 captures enum value "rfc_3164"
	EmsDestinationInlineSyslogInlineFormatTimestampOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_local_time
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	EmsDestinationInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime string = "iso_8601_local_time"

	// BEGIN DEBUGGING
	// ems_destination_inline_syslog_inline_format
	// EmsDestinationInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_utc
	// END DEBUGGING
	// EmsDestinationInlineSyslogInlineFormatTimestampOverrideIso8601Utc captures enum value "iso_8601_utc"
	EmsDestinationInlineSyslogInlineFormatTimestampOverrideIso8601Utc string = "iso_8601_utc"
)

// prop value enum
func (m *EmsDestinationInlineSyslogInlineFormat) validateTimestampOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationInlineSyslogInlineFormatTypeTimestampOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationInlineSyslogInlineFormat) validateTimestampOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.TimestampOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateTimestampOverrideEnum("syslog"+"."+"format"+"."+"timestamp_override", "body", *m.TimestampOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ems destination inline syslog inline format based on context it is used
func (m *EmsDestinationInlineSyslogInlineFormat) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationInlineSyslogInlineFormat) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationInlineSyslogInlineFormat) UnmarshalBinary(b []byte) error {
	var res EmsDestinationInlineSyslogInlineFormat
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
