// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsDestinationResponse ems destination response
//
// swagger:model ems_destination_response
type EmsDestinationResponse struct {

	// links
	Links *EmsDestinationResponseInlineLinks `json:"_links,omitempty"`

	// ems destination response inline records
	EmsDestinationResponseInlineRecords []*EmsDestinationResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this ems destination response
func (m *EmsDestinationResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsDestinationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponse) validateEmsDestinationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsDestinationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsDestinationResponseInlineRecords); i++ {
		if swag.IsZero(m.EmsDestinationResponseInlineRecords[i]) { // not required
			continue
		}

		if m.EmsDestinationResponseInlineRecords[i] != nil {
			if err := m.EmsDestinationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination response based on the context it is used
func (m *EmsDestinationResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsDestinationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponse) contextValidateEmsDestinationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsDestinationResponseInlineRecords); i++ {

		if m.EmsDestinationResponseInlineRecords[i] != nil {
			if err := m.EmsDestinationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponse) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineLinks ems destination response inline links
//
// swagger:model ems_destination_response_inline__links
type EmsDestinationResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline links
func (m *EmsDestinationResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline links based on the context it is used
func (m *EmsDestinationResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItem ems destination response inline records inline array item
//
// swagger:model ems_destination_response_inline_records_inline_array_item
type EmsDestinationResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// certificate
	Certificate *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// connectivity
	Connectivity *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity `json:"connectivity,omitempty"`

	// Event destination
	// Example: administrator@mycompany.com
	Destination *string `json:"destination,omitempty"`

	// filters
	Filters []*EmsDestinationResponseRecordsItems0FiltersItems0 `json:"filters"`

	// Destination name.  Valid in POST.
	// Example: Admin_Email
	Name *string `json:"name,omitempty"`

	// syslog
	Syslog *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog `json:"syslog,omitempty"`

	// Flag indicating system-defined destinations.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`

	// Type of destination. Valid in POST.
	// Example: email
	// Enum: ["snmp","email","syslog","rest_api"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems destination response inline records inline array item
func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSyslog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControlRole) { // not required
		return nil
	}

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.Connectivity) { // not required
		return nil
	}

	if m.Connectivity != nil {
		if err := m.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateFilters(formats strfmt.Registry) error {
	if swag.IsZero(m.Filters) { // not required
		return nil
	}

	for i := 0; i < len(m.Filters); i++ {
		if swag.IsZero(m.Filters[i]) { // not required
			continue
		}

		if m.Filters[i] != nil {
			if err := m.Filters[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateSyslog(formats strfmt.Registry) error {
	if swag.IsZero(m.Syslog) { // not required
		return nil
	}

	if m.Syslog != nil {
		if err := m.Syslog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmp","email","syslog","rest_api"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// snmp
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeSnmp captures enum value "snmp"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeSnmp string = "snmp"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// email
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeEmail captures enum value "email"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeEmail string = "email"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// syslog
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeSyslog captures enum value "syslog"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeSyslog string = "syslog"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// rest_api
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeRestAPI captures enum value "rest_api"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeRestAPI string = "rest_api"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSyslog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.Connectivity != nil {
		if err := m.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateFilters(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Filters); i++ {

		if m.Filters[i] != nil {
			if err := m.Filters[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateSyslog(ctx context.Context, formats strfmt.Registry) error {

	if m.Syslog != nil {
		if err := m.Syslog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", m.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole Indicates the access control role that created the event destination and is used to control access to the destination based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_access_control_role
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole struct {

	// links
	Links *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline access control role
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline access control role based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks ems destination response inline records inline array item inline access control role inline links
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_access_control_role_inline__links
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline access control role inline links
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline access control role inline links based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate Specifies the client-side certificate used by the ONTAP system when mutual authentication is required. This object is only applicable for __rest_api__ type destinations. Both the `ca` and `serial_number` fields must be specified when configuring a certificate in a PATCH or POST request. The `name` field is read-only and cannot be used to configure a client-side certificate.
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_certificate
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate struct {

	// links
	Links *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Client certificate issuing CA
	// Example: VeriSign
	// Max Length: 256
	// Min Length: 1
	Ca *string `json:"ca,omitempty"`

	// Certificate name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Client certificate serial number
	// Example: 1234567890
	// Max Length: 40
	// Min Length: 1
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline certificate
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateCa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ca) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"ca", "body", *m.Ca, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"ca", "body", *m.Ca, 256); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"serial_number", "body", *m.SerialNumber, 40); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline certificate based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks ems destination response inline records inline array item inline certificate inline links
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_certificate_inline__links
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline certificate inline links
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline certificate inline links based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity ems destination response inline records inline array item inline connectivity
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_connectivity
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity struct {

	// A list of errors encountered during connectivity checks.
	// Read Only: true
	Errors []*EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0 `json:"errors"`

	// Current connectivity state.
	// Example: fail
	// Read Only: true
	// Enum: ["success","fail","not_supported"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline connectivity
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.Errors) { // not required
		return nil
	}

	for i := 0; i < len(m.Errors); i++ {
		if swag.IsZero(m.Errors[i]) { // not required
			continue
		}

		if m.Errors[i] != nil {
			if err := m.Errors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["success","fail","not_supported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// success
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateSuccess captures enum value "success"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateSuccess string = "success"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// fail
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateFail captures enum value "fail"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateFail string = "fail"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// not_supported
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateNotSupported captures enum value "not_supported"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateNotSupported string = "not_supported"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("connectivity"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline connectivity based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) contextValidateErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"errors", "body", []*EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0(m.Errors)); err != nil {
		return err
	}

	for i := 0; i < len(m.Errors); i++ {

		if m.Errors[i] != nil {
			if err := m.Errors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0 Error object included in the event of connectivity failure.
//
// swagger:model EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0
type EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0 struct {

	// message
	Message *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message `json:"message,omitempty"`

	// node
	Node *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node `json:"node,omitempty"`
}

// Validate validates this ems destination response records items0 connectivity errors items0
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response records items0 connectivity errors items0 based on the context it is used
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message Information to be displayed to the user.
//
// swagger:model EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message
type EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination response records items0 connectivity errors items0 message
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination response records items0 connectivity errors items0 message based on the context it is used
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"arguments", "body", []*EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Message
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 ems destination response records items0 connectivity errors items0 message arguments items0
//
// swagger:model EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
type EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination response records items0 connectivity errors items0 message arguments items0
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems destination response records items0 connectivity errors items0 message arguments items0 based on the context it is used
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node ems destination response records items0 connectivity errors items0 node
//
// swagger:model EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node
type EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node struct {

	// links
	Links *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ems destination response records items0 connectivity errors items0 node
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response records items0 connectivity errors items0 node based on the context it is used
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks ems destination response records items0 connectivity errors items0 node links
//
// swagger:model EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks
type EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response records items0 connectivity errors items0 node links
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response records items0 connectivity errors items0 node links based on the context it is used
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0ConnectivityErrorsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0FiltersItems0 ems destination response records items0 filters items0
//
// swagger:model EmsDestinationResponseRecordsItems0FiltersItems0
type EmsDestinationResponseRecordsItems0FiltersItems0 struct {

	// links
	Links *EmsDestinationResponseRecordsItems0FiltersItems0Links `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination response records items0 filters items0
func (m *EmsDestinationResponseRecordsItems0FiltersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0FiltersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response records items0 filters items0 based on the context it is used
func (m *EmsDestinationResponseRecordsItems0FiltersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0FiltersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0FiltersItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0FiltersItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0FiltersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseRecordsItems0FiltersItems0Links ems destination response records items0 filters items0 links
//
// swagger:model EmsDestinationResponseRecordsItems0FiltersItems0Links
type EmsDestinationResponseRecordsItems0FiltersItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response records items0 filters items0 links
func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response records items0 filters items0 links based on the context it is used
func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseRecordsItems0FiltersItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseRecordsItems0FiltersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks ems destination response inline records inline array item inline links
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline__links
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline links
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline links based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog ems destination response inline records inline array item inline syslog
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_syslog
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog struct {

	// format
	Format *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat `json:"format,omitempty"`

	// Syslog Port.
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Syslog Transport Protocol.
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Transport *string `json:"transport,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline syslog
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	if m.Format != nil {
		if err := m.Format.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// udp_unencrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportUDPUnencrypted captures enum value "udp_unencrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// tcp_unencrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPUnencrypted captures enum value "tcp_unencrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// tcp_encrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPEncrypted captures enum value "tcp_encrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateTransportEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(m.Transport) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransportEnum("syslog"+"."+"transport", "body", *m.Transport); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline syslog based on the context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if m.Format != nil {
		if err := m.Format.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat ems destination response inline records inline array item inline syslog inline format
//
// swagger:model ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat struct {

	// Syslog Hostname Format Override. The supported hostname formats are no_override (hostname format based on the syslog.format.message property i.e. fqdn if syslog.format.message is rfc_5424, hostname_only if syslog.format.message is legacy_netapp), fqdn (Fully Qualified Domain Name) and hostname_only.
	//
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameOverride *string `json:"hostname_override,omitempty"`

	// Syslog Message Format. The supported message formats are legacy_netapp (format: &lt;PRIVAL&gt;TIMESTAMP [HOSTNAME:Event-name:Event-severity]: MSG) and rfc_5424 (format: &lt;PRIVAL&gt;VERSION TIMESTAMP HOSTNAME Event-source - Event-name - MSG).
	//
	// Enum: ["legacy_netapp","rfc_5424"]
	Message *string `json:"message,omitempty"`

	// Syslog Timestamp Format Override. The supported timestamp formats are no_override (timestamp format based on the syslog.format.message property i.e. rfc_3164 if syslog.format.message is legacy_netapp, iso_8601_local_time if syslog.format.message is rfc_5424), rfc_3164 (format: Mmm dd hh:mm:ss), iso_8601_local_time (format: YYYY-MM-DDThh:mm:ss+/-hh:mm) and iso_8601_utc (format: YYYY-MM-DDThh:mm:ssZ).
	//
	// Enum: ["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]
	TimestampOverride *string `json:"timestamp_override,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline syslog inline format
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostnameOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideNoOverride captures enum value "no_override"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// fqdn
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideFqdn captures enum value "fqdn"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// hostname_only
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideHostnameOnly captures enum value "hostname_only"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateHostnameOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateHostnameOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.HostnameOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateHostnameOverrideEnum("syslog"+"."+"format"+"."+"hostname_override", "body", *m.HostnameOverride); err != nil {
		return err
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// message
	// Message
	// legacy_netapp
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageLegacyNetapp captures enum value "legacy_netapp"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// message
	// Message
	// rfc_5424
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageRfc5424 captures enum value "rfc_5424"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageRfc5424 string = "rfc_5424"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("syslog"+"."+"format"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideNoOverride captures enum value "no_override"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// rfc_3164
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideRfc3164 captures enum value "rfc_3164"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_local_time
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime string = "iso_8601_local_time"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_utc
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601Utc captures enum value "iso_8601_utc"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601Utc string = "iso_8601_utc"
)

// prop value enum
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateTimestampOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateTimestampOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.TimestampOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateTimestampOverrideEnum("syslog"+"."+"format"+"."+"timestamp_override", "body", *m.TimestampOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ems destination response inline records inline array item inline syslog inline format based on context it is used
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
