// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsEventAction ems event action
//
// swagger:model ems_event_action
type EmsEventAction struct {

	// confirmation message
	ConfirmationMessage *EmsEventActionInlineConfirmationMessage `json:"confirmation_message,omitempty"`

	// description
	Description *EmsEventActionInlineDescription `json:"description,omitempty"`

	// Parameter list for the action.
	// Read Only: true
	EmsEventActionInlineParameters []*EmsEventActionInlineParametersInlineArrayItem `json:"parameters,omitempty"`

	// JSON object describing the structure of the request body if arguments must be
	// provided in the body when invoking the action.
	// A JSON string value that takes the form of {parameter-name} must be substituted by user input
	// values encoded as the appropriate JSON type.
	// The following table gives examples where the parameter type is a string, an integer, and
	// an array:
	// | request_body_template value | parameter value              | request body                    |
	// | --------------------------- | ---------------------------- | ------------------------------- |
	// | {"name": "{user-name}"}     | user-name="Joe"              | {"name": "Joe"}                 |
	// | {"retry count": "{count}"}  | count=10                     | {"retry_count": 10}             |
	// | {"domains": "{dns-names}"}  | dns-names=["dns-1", "dns-2"] | {"domains": ["dns-1", "dns-2"]} |
	// Only JSON string values that start with a '{' and end with a '}' should be considered
	// for parameter substitutions. A JSON string value such as "{user-name} is the syntax" should
	// be treated as a literal string with no parameter substitution to be performed.
	// Double curly braces '{{' and '}}' are used to escape parameter substitutions, therefore double
	// curly braces must be converted to single curly braces.
	// For example, "{{user-name}}" is converted to the JSON string value "{user-name}".
	// Note that this rule only applies if a JSON string starts with '{{' and ends with '}}'.
	// The following table provides examples of when parameter substitutions must not be performed:
	// | request_body_template value       | request body                     |
	// | --------------------------------- | -------------------------------- |
	// | {"name": "{user-name} is bad"}    | {"name": "{user-name} is bad"}   |
	// | {"name": "{{user-name}}"}         | {"name": "{user-name}"}          |
	// | {"name": "{{user-name}} is bad"}  | {"name": "{{user-name}} is bad"} |
	// | {"name": "{{{{user-name}}}}"}     | {"name": "{{user-name}}"}        |
	//
	// Read Only: true
	EmsEventActionInlineRequestBodyTemplate interface{} `json:"request_body_template,omitempty"`

	// URI on which to perform the action, using the HTTP method specified in the method property.
	// Example: /api/resourcelink
	// Read Only: true
	Href *string `json:"href,omitempty"`

	// HTTP verb, such as PATCH, POST, used to perform the action.
	// Example: PATCH
	// Read Only: true
	Method *string `json:"method,omitempty"`

	// Name of the action.
	// Example: schedule
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// title
	Title *EmsEventActionInlineTitle `json:"title,omitempty"`
}

// Validate validates this ems event action
func (m *EmsEventAction) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfirmationMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsEventActionInlineParameters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTitle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventAction) validateConfirmationMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfirmationMessage) { // not required
		return nil
	}

	if m.ConfirmationMessage != nil {
		if err := m.ConfirmationMessage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("confirmation_message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventAction) validateDescription(formats strfmt.Registry) error {
	if swag.IsZero(m.Description) { // not required
		return nil
	}

	if m.Description != nil {
		if err := m.Description.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("description")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventAction) validateEmsEventActionInlineParameters(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsEventActionInlineParameters) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsEventActionInlineParameters); i++ {
		if swag.IsZero(m.EmsEventActionInlineParameters[i]) { // not required
			continue
		}

		if m.EmsEventActionInlineParameters[i] != nil {
			if err := m.EmsEventActionInlineParameters[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventAction) validateTitle(formats strfmt.Registry) error {
	if swag.IsZero(m.Title) { // not required
		return nil
	}

	if m.Title != nil {
		if err := m.Title.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("title")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems event action based on the context it is used
func (m *EmsEventAction) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfirmationMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsEventActionInlineParameters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHref(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMethod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTitle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventAction) contextValidateConfirmationMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfirmationMessage != nil {
		if err := m.ConfirmationMessage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("confirmation_message")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventAction) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if m.Description != nil {
		if err := m.Description.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("description")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventAction) contextValidateEmsEventActionInlineParameters(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "parameters", "body", []*EmsEventActionInlineParametersInlineArrayItem(m.EmsEventActionInlineParameters)); err != nil {
		return err
	}

	for i := 0; i < len(m.EmsEventActionInlineParameters); i++ {

		if m.EmsEventActionInlineParameters[i] != nil {
			if err := m.EmsEventActionInlineParameters[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventAction) contextValidateHref(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "href", "body", m.Href); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventAction) contextValidateMethod(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "method", "body", m.Method); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventAction) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventAction) contextValidateTitle(ctx context.Context, formats strfmt.Registry) error {

	if m.Title != nil {
		if err := m.Title.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("title")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventAction) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventAction) UnmarshalBinary(b []byte) error {
	var res EmsEventAction
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineConfirmationMessage Confirmation message that is presented in user facing applications, confirming the action to take.
//
// swagger:model ems_event_action_inline_confirmation_message
type EmsEventActionInlineConfirmationMessage struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionConfirmationMessageArgumentsItems0 `json:"arguments,omitempty"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline confirmation message
func (m *EmsEventActionInlineConfirmationMessage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineConfirmationMessage) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("confirmation_message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline confirmation message based on the context it is used
func (m *EmsEventActionInlineConfirmationMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineConfirmationMessage) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "confirmation_message"+"."+"arguments", "body", []*EmsEventActionConfirmationMessageArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("confirmation_message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineConfirmationMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "confirmation_message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineConfirmationMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "confirmation_message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineConfirmationMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineConfirmationMessage) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineConfirmationMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionConfirmationMessageArgumentsItems0 ems event action confirmation message arguments items0
//
// swagger:model EmsEventActionConfirmationMessageArgumentsItems0
type EmsEventActionConfirmationMessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action confirmation message arguments items0
func (m *EmsEventActionConfirmationMessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action confirmation message arguments items0 based on the context it is used
func (m *EmsEventActionConfirmationMessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionConfirmationMessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionConfirmationMessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionConfirmationMessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionConfirmationMessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionConfirmationMessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineDescription Description of the action is presented in user facing applications.
//
// swagger:model ems_event_action_inline_description
type EmsEventActionInlineDescription struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionDescriptionArgumentsItems0 `json:"arguments,omitempty"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline description
func (m *EmsEventActionInlineDescription) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineDescription) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("description" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline description based on the context it is used
func (m *EmsEventActionInlineDescription) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineDescription) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"arguments", "body", []*EmsEventActionDescriptionArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("description" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineDescription) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineDescription) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineDescription) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineDescription) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineDescription
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionDescriptionArgumentsItems0 ems event action description arguments items0
//
// swagger:model EmsEventActionDescriptionArgumentsItems0
type EmsEventActionDescriptionArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action description arguments items0
func (m *EmsEventActionDescriptionArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action description arguments items0 based on the context it is used
func (m *EmsEventActionDescriptionArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionDescriptionArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionDescriptionArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionDescriptionArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionDescriptionArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionDescriptionArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineParametersInlineArrayItem ems event action inline parameters inline array item
//
// swagger:model ems_event_action_inline_parameters_inline_array_item
type EmsEventActionInlineParametersInlineArrayItem struct {

	// description
	Description *EmsEventActionInlineParametersInlineArrayItemInlineDescription `json:"description,omitempty"`

	// If the type of the parameter is an array, this specifies the type of items in the form of a JSON object where other properties applicable to that type can be included.
	// Example: {"format":"date-time","type":"string"}
	// Read Only: true
	EmsEventActionInlineParametersInlineArrayItemInlineItems interface{} `json:"items,omitempty"`

	// If the type of the parameter is an object, this specifies what properties make up the object in the form of a JSON array where multiple parameters can be embedded within a single parameter. It is primarily used as a schema for an array type parameter.
	// Example: [{"format":"date-time","name":"start-date","type":"string"},{"format":"date-time","name":"end-date","type":"string"}]
	// Read Only: true
	EmsEventActionInlineParametersInlineArrayItemInlineProperties interface{} `json:"properties,omitempty"`

	// Specifies the current value(s) for the parameter encoded in the appropriate JSON type.
	// Read Only: true
	EmsEventActionInlineParametersInlineArrayItemInlineValue interface{} `json:"value,omitempty"`

	// Specifies the possible values of the parameter.
	// Example: ["value-1","value-2"]
	// Read Only: true
	Enum []*string `json:"enum"`

	// Specifies whether the "maximum" value is excluded in the parameter value range.
	// Read Only: true
	ExclusiveMaximum *bool `json:"exclusiveMaximum,omitempty"`

	// Specifies whether the "minimum" value is excluded in the parameter value range.
	// Read Only: true
	ExclusiveMinimum *bool `json:"exclusiveMinimum,omitempty"`

	// An optional modifier that serves as a hint at the content and format of the parameter.
	// Example: date-time
	// Read Only: true
	Format *string `json:"format,omitempty"`

	// help
	Help *EmsEventActionInlineParametersInlineArrayItemInlineHelp `json:"help,omitempty"`

	// Specifies where the parameter is placed when invoking the action.
	// Example: body
	// Read Only: true
	// Enum: ["body","query"]
	In *string `json:"in,omitempty"`

	// Specifies the maximum length of an array type parameter.
	// Read Only: true
	MaxItems *int64 `json:"maxItems,omitempty"`

	// Specifies the maximum length of a string type parameter.
	// Read Only: true
	MaxLength *int64 `json:"maxLength,omitempty"`

	// Specifies the maximum value of the parameter.
	// Read Only: true
	Maximum *int64 `json:"maximum,omitempty"`

	// Specifies the minimum length of an array type parameter.
	// Read Only: true
	MinItems *int64 `json:"minItems,omitempty"`

	// Specifies the minimum length of a string type parameter.
	// Read Only: true
	MinLength *int64 `json:"minLength,omitempty"`

	// Specifies the minimum value of the parameter.
	// Read Only: true
	Minimum *int64 `json:"minimum,omitempty"`

	// Specifies that a number type parameter must be the multiple of this number.
	// Read Only: true
	MultipleOf *float64 `json:"multipleOf,omitempty"`

	// Parameter name.
	// Example: schedule-at
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// By default, all properties of an object type parameter are mandatory. This property specifies the list of optional properties.
	// Example: ["end-time"]
	// Read Only: true
	Optional []*string `json:"optional"`

	// Specifies a regular expression template for a string type parameter.
	// Read Only: true
	Pattern *string `json:"pattern,omitempty"`

	// title
	Title *EmsEventActionInlineParametersInlineArrayItemInlineTitle `json:"title,omitempty"`

	// Parameter type.
	// Example: string
	// Read Only: true
	// Enum: ["string","number","integer","boolean","array","object"]
	Type *string `json:"type,omitempty"`

	// Specifies whether the "maximum" value is excluded in the parameter value range.
	// Read Only: true
	UniqueItems *bool `json:"uniqueItems,omitempty"`

	// validation error message
	ValidationErrorMessage *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage `json:"validation_error_message,omitempty"`
}

// Validate validates this ems event action inline parameters inline array item
func (m *EmsEventActionInlineParametersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHelp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTitle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValidationErrorMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateDescription(formats strfmt.Registry) error {
	if swag.IsZero(m.Description) { // not required
		return nil
	}

	if m.Description != nil {
		if err := m.Description.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("description")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateHelp(formats strfmt.Registry) error {
	if swag.IsZero(m.Help) { // not required
		return nil
	}

	if m.Help != nil {
		if err := m.Help.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("help")
			}
			return err
		}
	}

	return nil
}

var emsEventActionInlineParametersInlineArrayItemTypeInPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["body","query"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsEventActionInlineParametersInlineArrayItemTypeInPropEnum = append(emsEventActionInlineParametersInlineArrayItemTypeInPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// in
	// In
	// body
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemInBody captures enum value "body"
	EmsEventActionInlineParametersInlineArrayItemInBody string = "body"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// in
	// In
	// query
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemInQuery captures enum value "query"
	EmsEventActionInlineParametersInlineArrayItemInQuery string = "query"
)

// prop value enum
func (m *EmsEventActionInlineParametersInlineArrayItem) validateInEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsEventActionInlineParametersInlineArrayItemTypeInPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateIn(formats strfmt.Registry) error {
	if swag.IsZero(m.In) { // not required
		return nil
	}

	// value enum
	if err := m.validateInEnum("in", "body", *m.In); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateTitle(formats strfmt.Registry) error {
	if swag.IsZero(m.Title) { // not required
		return nil
	}

	if m.Title != nil {
		if err := m.Title.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("title")
			}
			return err
		}
	}

	return nil
}

var emsEventActionInlineParametersInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["string","number","integer","boolean","array","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsEventActionInlineParametersInlineArrayItemTypeTypePropEnum = append(emsEventActionInlineParametersInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// string
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeString captures enum value "string"
	EmsEventActionInlineParametersInlineArrayItemTypeString string = "string"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// number
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeNumber captures enum value "number"
	EmsEventActionInlineParametersInlineArrayItemTypeNumber string = "number"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// integer
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeInteger captures enum value "integer"
	EmsEventActionInlineParametersInlineArrayItemTypeInteger string = "integer"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// boolean
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeBoolean captures enum value "boolean"
	EmsEventActionInlineParametersInlineArrayItemTypeBoolean string = "boolean"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// array
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeArray captures enum value "array"
	EmsEventActionInlineParametersInlineArrayItemTypeArray string = "array"

	// BEGIN DEBUGGING
	// ems_event_action_inline_parameters_inline_array_item
	// EmsEventActionInlineParametersInlineArrayItem
	// type
	// Type
	// object
	// END DEBUGGING
	// EmsEventActionInlineParametersInlineArrayItemTypeObject captures enum value "object"
	EmsEventActionInlineParametersInlineArrayItemTypeObject string = "object"
)

// prop value enum
func (m *EmsEventActionInlineParametersInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsEventActionInlineParametersInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) validateValidationErrorMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.ValidationErrorMessage) { // not required
		return nil
	}

	if m.ValidationErrorMessage != nil {
		if err := m.ValidationErrorMessage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("validation_error_message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems event action inline parameters inline array item based on the context it is used
func (m *EmsEventActionInlineParametersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExclusiveMaximum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExclusiveMinimum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHelp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxLength(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaximum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinLength(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinimum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMultipleOf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOptional(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePattern(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTitle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUniqueItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateValidationErrorMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if m.Description != nil {
		if err := m.Description.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("description")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateEnum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enum", "body", []*string(m.Enum)); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateExclusiveMaximum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "exclusiveMaximum", "body", m.ExclusiveMaximum); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateExclusiveMinimum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "exclusiveMinimum", "body", m.ExclusiveMinimum); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateHelp(ctx context.Context, formats strfmt.Registry) error {

	if m.Help != nil {
		if err := m.Help.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("help")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateIn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "in", "body", m.In); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMaxItems(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "maxItems", "body", m.MaxItems); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMaxLength(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "maxLength", "body", m.MaxLength); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMaximum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "maximum", "body", m.Maximum); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMinItems(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "minItems", "body", m.MinItems); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMinLength(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "minLength", "body", m.MinLength); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMinimum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "minimum", "body", m.Minimum); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateMultipleOf(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "multipleOf", "body", m.MultipleOf); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateOptional(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "optional", "body", []*string(m.Optional)); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidatePattern(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "pattern", "body", m.Pattern); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateTitle(ctx context.Context, formats strfmt.Registry) error {

	if m.Title != nil {
		if err := m.Title.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("title")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateUniqueItems(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uniqueItems", "body", m.UniqueItems); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItem) contextValidateValidationErrorMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.ValidationErrorMessage != nil {
		if err := m.ValidationErrorMessage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("validation_error_message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineParametersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineParametersInlineArrayItemInlineDescription Description of the parameter that is presented in user facing applications.
//
// swagger:model ems_event_action_inline_parameters_inline_array_item_inline_description
type EmsEventActionInlineParametersInlineArrayItemInlineDescription struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionParametersItems0DescriptionArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline parameters inline array item inline description
func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("description" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline parameters inline array item inline description based on the context it is used
func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"arguments", "body", []*EmsEventActionParametersItems0DescriptionArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("description" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineDescription) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineParametersInlineArrayItemInlineDescription
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionParametersItems0DescriptionArgumentsItems0 ems event action parameters items0 description arguments items0
//
// swagger:model EmsEventActionParametersItems0DescriptionArgumentsItems0
type EmsEventActionParametersItems0DescriptionArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action parameters items0 description arguments items0
func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action parameters items0 description arguments items0 based on the context it is used
func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionParametersItems0DescriptionArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionParametersItems0DescriptionArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineParametersInlineArrayItemInlineHelp Help message of the parameter that is presented in user facing applications.
//
// swagger:model ems_event_action_inline_parameters_inline_array_item_inline_help
type EmsEventActionInlineParametersInlineArrayItemInlineHelp struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionParametersItems0HelpArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline parameters inline array item inline help
func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("help" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline parameters inline array item inline help based on the context it is used
func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "help"+"."+"arguments", "body", []*EmsEventActionParametersItems0HelpArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("help" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "help"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "help"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineHelp) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineParametersInlineArrayItemInlineHelp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionParametersItems0HelpArgumentsItems0 ems event action parameters items0 help arguments items0
//
// swagger:model EmsEventActionParametersItems0HelpArgumentsItems0
type EmsEventActionParametersItems0HelpArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action parameters items0 help arguments items0
func (m *EmsEventActionParametersItems0HelpArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action parameters items0 help arguments items0 based on the context it is used
func (m *EmsEventActionParametersItems0HelpArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionParametersItems0HelpArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionParametersItems0HelpArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionParametersItems0HelpArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionParametersItems0HelpArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionParametersItems0HelpArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineParametersInlineArrayItemInlineTitle Title of the parameter that is presented in user facing applications.
//
// swagger:model ems_event_action_inline_parameters_inline_array_item_inline_title
type EmsEventActionInlineParametersInlineArrayItemInlineTitle struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionParametersItems0TitleArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline parameters inline array item inline title
func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("title" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline parameters inline array item inline title based on the context it is used
func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"arguments", "body", []*EmsEventActionParametersItems0TitleArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("title" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineTitle) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineParametersInlineArrayItemInlineTitle
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionParametersItems0TitleArgumentsItems0 ems event action parameters items0 title arguments items0
//
// swagger:model EmsEventActionParametersItems0TitleArgumentsItems0
type EmsEventActionParametersItems0TitleArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action parameters items0 title arguments items0
func (m *EmsEventActionParametersItems0TitleArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action parameters items0 title arguments items0 based on the context it is used
func (m *EmsEventActionParametersItems0TitleArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionParametersItems0TitleArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionParametersItems0TitleArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionParametersItems0TitleArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionParametersItems0TitleArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionParametersItems0TitleArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage Error message that is presented in user facing applications, in cases where parameter validation fails.
//
// swagger:model ems_event_action_inline_parameters_inline_array_item_inline_validation_error_message
type EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline parameters inline array item inline validation error message
func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("validation_error_message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline parameters inline array item inline validation error message based on the context it is used
func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "validation_error_message"+"."+"arguments", "body", []*EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("validation_error_message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "validation_error_message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "validation_error_message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineParametersInlineArrayItemInlineValidationErrorMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0 ems event action parameters items0 validation error message arguments items0
//
// swagger:model EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0
type EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action parameters items0 validation error message arguments items0
func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action parameters items0 validation error message arguments items0 based on the context it is used
func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionParametersItems0ValidationErrorMessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionInlineTitle Title of the action that is presented in user facing applications.
//
// swagger:model ems_event_action_inline_title
type EmsEventActionInlineTitle struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsEventActionTitleArgumentsItems0 `json:"arguments,omitempty"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action inline title
func (m *EmsEventActionInlineTitle) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineTitle) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("title" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems event action inline title based on the context it is used
func (m *EmsEventActionInlineTitle) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionInlineTitle) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"arguments", "body", []*EmsEventActionTitleArgumentsItems0(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("title" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsEventActionInlineTitle) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionInlineTitle) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "title"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionInlineTitle) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionInlineTitle) UnmarshalBinary(b []byte) error {
	var res EmsEventActionInlineTitle
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventActionTitleArgumentsItems0 ems event action title arguments items0
//
// swagger:model EmsEventActionTitleArgumentsItems0
type EmsEventActionTitleArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems event action title arguments items0
func (m *EmsEventActionTitleArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems event action title arguments items0 based on the context it is used
func (m *EmsEventActionTitleArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventActionTitleArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventActionTitleArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventActionTitleArgumentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventActionTitleArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsEventActionTitleArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
