// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsEventMessage ems event message
//
// swagger:model ems_event_message
type EmsEventMessage struct {

	// links
	Links *EmsEventMessageInlineLinks `json:"_links,omitempty"`

	// Message name of the event. Returned by default.
	// Example: callhome.spares.low
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Severity of the event. Returned by default.
	// Example: emergency
	// Read Only: true
	// Enum: ["emergency","alert","error","notice","informational","debug"]
	Severity *string `json:"severity,omitempty"`
}

// Validate validates this ems event message
func (m *EmsEventMessage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventMessage) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var emsEventMessageTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["emergency","alert","error","notice","informational","debug"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsEventMessageTypeSeverityPropEnum = append(emsEventMessageTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// emergency
	// END DEBUGGING
	// EmsEventMessageSeverityEmergency captures enum value "emergency"
	EmsEventMessageSeverityEmergency string = "emergency"

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// alert
	// END DEBUGGING
	// EmsEventMessageSeverityAlert captures enum value "alert"
	EmsEventMessageSeverityAlert string = "alert"

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// error
	// END DEBUGGING
	// EmsEventMessageSeverityError captures enum value "error"
	EmsEventMessageSeverityError string = "error"

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// EmsEventMessageSeverityNotice captures enum value "notice"
	EmsEventMessageSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// informational
	// END DEBUGGING
	// EmsEventMessageSeverityInformational captures enum value "informational"
	EmsEventMessageSeverityInformational string = "informational"

	// BEGIN DEBUGGING
	// ems_event_message
	// EmsEventMessage
	// severity
	// Severity
	// debug
	// END DEBUGGING
	// EmsEventMessageSeverityDebug captures enum value "debug"
	EmsEventMessageSeverityDebug string = "debug"
)

// prop value enum
func (m *EmsEventMessage) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsEventMessageTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsEventMessage) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems event message based on the context it is used
func (m *EmsEventMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSeverity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventMessage) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsEventMessage) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *EmsEventMessage) contextValidateSeverity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "severity", "body", m.Severity); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventMessage) UnmarshalBinary(b []byte) error {
	var res EmsEventMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsEventMessageInlineLinks ems event message inline links
//
// swagger:model ems_event_message_inline__links
type EmsEventMessageInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems event message inline links
func (m *EmsEventMessageInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventMessageInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems event message inline links based on the context it is used
func (m *EmsEventMessageInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsEventMessageInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsEventMessageInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsEventMessageInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsEventMessageInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
