// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsFilter ems filter
//
// swagger:model ems_filter
type EmsFilter struct {

	// links
	Links *EmsFilterInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *EmsFilterInlineAccessControlRole `json:"access_control_role,omitempty"`

	// Array of event filter rules on which to match.
	EmsFilterInlineRules []*EmsFilterInlineRulesInlineArrayItem `json:"rules,omitempty"`

	// Filter name
	// Example: wafl-critical-events
	Name *string `json:"name,omitempty"`

	// Flag indicating system-defined filters.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this ems filter
func (m *EmsFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsFilterInlineRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilter) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControlRole) { // not required
		return nil
	}

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilter) validateEmsFilterInlineRules(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsFilterInlineRules) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsFilterInlineRules); i++ {
		if swag.IsZero(m.EmsFilterInlineRules[i]) { // not required
			continue
		}

		if m.EmsFilterInlineRules[i] != nil {
			if err := m.EmsFilterInlineRules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter based on the context it is used
func (m *EmsFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsFilterInlineRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilter) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilter) contextValidateEmsFilterInlineRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsFilterInlineRules); i++ {

		if m.EmsFilterInlineRules[i] != nil {
			if err := m.EmsFilterInlineRules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsFilter) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", m.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilter) UnmarshalBinary(b []byte) error {
	var res EmsFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineAccessControlRole Indicates the access control role that created the event filter and is used to control access to the filter based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
//
// swagger:model ems_filter_inline_access_control_role
type EmsFilterInlineAccessControlRole struct {

	// links
	Links *EmsFilterInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems filter inline access control role
func (m *EmsFilterInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline access control role based on the context it is used
func (m *EmsFilterInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineAccessControlRoleInlineLinks ems filter inline access control role inline links
//
// swagger:model ems_filter_inline_access_control_role_inline__links
type EmsFilterInlineAccessControlRoleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter inline access control role inline links
func (m *EmsFilterInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline access control role inline links based on the context it is used
func (m *EmsFilterInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineLinks ems filter inline links
//
// swagger:model ems_filter_inline__links
type EmsFilterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter inline links
func (m *EmsFilterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline links based on the context it is used
func (m *EmsFilterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineRulesInlineArrayItem Rule for an event filter
//
// swagger:model ems_filter_inline_rules_inline_array_item
type EmsFilterInlineRulesInlineArrayItem struct {

	// links
	Links *EmsFilterInlineRulesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterRulesItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter inline rules inline array item
func (m *EmsFilterInlineRulesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.MessageCriteria) { // not required
		return nil
	}

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(m.ParameterCriteria); i++ {
		if swag.IsZero(m.ParameterCriteria[i]) { // not required
			continue
		}

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterInlineRulesInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterInlineRulesInlineArrayItemTypeTypePropEnum = append(emsFilterInlineRulesInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_filter_inline_rules_inline_array_item
	// EmsFilterInlineRulesInlineArrayItem
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterInlineRulesInlineArrayItemTypeInclude captures enum value "include"
	EmsFilterInlineRulesInlineArrayItemTypeInclude string = "include"

	// BEGIN DEBUGGING
	// ems_filter_inline_rules_inline_array_item
	// EmsFilterInlineRulesInlineArrayItem
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterInlineRulesInlineArrayItemTypeExclude captures enum value "exclude"
	EmsFilterInlineRulesInlineArrayItemTypeExclude string = "exclude"
)

// prop value enum
func (m *EmsFilterInlineRulesInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterInlineRulesInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter inline rules inline array item based on the context it is used
func (m *EmsFilterInlineRulesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItem) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ParameterCriteria); i++ {

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineRulesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineRulesInlineArrayItemInlineLinks ems filter inline rules inline array item inline links
//
// swagger:model ems_filter_inline_rules_inline_array_item_inline__links
type EmsFilterInlineRulesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter inline rules inline array item inline links
func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline rules inline array item inline links based on the context it is used
func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineRulesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria Matching message definitions for the filter. A property must be specified.
//
// swagger:model ems_filter_inline_rules_inline_array_item_inline_message_criteria
type EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria struct {

	// links
	Links *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter inline rules inline array item inline message criteria
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline rules inline array item inline message criteria based on the context it is used
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineRulesInlineArrayItemInlineMessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks ems filter inline rules inline array item inline message criteria inline links
//
// swagger:model ems_filter_inline_rules_inline_array_item_inline_message_criteria_inline__links
type EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks struct {

	// related
	Related *Href `json:"related,omitempty"`
}

// Validate validates this ems filter inline rules inline array item inline message criteria inline links
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(m.Related) { // not required
		return nil
	}

	if m.Related != nil {
		if err := m.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter inline rules inline array item inline message criteria inline links based on the context it is used
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if m.Related != nil {
		if err := m.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterInlineRulesInlineArrayItemInlineMessageCriteriaInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRulesItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
//
// swagger:model EmsFilterRulesItems0ParameterCriteriaItems0
type EmsFilterRulesItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rules items0 parameter criteria items0
func (m *EmsFilterRulesItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rules items0 parameter criteria items0 based on context it is used
func (m *EmsFilterRulesItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRulesItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRulesItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterRulesItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
