// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsFilterResponse ems filter response
//
// swagger:model ems_filter_response
type EmsFilterResponse struct {

	// links
	Links *EmsFilterResponseInlineLinks `json:"_links,omitempty"`

	// ems filter response inline records
	EmsFilterResponseInlineRecords []*EmsFilterResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this ems filter response
func (m *EmsFilterResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsFilterResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponse) validateEmsFilterResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsFilterResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsFilterResponseInlineRecords); i++ {
		if swag.IsZero(m.EmsFilterResponseInlineRecords[i]) { // not required
			continue
		}

		if m.EmsFilterResponseInlineRecords[i] != nil {
			if err := m.EmsFilterResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter response based on the context it is used
func (m *EmsFilterResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsFilterResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponse) contextValidateEmsFilterResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsFilterResponseInlineRecords); i++ {

		if m.EmsFilterResponseInlineRecords[i] != nil {
			if err := m.EmsFilterResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponse) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseInlineLinks ems filter response inline links
//
// swagger:model ems_filter_response_inline__links
type EmsFilterResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter response inline links
func (m *EmsFilterResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline links based on the context it is used
func (m *EmsFilterResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseInlineRecordsInlineArrayItem ems filter response inline records inline array item
//
// swagger:model ems_filter_response_inline_records_inline_array_item
type EmsFilterResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// Filter name
	// Example: wafl-critical-events
	Name *string `json:"name,omitempty"`

	// Array of event filter rules on which to match.
	Rules []*EmsFilterResponseRecordsItems0RulesItems0 `json:"rules"`

	// Flag indicating system-defined filters.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this ems filter response inline records inline array item
func (m *EmsFilterResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControlRole) { // not required
		return nil
	}

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item based on the context it is used
func (m *EmsFilterResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessControlRole != nil {
		if err := m.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", m.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole Indicates the access control role that created the event filter and is used to control access to the filter based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
//
// swagger:model ems_filter_response_inline_records_inline_array_item_inline_access_control_role
type EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole struct {

	// links
	Links *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline access control role
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline access control role based on the context it is used
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks ems filter response inline records inline array item inline access control role inline links
//
// swagger:model ems_filter_response_inline_records_inline_array_item_inline_access_control_role_inline__links
type EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline access control role inline links
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline access control role inline links based on the context it is used
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks ems filter response inline records inline array item inline links
//
// swagger:model ems_filter_response_inline_records_inline_array_item_inline__links
type EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline links
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline links based on the context it is used
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseRecordsItems0RulesItems0 Rule for an event filter
//
// swagger:model EmsFilterResponseRecordsItems0RulesItems0
type EmsFilterResponseRecordsItems0RulesItems0 struct {

	// links
	Links *EmsFilterResponseRecordsItems0RulesItems0Links `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter response records items0 rules items0
func (m *EmsFilterResponseRecordsItems0RulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.MessageCriteria) { // not required
		return nil
	}

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(m.ParameterCriteria); i++ {
		if swag.IsZero(m.ParameterCriteria[i]) { // not required
			continue
		}

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterResponseRecordsItems0RulesItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterResponseRecordsItems0RulesItems0TypeTypePropEnum = append(emsFilterResponseRecordsItems0RulesItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsFilterResponseRecordsItems0RulesItems0
	// EmsFilterResponseRecordsItems0RulesItems0
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterResponseRecordsItems0RulesItems0TypeInclude captures enum value "include"
	EmsFilterResponseRecordsItems0RulesItems0TypeInclude string = "include"

	// BEGIN DEBUGGING
	// EmsFilterResponseRecordsItems0RulesItems0
	// EmsFilterResponseRecordsItems0RulesItems0
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterResponseRecordsItems0RulesItems0TypeExclude captures enum value "exclude"
	EmsFilterResponseRecordsItems0RulesItems0TypeExclude string = "exclude"
)

// prop value enum
func (m *EmsFilterResponseRecordsItems0RulesItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterResponseRecordsItems0RulesItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter response records items0 rules items0 based on the context it is used
func (m *EmsFilterResponseRecordsItems0RulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ParameterCriteria); i++ {

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseRecordsItems0RulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseRecordsItems0RulesItems0Links ems filter response records items0 rules items0 links
//
// swagger:model EmsFilterResponseRecordsItems0RulesItems0Links
type EmsFilterResponseRecordsItems0RulesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter response records items0 rules items0 links
func (m *EmsFilterResponseRecordsItems0RulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response records items0 rules items0 links based on the context it is used
func (m *EmsFilterResponseRecordsItems0RulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseRecordsItems0RulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseRecordsItems0RulesItems0MessageCriteria Matching message definitions for the filter. A property must be specified.
//
// swagger:model EmsFilterResponseRecordsItems0RulesItems0MessageCriteria
type EmsFilterResponseRecordsItems0RulesItems0MessageCriteria struct {

	// links
	Links *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter response records items0 rules items0 message criteria
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response records items0 rules items0 message criteria based on the context it is used
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseRecordsItems0RulesItems0MessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks ems filter response records items0 rules items0 message criteria links
//
// swagger:model EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks
type EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks struct {

	// related
	Related *Href `json:"related,omitempty"`
}

// Validate validates this ems filter response records items0 rules items0 message criteria links
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(m.Related) { // not required
		return nil
	}

	if m.Related != nil {
		if err := m.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response records items0 rules items0 message criteria links based on the context it is used
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if m.Related != nil {
		if err := m.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseRecordsItems0RulesItems0MessageCriteriaLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
//
// swagger:model EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0
type EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter response records items0 rules items0 parameter criteria items0
func (m *EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter response records items0 rules items0 parameter criteria items0 based on context it is used
func (m *EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseRecordsItems0RulesItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
