// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsFilterRule Rule for an event filter
//
// swagger:model ems_filter_rule
type EmsFilterRule struct {

	// links
	Links *EmsFilterRuleInlineLinks `json:"_links,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	EmsFilterRuleInlineParameterCriteria []*EmsFilterRuleInlineParameterCriteriaInlineArrayItem `json:"parameter_criteria,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterRuleInlineMessageCriteria `json:"message_criteria,omitempty"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter rule
func (m *EmsFilterRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsFilterRuleInlineParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRule) validateEmsFilterRuleInlineParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsFilterRuleInlineParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsFilterRuleInlineParameterCriteria); i++ {
		if swag.IsZero(m.EmsFilterRuleInlineParameterCriteria[i]) { // not required
			continue
		}

		if m.EmsFilterRuleInlineParameterCriteria[i] != nil {
			if err := m.EmsFilterRuleInlineParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsFilterRule) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.MessageCriteria) { // not required
		return nil
	}

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

var emsFilterRuleTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterRuleTypeTypePropEnum = append(emsFilterRuleTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_filter_rule
	// EmsFilterRule
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterRuleTypeInclude captures enum value "include"
	EmsFilterRuleTypeInclude string = "include"

	// BEGIN DEBUGGING
	// ems_filter_rule
	// EmsFilterRule
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterRuleTypeExclude captures enum value "exclude"
	EmsFilterRuleTypeExclude string = "exclude"
)

// prop value enum
func (m *EmsFilterRule) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterRuleTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsFilterRule) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter rule based on the context it is used
func (m *EmsFilterRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsFilterRuleInlineParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRule) contextValidateEmsFilterRuleInlineParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsFilterRuleInlineParameterCriteria); i++ {

		if m.EmsFilterRuleInlineParameterCriteria[i] != nil {
			if err := m.EmsFilterRuleInlineParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsFilterRule) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRule) UnmarshalBinary(b []byte) error {
	var res EmsFilterRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleInlineLinks ems filter rule inline links
//
// swagger:model ems_filter_rule_inline__links
type EmsFilterRuleInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter rule inline links
func (m *EmsFilterRuleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule inline links based on the context it is used
func (m *EmsFilterRuleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleInlineMessageCriteria Matching message definitions for the filter. A property must be specified.
//
// swagger:model ems_filter_rule_inline_message_criteria
type EmsFilterRuleInlineMessageCriteria struct {

	// links
	Links *EmsFilterRuleInlineMessageCriteriaInlineLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter rule inline message criteria
func (m *EmsFilterRuleInlineMessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineMessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule inline message criteria based on the context it is used
func (m *EmsFilterRuleInlineMessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineMessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleInlineMessageCriteria) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleInlineMessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleInlineMessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleInlineMessageCriteriaInlineLinks ems filter rule inline message criteria inline links
//
// swagger:model ems_filter_rule_inline_message_criteria_inline__links
type EmsFilterRuleInlineMessageCriteriaInlineLinks struct {

	// related
	Related *Href `json:"related,omitempty"`
}

// Validate validates this ems filter rule inline message criteria inline links
func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(m.Related) { // not required
		return nil
	}

	if m.Related != nil {
		if err := m.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule inline message criteria inline links based on the context it is used
func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if m.Related != nil {
		if err := m.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleInlineMessageCriteriaInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleInlineMessageCriteriaInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleInlineParameterCriteriaInlineArrayItem Criterion used for parameter based filtering
//
// swagger:model ems_filter_rule_inline_parameter_criteria_inline_array_item
type EmsFilterRuleInlineParameterCriteriaInlineArrayItem struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rule inline parameter criteria inline array item
func (m *EmsFilterRuleInlineParameterCriteriaInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rule inline parameter criteria inline array item based on context it is used
func (m *EmsFilterRuleInlineParameterCriteriaInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleInlineParameterCriteriaInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleInlineParameterCriteriaInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleInlineParameterCriteriaInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
