// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsFilterRuleResponse ems filter rule response
//
// swagger:model ems_filter_rule_response
type EmsFilterRuleResponse struct {

	// links
	Links *EmsFilterRuleResponseInlineLinks `json:"_links,omitempty"`

	// ems filter rule response inline records
	EmsFilterRuleResponseInlineRecords []*EmsFilterRuleResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this ems filter rule response
func (m *EmsFilterRuleResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmsFilterRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponse) validateEmsFilterRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsFilterRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsFilterRuleResponseInlineRecords); i++ {
		if swag.IsZero(m.EmsFilterRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if m.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := m.EmsFilterRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter rule response based on the context it is used
func (m *EmsFilterRuleResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsFilterRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponse) contextValidateEmsFilterRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.EmsFilterRuleResponseInlineRecords); i++ {

		if m.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := m.EmsFilterRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponse) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseInlineLinks ems filter rule response inline links
//
// swagger:model ems_filter_rule_response_inline__links
type EmsFilterRuleResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter rule response inline links
func (m *EmsFilterRuleResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline links based on the context it is used
func (m *EmsFilterRuleResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseInlineRecordsInlineArrayItem Rule for an event filter
//
// swagger:model ems_filter_rule_response_inline_records_inline_array_item
type EmsFilterRuleResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.MessageCriteria) { // not required
		return nil
	}

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(m.ParameterCriteria); i++ {
		if swag.IsZero(m.ParameterCriteria[i]) { // not required
			continue
		}

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_filter_rule_response_inline_records_inline_array_item
	// EmsFilterRuleResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeInclude captures enum value "include"
	EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeInclude string = "include"

	// BEGIN DEBUGGING
	// ems_filter_rule_response_inline_records_inline_array_item
	// EmsFilterRuleResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeExclude captures enum value "exclude"
	EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeExclude string = "exclude"
)

// prop value enum
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item based on the context it is used
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if m.MessageCriteria != nil {
		if err := m.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ParameterCriteria); i++ {

		if m.ParameterCriteria[i] != nil {
			if err := m.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks ems filter rule response inline records inline array item inline links
//
// swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline__links
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline links
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline links based on the context it is used
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria Matching message definitions for the filter. A property must be specified.
//
// swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline_message_criteria
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria struct {

	// links
	Links *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline message criteria
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline message criteria based on the context it is used
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks ems filter rule response inline records inline array item inline message criteria inline links
//
// swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline_message_criteria_inline__links
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks struct {

	// related
	Related *Href `json:"related,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline message criteria inline links
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(m.Related) { // not required
		return nil
	}

	if m.Related != nil {
		if err := m.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline message criteria inline links based on the context it is used
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if m.Related != nil {
		if err := m.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
//
// swagger:model EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0
type EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rule response records items0 parameter criteria items0
func (m *EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rule response records items0 parameter criteria items0 based on context it is used
func (m *EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseRecordsItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
