// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsMessage ems message
//
// swagger:model ems_message
type EmsMessage struct {

	// links
	Links *EmsMessageInlineLinks `json:"_links,omitempty"`

	// Corrective action
	// Read Only: true
	CorrectiveAction *string `json:"corrective_action,omitempty"`

	// Is deprecated?
	// Example: true
	// Read Only: true
	Deprecated *bool `json:"deprecated,omitempty"`

	// Description of the event.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// Name of the event.
	// Example: callhome.spares.low
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Severity
	// Example: error
	// Read Only: true
	// Enum: ["emergency","alert","error","notice","informational","debug"]
	Severity *string `json:"severity,omitempty"`

	// SNMP trap type
	// Example: standard
	// Read Only: true
	// Enum: ["standard","built_in","severity_based"]
	SnmpTrapType *string `json:"snmp_trap_type,omitempty"`
}

// Validate validates this ems message
func (m *EmsMessage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnmpTrapType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsMessage) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var emsMessageTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["emergency","alert","error","notice","informational","debug"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsMessageTypeSeverityPropEnum = append(emsMessageTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// emergency
	// END DEBUGGING
	// EmsMessageSeverityEmergency captures enum value "emergency"
	EmsMessageSeverityEmergency string = "emergency"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// alert
	// END DEBUGGING
	// EmsMessageSeverityAlert captures enum value "alert"
	EmsMessageSeverityAlert string = "alert"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// error
	// END DEBUGGING
	// EmsMessageSeverityError captures enum value "error"
	EmsMessageSeverityError string = "error"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// notice
	// END DEBUGGING
	// EmsMessageSeverityNotice captures enum value "notice"
	EmsMessageSeverityNotice string = "notice"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// informational
	// END DEBUGGING
	// EmsMessageSeverityInformational captures enum value "informational"
	EmsMessageSeverityInformational string = "informational"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// severity
	// Severity
	// debug
	// END DEBUGGING
	// EmsMessageSeverityDebug captures enum value "debug"
	EmsMessageSeverityDebug string = "debug"
)

// prop value enum
func (m *EmsMessage) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsMessageTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsMessage) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

var emsMessageTypeSnmpTrapTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["standard","built_in","severity_based"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsMessageTypeSnmpTrapTypePropEnum = append(emsMessageTypeSnmpTrapTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// snmp_trap_type
	// SnmpTrapType
	// standard
	// END DEBUGGING
	// EmsMessageSnmpTrapTypeStandard captures enum value "standard"
	EmsMessageSnmpTrapTypeStandard string = "standard"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// snmp_trap_type
	// SnmpTrapType
	// built_in
	// END DEBUGGING
	// EmsMessageSnmpTrapTypeBuiltIn captures enum value "built_in"
	EmsMessageSnmpTrapTypeBuiltIn string = "built_in"

	// BEGIN DEBUGGING
	// ems_message
	// EmsMessage
	// snmp_trap_type
	// SnmpTrapType
	// severity_based
	// END DEBUGGING
	// EmsMessageSnmpTrapTypeSeverityBased captures enum value "severity_based"
	EmsMessageSnmpTrapTypeSeverityBased string = "severity_based"
)

// prop value enum
func (m *EmsMessage) validateSnmpTrapTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsMessageTypeSnmpTrapTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsMessage) validateSnmpTrapType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnmpTrapType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnmpTrapTypeEnum("snmp_trap_type", "body", *m.SnmpTrapType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems message based on the context it is used
func (m *EmsMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCorrectiveAction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeprecated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSeverity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnmpTrapType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsMessage) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *EmsMessage) contextValidateCorrectiveAction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "corrective_action", "body", m.CorrectiveAction); err != nil {
		return err
	}

	return nil
}

func (m *EmsMessage) contextValidateDeprecated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "deprecated", "body", m.Deprecated); err != nil {
		return err
	}

	return nil
}

func (m *EmsMessage) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *EmsMessage) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *EmsMessage) contextValidateSeverity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "severity", "body", m.Severity); err != nil {
		return err
	}

	return nil
}

func (m *EmsMessage) contextValidateSnmpTrapType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snmp_trap_type", "body", m.SnmpTrapType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsMessage) UnmarshalBinary(b []byte) error {
	var res EmsMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsMessageInlineLinks ems message inline links
//
// swagger:model ems_message_inline__links
type EmsMessageInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ems message inline links
func (m *EmsMessageInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsMessageInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems message inline links based on the context it is used
func (m *EmsMessageInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsMessageInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsMessageInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsMessageInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsMessageInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
