// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsSyslog ems syslog
//
// swagger:model ems_syslog
type EmsSyslog struct {

	// format
	Format *EmsSyslogInlineFormat `json:"format,omitempty"`

	// Syslog Port.
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Syslog Transport Protocol.
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Transport *string `json:"transport,omitempty"`
}

// Validate validates this ems syslog
func (m *EmsSyslog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsSyslog) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	if m.Format != nil {
		if err := m.Format.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("format")
			}
			return err
		}
	}

	return nil
}

var emsSyslogTypeTransportPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsSyslogTypeTransportPropEnum = append(emsSyslogTypeTransportPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_syslog
	// EmsSyslog
	// transport
	// Transport
	// udp_unencrypted
	// END DEBUGGING
	// EmsSyslogTransportUDPUnencrypted captures enum value "udp_unencrypted"
	EmsSyslogTransportUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// ems_syslog
	// EmsSyslog
	// transport
	// Transport
	// tcp_unencrypted
	// END DEBUGGING
	// EmsSyslogTransportTCPUnencrypted captures enum value "tcp_unencrypted"
	EmsSyslogTransportTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// ems_syslog
	// EmsSyslog
	// transport
	// Transport
	// tcp_encrypted
	// END DEBUGGING
	// EmsSyslogTransportTCPEncrypted captures enum value "tcp_encrypted"
	EmsSyslogTransportTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (m *EmsSyslog) validateTransportEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsSyslogTypeTransportPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsSyslog) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(m.Transport) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransportEnum("transport", "body", *m.Transport); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems syslog based on the context it is used
func (m *EmsSyslog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsSyslog) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if m.Format != nil {
		if err := m.Format.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("format")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsSyslog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsSyslog) UnmarshalBinary(b []byte) error {
	var res EmsSyslog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsSyslogInlineFormat ems syslog inline format
//
// swagger:model ems_syslog_inline_format
type EmsSyslogInlineFormat struct {

	// Syslog Hostname Format Override. The supported hostname formats are no_override (hostname format based on the syslog.format.message property i.e. fqdn if syslog.format.message is rfc_5424, hostname_only if syslog.format.message is legacy_netapp), fqdn (Fully Qualified Domain Name) and hostname_only.
	//
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameOverride *string `json:"hostname_override,omitempty"`

	// Syslog Message Format. The supported message formats are legacy_netapp (format: &lt;PRIVAL&gt;TIMESTAMP [HOSTNAME:Event-name:Event-severity]: MSG) and rfc_5424 (format: &lt;PRIVAL&gt;VERSION TIMESTAMP HOSTNAME Event-source - Event-name - MSG).
	//
	// Enum: ["legacy_netapp","rfc_5424"]
	Message *string `json:"message,omitempty"`

	// Syslog Timestamp Format Override. The supported timestamp formats are no_override (timestamp format based on the syslog.format.message property i.e. rfc_3164 if syslog.format.message is legacy_netapp, iso_8601_local_time if syslog.format.message is rfc_5424), rfc_3164 (format: Mmm dd hh:mm:ss), iso_8601_local_time (format: YYYY-MM-DDThh:mm:ss+/-hh:mm) and iso_8601_utc (format: YYYY-MM-DDThh:mm:ssZ).
	//
	// Enum: ["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]
	TimestampOverride *string `json:"timestamp_override,omitempty"`
}

// Validate validates this ems syslog inline format
func (m *EmsSyslogInlineFormat) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostnameOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var emsSyslogInlineFormatTypeHostnameOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsSyslogInlineFormatTypeHostnameOverridePropEnum = append(emsSyslogInlineFormatTypeHostnameOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// no_override
	// END DEBUGGING
	// EmsSyslogInlineFormatHostnameOverrideNoOverride captures enum value "no_override"
	EmsSyslogInlineFormatHostnameOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// fqdn
	// END DEBUGGING
	// EmsSyslogInlineFormatHostnameOverrideFqdn captures enum value "fqdn"
	EmsSyslogInlineFormatHostnameOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// hostname_only
	// END DEBUGGING
	// EmsSyslogInlineFormatHostnameOverrideHostnameOnly captures enum value "hostname_only"
	EmsSyslogInlineFormatHostnameOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (m *EmsSyslogInlineFormat) validateHostnameOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsSyslogInlineFormatTypeHostnameOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsSyslogInlineFormat) validateHostnameOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.HostnameOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateHostnameOverrideEnum("format"+"."+"hostname_override", "body", *m.HostnameOverride); err != nil {
		return err
	}

	return nil
}

var emsSyslogInlineFormatTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsSyslogInlineFormatTypeMessagePropEnum = append(emsSyslogInlineFormatTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// message
	// Message
	// legacy_netapp
	// END DEBUGGING
	// EmsSyslogInlineFormatMessageLegacyNetapp captures enum value "legacy_netapp"
	EmsSyslogInlineFormatMessageLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// message
	// Message
	// rfc_5424
	// END DEBUGGING
	// EmsSyslogInlineFormatMessageRfc5424 captures enum value "rfc_5424"
	EmsSyslogInlineFormatMessageRfc5424 string = "rfc_5424"
)

// prop value enum
func (m *EmsSyslogInlineFormat) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsSyslogInlineFormatTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsSyslogInlineFormat) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("format"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

var emsSyslogInlineFormatTypeTimestampOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsSyslogInlineFormatTypeTimestampOverridePropEnum = append(emsSyslogInlineFormatTypeTimestampOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// no_override
	// END DEBUGGING
	// EmsSyslogInlineFormatTimestampOverrideNoOverride captures enum value "no_override"
	EmsSyslogInlineFormatTimestampOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// rfc_3164
	// END DEBUGGING
	// EmsSyslogInlineFormatTimestampOverrideRfc3164 captures enum value "rfc_3164"
	EmsSyslogInlineFormatTimestampOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_local_time
	// END DEBUGGING
	// EmsSyslogInlineFormatTimestampOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	EmsSyslogInlineFormatTimestampOverrideIso8601LocalTime string = "iso_8601_local_time"

	// BEGIN DEBUGGING
	// ems_syslog_inline_format
	// EmsSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_utc
	// END DEBUGGING
	// EmsSyslogInlineFormatTimestampOverrideIso8601Utc captures enum value "iso_8601_utc"
	EmsSyslogInlineFormatTimestampOverrideIso8601Utc string = "iso_8601_utc"
)

// prop value enum
func (m *EmsSyslogInlineFormat) validateTimestampOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsSyslogInlineFormatTypeTimestampOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EmsSyslogInlineFormat) validateTimestampOverride(formats strfmt.Registry) error {
	if swag.IsZero(m.TimestampOverride) { // not required
		return nil
	}

	// value enum
	if err := m.validateTimestampOverrideEnum("format"+"."+"timestamp_override", "body", *m.TimestampOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ems syslog inline format based on context it is used
func (m *EmsSyslogInlineFormat) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmsSyslogInlineFormat) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsSyslogInlineFormat) UnmarshalBinary(b []byte) error {
	var res EmsSyslogInlineFormat
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
