// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmsUIMessage Information to be displayed to the user.
//
// swagger:model ems_ui_message
type EmsUIMessage struct {

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message arguments
	// Read Only: true
	EmsUIMessageInlineArguments []*EmsUIMessageInlineArgumentsInlineArrayItem `json:"arguments,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems ui message
func (m *EmsUIMessage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEmsUIMessageInlineArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsUIMessage) validateEmsUIMessageInlineArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.EmsUIMessageInlineArguments) { // not required
		return nil
	}

	for i := 0; i < len(m.EmsUIMessageInlineArguments); i++ {
		if swag.IsZero(m.EmsUIMessageInlineArguments[i]) { // not required
			continue
		}

		if m.EmsUIMessageInlineArguments[i] != nil {
			if err := m.EmsUIMessageInlineArguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems ui message based on the context it is used
func (m *EmsUIMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmsUIMessageInlineArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsUIMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsUIMessage) contextValidateEmsUIMessageInlineArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "arguments", "body", []*EmsUIMessageInlineArgumentsInlineArrayItem(m.EmsUIMessageInlineArguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.EmsUIMessageInlineArguments); i++ {

		if m.EmsUIMessageInlineArguments[i] != nil {
			if err := m.EmsUIMessageInlineArguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EmsUIMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsUIMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsUIMessage) UnmarshalBinary(b []byte) error {
	var res EmsUIMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// EmsUIMessageInlineArgumentsInlineArrayItem ems ui message inline arguments inline array item
//
// swagger:model ems_ui_message_inline_arguments_inline_array_item
type EmsUIMessageInlineArgumentsInlineArrayItem struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems ui message inline arguments inline array item
func (m *EmsUIMessageInlineArgumentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems ui message inline arguments inline array item based on the context it is used
func (m *EmsUIMessageInlineArgumentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmsUIMessageInlineArgumentsInlineArrayItem) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *EmsUIMessageInlineArgumentsInlineArrayItem) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EmsUIMessageInlineArgumentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmsUIMessageInlineArgumentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsUIMessageInlineArgumentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
