// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Entitlement entitlement
//
// swagger:model entitlement
type Entitlement struct {

	// Entitlement action to be taken to mitigate the risk
	// Read Only: true
	// Enum: ["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]
	Action *string `json:"action,omitempty"`

	// Entitlement risk of the package
	// Read Only: true
	// Enum: ["high","medium","low","unlicensed","unknown"]
	Risk *string `json:"risk,omitempty"`
}

// Validate validates this entitlement
func (m *Entitlement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRisk(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var entitlementTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		entitlementTypeActionPropEnum = append(entitlementTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// action
	// Action
	// acquire_license
	// END DEBUGGING
	// EntitlementActionAcquireLicense captures enum value "acquire_license"
	EntitlementActionAcquireLicense string = "acquire_license"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// action
	// Action
	// adjust_capacity
	// END DEBUGGING
	// EntitlementActionAdjustCapacity captures enum value "adjust_capacity"
	EntitlementActionAdjustCapacity string = "adjust_capacity"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// action
	// Action
	// verify_entitlement
	// END DEBUGGING
	// EntitlementActionVerifyEntitlement captures enum value "verify_entitlement"
	EntitlementActionVerifyEntitlement string = "verify_entitlement"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// action
	// Action
	// verify_system_health
	// END DEBUGGING
	// EntitlementActionVerifySystemHealth captures enum value "verify_system_health"
	EntitlementActionVerifySystemHealth string = "verify_system_health"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// action
	// Action
	// none
	// END DEBUGGING
	// EntitlementActionNone captures enum value "none"
	EntitlementActionNone string = "none"
)

// prop value enum
func (m *Entitlement) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, entitlementTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Entitlement) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

var entitlementTypeRiskPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","low","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		entitlementTypeRiskPropEnum = append(entitlementTypeRiskPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// risk
	// Risk
	// high
	// END DEBUGGING
	// EntitlementRiskHigh captures enum value "high"
	EntitlementRiskHigh string = "high"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// risk
	// Risk
	// medium
	// END DEBUGGING
	// EntitlementRiskMedium captures enum value "medium"
	EntitlementRiskMedium string = "medium"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// risk
	// Risk
	// low
	// END DEBUGGING
	// EntitlementRiskLow captures enum value "low"
	EntitlementRiskLow string = "low"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// risk
	// Risk
	// unlicensed
	// END DEBUGGING
	// EntitlementRiskUnlicensed captures enum value "unlicensed"
	EntitlementRiskUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// entitlement
	// Entitlement
	// risk
	// Risk
	// unknown
	// END DEBUGGING
	// EntitlementRiskUnknown captures enum value "unknown"
	EntitlementRiskUnknown string = "unknown"
)

// prop value enum
func (m *Entitlement) validateRiskEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, entitlementTypeRiskPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Entitlement) validateRisk(formats strfmt.Registry) error {
	if swag.IsZero(m.Risk) { // not required
		return nil
	}

	// value enum
	if err := m.validateRiskEnum("risk", "body", *m.Risk); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this entitlement based on the context it is used
func (m *Entitlement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Entitlement) contextValidateAction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

func (m *Entitlement) contextValidateRisk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "risk", "body", m.Risk); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Entitlement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Entitlement) UnmarshalBinary(b []byte) error {
	var res Entitlement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
